/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.sqlfilter.BoolExpression;
import com.rti.dds.sqlfilter.ParameterList;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.SqlWhereParser;
import com.rti.dds.util.Utilities;
import java.io.StringReader;

public final class FilterManager {
    private static final RuntimeException NULL_EXPRESSION = new RETCODE_BAD_PARAMETER("null SQL filter expression");
    private Class _typeClass = null;
    private BoolExpression _boolExpression = null;
    private ParameterList _parameterList = null;

    public FilterManager(String string, String string2, StringSeq stringSeq) throws ClassNotFoundException, ParseException {
        if (string == null) {
            Utilities.rethrow(NULL_EXPRESSION);
        }
        if (string2 == null) {
            throw new ClassNotFoundException("null data type class name (could be missing type code)");
        }
        this._typeClass = Class.forName(string2);
        this._parameterList = new ParameterList(stringSeq);
        this._boolExpression = new SqlWhereParser(this, new StringReader(string)).ParseExpression();
    }

    public boolean evaluate(Object object) {
        return this._boolExpression.evaluate(object);
    }

    public Class getTypeClass() {
        return this._typeClass;
    }

    public ParameterList getParameterList() {
        return this._parameterList;
    }
}

