/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.infrastructure.RETCODE_ILLEGAL_OPERATION;
import com.rti.dds.sqlfilter.CorbaUtilities;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.ReferenceException;
import com.rti.dds.sqlfilter.SpecialParseExceptions;
import com.rti.dds.util.AbstractSequence;
import com.rti.dds.util.ArraySequence;
import com.rti.dds.util.Union;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Reference {
    private String _fieldName = "";
    private Field field = null;
    private ArrayList _indexes = null;
    private boolean _isIndexed = false;
    private boolean _isUnionMember = false;
    private Method _unionFieldMethod = null;
    private boolean _isRegularCase = true;

    public Reference(String string, ArrayList arrayList) {
        this._fieldName = string;
        this._indexes = arrayList;
        if (this._indexes != null) {
            this._isIndexed = true;
            this._indexes.trimToSize();
        }
    }

    public Reference(String string) {
        this(string, null);
    }

    public Class parse(Class clazz) throws ParseException {
        Class clazz2 = null;
        if (Union.class.isAssignableFrom(clazz) || CorbaUtilities.isCorbaUnion(clazz)) {
            this._isUnionMember = true;
            try {
                this._unionFieldMethod = this.get_fieldName().equals("_d") ? clazz.getMethod("discriminator", null) : clazz.getMethod(this.get_fieldName(), null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            clazz2 = this._unionFieldMethod.getReturnType();
        } else {
            try {
                this.field = clazz.getField(this.get_fieldName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw SpecialParseExceptions.NO_SUCH_FIELD_EXCEPTION;
            }
            clazz2 = this.field.getType();
        }
        boolean bl = this._isRegularCase = !this._isUnionMember && !this._isIndexed;
        if (!this._isIndexed) {
            return clazz2;
        }
        for (int i = 0; i < this._indexes.size(); ++i) {
            if (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
                continue;
            }
            if ((class$com$rti$dds$util$AbstractSequence == null ? Reference.class$("com.rti.dds.util.AbstractSequence") : class$com$rti$dds$util$AbstractSequence).isAssignableFrom(clazz2)) {
                try {
                    clazz2 = ((AbstractSequence)clazz2.newInstance()).getElementType();
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
            if ((class$com$rti$dds$util$ArraySequence == null ? Reference.class$("com.rti.dds.util.ArraySequence") : class$com$rti$dds$util$ArraySequence).isAssignableFrom(clazz2)) {
                try {
                    clazz2 = ((ArraySequence)clazz2.newInstance()).getElementType();
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
            if ((clazz2 = this.extractTypeDefType(clazz2)) != null) {
                --i;
                continue;
            }
            throw SpecialParseExceptions.WRONG_DIMENSION_COUNT_ON_ARRAY;
        }
        if (this.isArrayOrSequence(clazz2)) {
            throw SpecialParseExceptions.WRONG_DIMENSION_COUNT_ON_ARRAY;
        }
        return clazz2;
    }

    private final boolean isArrayOrSequence(Class clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (AbstractSequence.class.isAssignableFrom(clazz)) {
            return true;
        }
        return ArraySequence.class.isAssignableFrom(clazz);
    }

    private final Class extractTypeDefType(Class clazz) {
        Field field = null;
        try {
            field = clazz.getField("userData");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        return field.getType();
    }

    public Object getValue(Object object) throws ReferenceException {
        if (this._isRegularCase) {
            try {
                return this.field.get(object);
            }
            catch (Exception exception) {
                throw ReferenceException.FIELD_GET_EXCEPTION;
            }
        }
        if (this._isUnionMember) {
            try {
                object = this._unionFieldMethod.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RETCODE_ILLEGAL_OPERATION) {
                    throw ReferenceException.WRONG_DISCRIMINATOR;
                }
                if (CorbaUtilities.isInstanceOf_org_omg_CORBA_BAD_OPERATION(invocationTargetException.getTargetException())) {
                    throw ReferenceException.WRONG_DISCRIMINATOR;
                }
                throw ReferenceException.FIELD_GET_EXCEPTION;
            }
            catch (Exception exception) {
                throw ReferenceException.FIELD_GET_EXCEPTION;
            }
        }
        try {
            object = this.field.get(object);
        }
        catch (Exception exception) {
            throw ReferenceException.FIELD_GET_EXCEPTION;
        }
        if (!this._isIndexed) {
            return object;
        }
        int n = -1;
        int n2 = 0;
        for (n2 = 0; n2 < this._indexes.size(); ++n2) {
            n = (Integer)this._indexes.get(n2);
            if (object.getClass().isArray()) {
                try {
                    object = Array.get(object, n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.throwIndexOutOfBoundsException(arrayIndexOutOfBoundsException, n2, n);
                }
                continue;
            }
            if ((class$com$rti$dds$util$AbstractSequence == null ? Reference.class$("com.rti.dds.util.AbstractSequence") : class$com$rti$dds$util$AbstractSequence).isAssignableFrom(object.getClass())) {
                try {
                    object = ((AbstractSequence)object).get(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.throwIndexOutOfBoundsException(indexOutOfBoundsException, n2, n);
                }
                continue;
            }
            if ((class$com$rti$dds$util$ArraySequence == null ? Reference.class$("com.rti.dds.util.ArraySequence") : class$com$rti$dds$util$ArraySequence).isAssignableFrom(object.getClass())) {
                try {
                    object = ((ArraySequence)object).get(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.throwIndexOutOfBoundsException(indexOutOfBoundsException, n2, n);
                }
                continue;
            }
            if ((object = this.extractTypeDefValue(object)) != null) {
                --n2;
                continue;
            }
            throw new RuntimeException("Expecting array or sequence, but none found");
        }
        return object;
    }

    private Object extractTypeDefValue(Object object) throws ReferenceException {
        Field field = null;
        Object object2 = null;
        try {
            field = object.getClass().getField("userData");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        try {
            object2 = field.get(object);
        }
        catch (Exception exception) {
            throw ReferenceException.FIELD_GET_EXCEPTION;
        }
        return object2;
    }

    private void throwIndexOutOfBoundsException(IndexOutOfBoundsException indexOutOfBoundsException, int n, int n2) throws ReferenceException {
        throw ReferenceException.INDEX_OUT_OF_BOUNDS_EXCEPTION;
    }

    public String get_fieldName() {
        return this._fieldName;
    }

    public boolean isIndexed() {
        return this._isIndexed;
    }

    public String toString() {
        String string = this._fieldName;
        if (this.isIndexed()) {
            for (int i = 0; i < this._indexes.size(); ++i) {
                string = string + "[" + this._indexes.get(i) + "]";
            }
        }
        return string;
    }
}

