/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.sqlfilter;

import com.rti.dds.sqlfilter.FilterManager;
import com.rti.dds.sqlfilter.ObjectValue;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.sqlfilter.Reference;
import com.rti.dds.sqlfilter.ReferenceException;

public class ReferenceList
extends ObjectValue {
    private Reference[] _refs = new Reference[1];
    private final FilterManager _filterManager;
    private Class _valueClass = null;
    private static final int INITIAL_REFS_SIZE = 1;
    private int _size = 0;

    public ReferenceList(FilterManager filterManager) {
        this._filterManager = filterManager;
    }

    public boolean add(Reference reference) {
        this.ensureCapacity(this._size + 1);
        this._refs[this._size++] = reference;
        return true;
    }

    public void ensureCapacity(int n) {
        int n2 = this._refs.length;
        if (n > n2) {
            Reference[] referenceArray = this._refs;
            this._refs = new Reference[n];
            System.arraycopy(referenceArray, 0, this._refs, 0, this._size);
        }
    }

    public void trimToSize() {
        int n = this._refs.length;
        if (this._size < n) {
            Reference[] referenceArray = this._refs;
            this._refs = new Reference[this._size];
            System.arraycopy(referenceArray, 0, this._refs, 0, this._size);
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this._size; ++i) {
            if (i > 0) {
                string = string + ".";
            }
            string = string + this._refs[i].toString();
        }
        return string;
    }

    public void parse() throws ParseException {
        this.trimToSize();
        Class clazz = this._filterManager.getTypeClass();
        this.parse(clazz);
    }

    private void parse(Class clazz) throws ParseException {
        this._valueClass = clazz;
        for (int i = 0; i < this._size; ++i) {
            this._valueClass = this._refs[i].parse(this._valueClass);
        }
    }

    public Object getValue() {
        return null;
    }

    public Object getValue(Object object) throws ReferenceException {
        for (int i = 0; i < this._size; ++i) {
            object = this._refs[i].getValue(object);
        }
        return object;
    }

    public Class getValueClass() {
        return this._valueClass;
    }

    public boolean isVariable() {
        return true;
    }
}

