/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.stringmatchfilter;

import com.rti.dds.infrastructure.ObjectHolder;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.sqlfilter.FilterManager;
import com.rti.dds.sqlfilter.ParseException;
import com.rti.dds.topic.ContentFilter;
import com.rti.dds.topic.FilterSampleInfo;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.util.Utilities;

public final class StringMatchFilter
implements ContentFilter {
    public static final String NAME = "DDSSTRINGMATCH";
    private static final RuntimeException NULL_ARGUMENT = new RETCODE_BAD_PARAMETER("null argument");
    private static final RuntimeException PARSE_ERROR = new RETCODE_BAD_PARAMETER("Parse error: invalid SQL expression");
    private static final RuntimeException CLASS_NOT_FOUND = new RETCODE_BAD_PARAMETER("Class not found");
    private static final RuntimeException WRONG_FILTER_TYPE = new RETCODE_BAD_PARAMETER("handle is not a filter instance");
    private static final RuntimeException WRONG_SAMPLE_TYPE = new RETCODE_BAD_PARAMETER("Wrong sample type");

    public void compile(ObjectHolder objectHolder, String string, StringSeq stringSeq, TypeCode typeCode, String string2, Object object) {
        FilterManager filterManager = null;
        try {
            filterManager = new FilterManager(string, string2, stringSeq);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Utilities.rethrow(CLASS_NOT_FOUND);
        }
        catch (ParseException parseException) {
            Utilities.rethrow(PARSE_ERROR);
        }
        objectHolder.value = filterManager;
    }

    public boolean evaluate(Object object, Object object2, FilterSampleInfo filterSampleInfo) {
        if (object == null) {
            Utilities.rethrow(NULL_ARGUMENT);
        }
        if (object2 == null) {
            Utilities.rethrow(NULL_ARGUMENT);
        }
        if (!(object instanceof FilterManager)) {
            Utilities.rethrow(WRONG_FILTER_TYPE);
        }
        FilterManager filterManager = (FilterManager)object;
        if (!object2.getClass().equals(filterManager.getTypeClass())) {
            Utilities.rethrow(WRONG_SAMPLE_TYPE);
        }
        return filterManager.evaluate(object2);
    }

    public void finalize(Object object) {
    }
}

