/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription.builtin;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.infrastructure.ContentFilterProperty_t;
import com.rti.dds.infrastructure.DeadlineQosPolicy;
import com.rti.dds.infrastructure.DestinationOrderQosPolicy;
import com.rti.dds.infrastructure.DurabilityQosPolicy;
import com.rti.dds.infrastructure.EntityNameQosPolicy;
import com.rti.dds.infrastructure.GUID_t;
import com.rti.dds.infrastructure.GroupDataQosPolicy;
import com.rti.dds.infrastructure.LatencyBudgetQosPolicy;
import com.rti.dds.infrastructure.LivelinessQosPolicy;
import com.rti.dds.infrastructure.LocatorSeq;
import com.rti.dds.infrastructure.OwnershipQosPolicy;
import com.rti.dds.infrastructure.PartitionQosPolicy;
import com.rti.dds.infrastructure.PresentationQosPolicy;
import com.rti.dds.infrastructure.ProductVersion_t;
import com.rti.dds.infrastructure.PropertyQosPolicy;
import com.rti.dds.infrastructure.ProtocolVersion_t;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.ReliabilityQosPolicy;
import com.rti.dds.infrastructure.ServiceQosPolicy;
import com.rti.dds.infrastructure.StringHelper;
import com.rti.dds.infrastructure.TimeBasedFilterQosPolicy;
import com.rti.dds.infrastructure.TopicDataQosPolicy;
import com.rti.dds.infrastructure.TypeConsistencyEnforcementQosPolicy;
import com.rti.dds.infrastructure.UserDataQosPolicy;
import com.rti.dds.infrastructure.VendorId_t;
import com.rti.dds.topic.AbstractBuiltinTopicData;
import com.rti.dds.topic.BuiltinTopicKey_t;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.typecode.TypeCodeFactory;
import com.rti.dds.typeobject.TypeObject;
import com.rti.dds.util.Utilities;

public final class SubscriptionBuiltinTopicData
extends AbstractBuiltinTopicData {
    public final BuiltinTopicKey_t key = this.create_keyI();
    public final BuiltinTopicKey_t participant_key;
    public String topic_name;
    public String type_name;
    public final DurabilityQosPolicy durability;
    public final DeadlineQosPolicy deadline;
    public final LatencyBudgetQosPolicy latency_budget;
    public final LivelinessQosPolicy liveliness;
    public final ReliabilityQosPolicy reliability;
    public final OwnershipQosPolicy ownership;
    public final DestinationOrderQosPolicy destination_order;
    public final UserDataQosPolicy user_data;
    public final TimeBasedFilterQosPolicy time_based_filter;
    public final PresentationQosPolicy presentation;
    public final PartitionQosPolicy partition;
    public final TypeConsistencyEnforcementQosPolicy type_consistency;
    public final TopicDataQosPolicy topic_data;
    public final GroupDataQosPolicy group_data;
    public TypeCode type_code;
    public final BuiltinTopicKey_t subscriber_key;
    public final PropertyQosPolicy property;
    public final LocatorSeq unicast_locators;
    public final LocatorSeq multicast_locators;
    public final ContentFilterProperty_t content_filter_property;
    public final GUID_t virtual_guid;
    public final ServiceQosPolicy service;
    public final ProtocolVersion_t rtps_protocol_version;
    public final VendorId_t rtps_vendor_id;
    public final ProductVersion_t product_version;
    public boolean disable_positive_acks;
    public boolean expects_inline_qos;
    public int receive_queue_size;
    public boolean is_incompatible;
    public final EntityNameQosPolicy subscription_name;
    public TypeObject type;
    private static final int MEMBER_COUNT = 27;

    public SubscriptionBuiltinTopicData() {
        super(27);
        this.add(this.key);
        this.participant_key = this.create_keyI();
        this.add(this.participant_key);
        this.topic_name = "";
        this.type_name = "";
        this.durability = SubscriptionBuiltinTopicData.create_durability_policyI();
        this.add(this.durability);
        this.deadline = SubscriptionBuiltinTopicData.create_deadline_policyI();
        this.add(this.deadline);
        this.latency_budget = SubscriptionBuiltinTopicData.create_latency_budget_policyI();
        this.add(this.latency_budget);
        this.liveliness = SubscriptionBuiltinTopicData.create_liveliness_policyI();
        this.add(this.liveliness);
        this.reliability = SubscriptionBuiltinTopicData.create_reliability_policyI();
        this.add(this.reliability);
        this.ownership = SubscriptionBuiltinTopicData.create_ownership_policyI();
        this.add(this.ownership);
        this.destination_order = SubscriptionBuiltinTopicData.create_destination_order_policyI();
        this.add(this.destination_order);
        this.user_data = SubscriptionBuiltinTopicData.create_user_data_policyI();
        this.add(this.user_data);
        this.time_based_filter = SubscriptionBuiltinTopicData.create_time_based_filter_policyI();
        this.add(this.time_based_filter);
        this.presentation = SubscriptionBuiltinTopicData.create_presentation_policyI();
        this.add(this.presentation);
        this.partition = SubscriptionBuiltinTopicData.create_partition_policyI();
        this.add(this.partition);
        this.type_consistency = SubscriptionBuiltinTopicData.create_type_consistency_enforcement_policyI();
        this.add(this.type_consistency);
        this.topic_data = SubscriptionBuiltinTopicData.create_topic_data_policyI();
        this.add(this.topic_data);
        this.group_data = SubscriptionBuiltinTopicData.create_group_data_policyI();
        this.add(this.group_data);
        this.type_code = null;
        this.subscriber_key = this.create_keyI();
        this.add(this.subscriber_key);
        this.property = SubscriptionBuiltinTopicData.create_property_policyI();
        this.add(this.property);
        this.unicast_locators = this.create_locatorSeqI();
        this.add(this.unicast_locators);
        this.multicast_locators = this.create_locatorSeqI();
        this.add(this.multicast_locators);
        this.content_filter_property = this.create_content_filter_propertyI();
        this.add(this.content_filter_property);
        this.virtual_guid = this.create_guidI();
        this.add(this.virtual_guid);
        this.service = SubscriptionBuiltinTopicData.create_service_policyI();
        this.add(this.service);
        this.rtps_protocol_version = this.create_protocol_versionI();
        this.add(this.rtps_protocol_version);
        this.rtps_vendor_id = this.create_vendorIdI();
        this.add(this.rtps_vendor_id);
        this.product_version = this.create_product_versionI();
        this.add(this.product_version);
        this.disable_positive_acks = false;
        this.expects_inline_qos = false;
        this.receive_queue_size = 1;
        this.is_incompatible = false;
        this.subscription_name = SubscriptionBuiltinTopicData.create_entity_name_policyI();
        this.add(this.subscription_name);
        this.type = null;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else {
            bl = super.equals(object);
            if (bl) {
                SubscriptionBuiltinTopicData subscriptionBuiltinTopicData = (SubscriptionBuiltinTopicData)object;
                if (this.disable_positive_acks != subscriptionBuiltinTopicData.disable_positive_acks) {
                    return false;
                }
                if (this.expects_inline_qos != subscriptionBuiltinTopicData.expects_inline_qos) {
                    return false;
                }
                if (this.receive_queue_size != subscriptionBuiltinTopicData.receive_queue_size) {
                    return false;
                }
                if (this.is_incompatible != subscriptionBuiltinTopicData.is_incompatible) {
                    return false;
                }
                if (!this.type_consistency.equals(subscriptionBuiltinTopicData.type_consistency)) {
                    return false;
                }
                if (subscriptionBuiltinTopicData.type != null && this.type == null) {
                    return false;
                }
                if (subscriptionBuiltinTopicData.type == null && this.type != null) {
                    return false;
                }
                if (this.type != null && !this.type.equals(subscriptionBuiltinTopicData.type)) {
                    return false;
                }
                boolean bl2 = bl = Utilities.equalsNullSafe(this.topic_name, subscriptionBuiltinTopicData.topic_name) && Utilities.equalsNullSafe(this.type_name, subscriptionBuiltinTopicData.type_name);
                if (bl) {
                    if (subscriptionBuiltinTopicData.type_code != null && this.type_code == null) {
                        bl = false;
                    } else if (subscriptionBuiltinTopicData.type_code == null && this.type_code != null) {
                        bl = false;
                    } else if (this.type_code != null) {
                        bl = this.type_code.equal(subscriptionBuiltinTopicData.type_code);
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return super.hashCode() + Utilities.hashCodeNullSafe(this.topic_name) + Utilities.hashCodeNullSafe(this.type_name) + (this.disable_positive_acks ? 1 : 0) + (this.expects_inline_qos ? 1 : 0) + (this.is_incompatible ? 1 : 0) + this.type_consistency.hashCode();
    }

    public void pull_from_nativeI(long l) {
        this.key.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_keyI(l));
        this.participant_key.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_participant_keyI(l));
        this.subscriber_key.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_subscriber_keyI(l));
        this.topic_name = StringHelper.dup_native_stringI(SubscriptionBuiltinTopicData.get_native_topic_nameI(l));
        this.type_name = StringHelper.dup_native_stringI(SubscriptionBuiltinTopicData.get_native_type_nameI(l));
        this.disable_positive_acks = SubscriptionBuiltinTopicData.get_native_disable_positive_acksI(l);
        this.durability.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_durabilityI(l));
        this.deadline.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_deadlineI(l));
        this.latency_budget.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_latency_budgetI(l));
        this.liveliness.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_livelinessI(l));
        this.reliability.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_reliabilityI(l));
        this.ownership.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_ownershipI(l));
        this.destination_order.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_destination_orderI(l));
        this.user_data.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_user_dataI(l));
        this.time_based_filter.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_time_based_filterI(l));
        this.presentation.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_presentationI(l));
        this.partition.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_partitionI(l));
        this.topic_data.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_topic_dataI(l));
        this.group_data.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_group_dataI(l));
        try {
            this.type_code = this.get_type_codeI(SubscriptionBuiltinTopicData.get_native_type_codeI(l));
        }
        catch (Exception exception) {
            this.type_code = null;
        }
        long l2 = SubscriptionBuiltinTopicData.get_native_typeI(l);
        if (l2 == 0L) {
            this.type = null;
        } else {
            this.type = new TypeObject();
            this.type.pull_from_nativeI(l2);
        }
        long l3 = SubscriptionBuiltinTopicData.get_native_property_pointerI(l);
        this.property.pull_from_nativeI(l3);
        this.unicast_locators.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_unicast_locatorsI(l));
        this.multicast_locators.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_multicast_locatorsI(l));
        this.content_filter_property.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_content_filter_propertyI(l));
        this.virtual_guid.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_virtual_guidI(l));
        this.service.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_serviceI(l));
        long l4 = SubscriptionBuiltinTopicData.get_native_rtps_protocol_versionI(l);
        this.rtps_protocol_version.pull_from_nativeI(l4);
        long l5 = SubscriptionBuiltinTopicData.get_native_rtps_vendor_idI(l);
        this.rtps_vendor_id.pull_from_nativeI(l5);
        long l6 = SubscriptionBuiltinTopicData.get_native_product_versionI(l);
        this.product_version.pull_from_nativeI(l6);
        this.expects_inline_qos = SubscriptionBuiltinTopicData.get_native_expects_inline_qosI(l);
        this.receive_queue_size = SubscriptionBuiltinTopicData.get_native_receive_queue_sizeI(l);
        this.is_incompatible = SubscriptionBuiltinTopicData.get_native_is_incompatibleI(l);
        long l7 = SubscriptionBuiltinTopicData.get_native_subscription_name_pointerI(l);
        this.subscription_name.pull_from_nativeI(l7);
        this.type_consistency.pull_from_nativeI(SubscriptionBuiltinTopicData.get_native_type_consistencyI(l));
    }

    public void push_to_nativeI(long l) {
        this.key.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_keyI(l));
        this.participant_key.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_participant_keyI(l));
        this.subscriber_key.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_subscriber_keyI(l));
        int n = StringHelper.replace_native_stringI(SubscriptionBuiltinTopicData.get_native_topic_nameI(l), this.topic_name);
        RETCODE_ERROR.check_return_codeI(n);
        n = StringHelper.replace_native_stringI(SubscriptionBuiltinTopicData.get_native_type_nameI(l), this.type_name);
        RETCODE_ERROR.check_return_codeI(n);
        this.durability.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_durabilityI(l));
        this.deadline.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_deadlineI(l));
        this.latency_budget.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_latency_budgetI(l));
        this.liveliness.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_livelinessI(l));
        this.reliability.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_reliabilityI(l));
        this.ownership.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_ownershipI(l));
        this.destination_order.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_destination_orderI(l));
        this.user_data.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_user_dataI(l));
        this.time_based_filter.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_time_based_filterI(l));
        this.presentation.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_presentationI(l));
        this.partition.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_partitionI(l));
        this.topic_data.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_topic_dataI(l));
        this.group_data.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_group_dataI(l));
        SubscriptionBuiltinTopicData.push_disable_positive_acks_to_nativeI(l, this.disable_positive_acks);
        this.push_type_code_to_nativeI(SubscriptionBuiltinTopicData.get_native_type_codeI(l));
        long l2 = SubscriptionBuiltinTopicData.get_native_property_pointerI(l);
        this.property.push_to_nativeI(l2);
        this.unicast_locators.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_unicast_locatorsI(l));
        this.multicast_locators.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_multicast_locatorsI(l));
        this.content_filter_property.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_content_filter_propertyI(l));
        this.virtual_guid.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_virtual_guidI(l));
        this.service.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_serviceI(l));
        long l3 = SubscriptionBuiltinTopicData.get_native_rtps_protocol_versionI(l);
        this.rtps_protocol_version.push_to_nativeI(l3);
        long l4 = SubscriptionBuiltinTopicData.get_native_rtps_vendor_idI(l);
        this.rtps_vendor_id.push_to_nativeI(l4);
        long l5 = SubscriptionBuiltinTopicData.get_native_product_versionI(l);
        this.product_version.push_to_nativeI(l5);
        SubscriptionBuiltinTopicData.push_expects_inline_qos_to_nativeI(l, this.expects_inline_qos);
        SubscriptionBuiltinTopicData.push_receive_queue_size_to_nativeI(l, this.receive_queue_size);
        SubscriptionBuiltinTopicData.push_is_incompatible_to_nativeI(l, this.is_incompatible);
        long l6 = SubscriptionBuiltinTopicData.get_native_subscription_name_pointerI(l);
        this.subscription_name.push_to_nativeI(l6);
        this.type_consistency.push_to_nativeI(SubscriptionBuiltinTopicData.get_native_type_consistencyI(l));
    }

    private TypeCode get_type_codeI(long l) {
        if (l == 0L) {
            return null;
        }
        return TypeCodeFactory.TheTypeCodeFactory.create_tc_from_native(l);
    }

    private void push_type_code_to_nativeI(long l) {
        if (this.type_code == null) {
            return;
        }
        CdrBuffer cdrBuffer = new CdrBuffer(TypeCode.RTI_CDR_TYPE_CODE_MAX_SERIALIZED_SIZE);
        CdrOutputStream cdrOutputStream = new CdrOutputStream(cdrBuffer);
        int n = SubscriptionBuiltinTopicData.get_native_type_code_sizeI(l);
        cdrOutputStream.reset();
        this.type_code.serialize(cdrOutputStream);
        cdrOutputStream.flushToNative(l, n);
    }

    private static native long get_native_keyI(long var0);

    private static native long get_native_participant_keyI(long var0);

    private static native long get_native_subscriber_keyI(long var0);

    private static native long get_native_topic_nameI(long var0);

    private static native long get_native_type_nameI(long var0);

    private static native long get_native_durabilityI(long var0);

    private static native long get_native_deadlineI(long var0);

    private static native long get_native_latency_budgetI(long var0);

    private static native long get_native_livelinessI(long var0);

    private static native long get_native_reliabilityI(long var0);

    private static native long get_native_ownershipI(long var0);

    private static native long get_native_destination_orderI(long var0);

    private static native long get_native_user_dataI(long var0);

    private static native long get_native_time_based_filterI(long var0);

    private static native long get_native_presentationI(long var0);

    private static native long get_native_partitionI(long var0);

    private static native long get_native_topic_dataI(long var0);

    private static native long get_native_group_dataI(long var0);

    private static native long get_native_type_codeI(long var0);

    private static native long get_native_unicast_locatorsI(long var0);

    private static native long get_native_multicast_locatorsI(long var0);

    private static native long get_native_content_filter_propertyI(long var0);

    private static native long get_native_virtual_guidI(long var0);

    private static native long get_native_serviceI(long var0);

    private static native long get_native_type_consistencyI(long var0);

    private static native int get_native_type_code_sizeI(long var0);

    private static native long get_native_property_pointerI(long var0);

    private static native boolean flush_type_code_stream_to_javaI(byte[] var0, long var1);

    private static native long get_native_rtps_protocol_versionI(long var0);

    private static native long get_native_rtps_vendor_idI(long var0);

    private static native long get_native_product_versionI(long var0);

    private static native boolean get_native_disable_positive_acksI(long var0);

    private static native void push_disable_positive_acks_to_nativeI(long var0, boolean var2);

    private static native boolean get_native_expects_inline_qosI(long var0);

    private static native void push_expects_inline_qos_to_nativeI(long var0, boolean var2);

    private static native int get_native_receive_queue_sizeI(long var0);

    private static native boolean get_native_is_incompatibleI(long var0);

    private static native void push_receive_queue_size_to_nativeI(long var0, int var2);

    private static native void push_is_incompatible_to_nativeI(long var0, boolean var2);

    private static native long get_native_subscription_name_pointerI(long var0);

    private static native long get_native_typeI(long var0);
}

