/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.topic;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.StatusCondition;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.topic.InconsistentTopicStatus;
import com.rti.dds.topic.NativeTopicDescription;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicDescriptionImpl;
import com.rti.dds.topic.TopicListener;
import com.rti.dds.topic.TopicListenerImpl;
import com.rti.dds.topic.TopicQos;
import com.rti.dds.topic.TypeSupportImpl;

public final class TopicImpl
extends NativeTopicDescription
implements Topic {
    private final EntityImpl _asEntity;
    private final TopicDescriptionImpl _asTopicDescription;
    private final NativeStructMixin _inconsistentTopicStatus = new InconsistentTopicStatusMixin();

    public static native long DDS_Topic_narrow(long var0);

    public TopicImpl(long l, TopicListener topicListener, int n) {
        super(l);
        long l2 = TopicImpl.DDS_Topic_as_topicdescription(l);
        this._asTopicDescription = new TopicDescriptionImpl(l2);
        long l3 = TopicImpl.DDS_Topic_as_Entity(l);
        this._asEntity = new EntityImpl(l3, new TopicQosMixin(), new TopicListenerImpl(topicListener, n, l, l3));
    }

    public long get_native_entity_pointerI() {
        return this._asEntity.get_native_pointer();
    }

    public static native Object get_topicI(long var0);

    public DataWriter create_datawriterI(long l, DataWriterListener dataWriterListener, int n) {
        return this._asTopicDescription.create_datawriterI(l, dataWriterListener, n);
    }

    public long get_native_topic_description_pointerI() {
        return this._asTopicDescription.get_native_pointer();
    }

    public DataReader create_datareaderI(long l, DataReaderListener dataReaderListener, int n) {
        return this._asTopicDescription.create_datareaderI(l, dataReaderListener, n);
    }

    public TypeSupportImpl get_data_type() {
        return this._asTopicDescription.get_data_type();
    }

    public void on_native_entity_finalized() {
        this._asEntity.cleanup();
        this._asTopicDescription.cleanup();
        this._inconsistentTopicStatus.cleanup();
    }

    public void get_inconsistent_topic_status(InconsistentTopicStatus inconsistentTopicStatus) {
        this._inconsistentTopicStatus.get_untypedI(inconsistentTopicStatus);
    }

    public void set_inconsistent_topic_statusT(InconsistentTopicStatus inconsistentTopicStatus) {
        this._inconsistentTopicStatus.set_untypedI(inconsistentTopicStatus, false, false, null);
    }

    public TopicListener get_listener() {
        return (TopicListener)this._asEntity.get_untyped_listenerI();
    }

    public void set_listener(TopicListener topicListener, int n) {
        this._asEntity.set_untyped_listenerI(topicListener, n);
    }

    public void call_listenerT(int n) {
        this.check_aliveI();
        TopicImpl.DDS_Topic_call_listener(this.get_native_pointer(), n);
    }

    public void get_qos(TopicQos topicQos) {
        this._asEntity.get_untyped_qos(topicQos);
    }

    public void set_qos(TopicQos topicQos) {
        boolean bl = topicQos == DomainParticipant.TOPIC_QOS_DEFAULT;
        this._asEntity.set_untyped_qos(topicQos, bl, null);
    }

    public void set_qos_with_profile(String string, String string2) {
        TopicQos topicQos = new TopicQos();
        DomainParticipantFactory.get_instance().get_topic_qos_from_profile(topicQos, string, string2);
        this.set_qos(topicQos);
        topicQos = null;
    }

    public void enable() {
        this._asEntity.enable();
    }

    public void lock() {
        this._asEntity.lock();
    }

    public void unlock() {
        this._asEntity.unlock();
    }

    public StatusCondition get_statuscondition() {
        return this._asEntity.get_statuscondition();
    }

    public int get_status_changes() {
        return this._asEntity.get_status_changes();
    }

    public InstanceHandle_t get_instance_handle() {
        return this._asEntity.get_instance_handle();
    }

    public String get_type_name() {
        return this._asTopicDescription.get_type_name();
    }

    public String get_name() {
        return this._asTopicDescription.get_name();
    }

    public DomainParticipant get_participant() {
        return this._asTopicDescription.get_participant();
    }

    private static native long DDS_Topic_as_Entity(long var0);

    private static native long DDS_Topic_as_topicdescription(long var0);

    private static native int DDS_Topic_get_inconsistent_topic_status(long var0, long var2);

    private static native int DDS_Topic_set_inconsistent_topic_status(long var0, long var2);

    private static native long get_scratchpad_inconsistent_topic_statusI(long var0);

    private static native int DDS_Topic_get_qos(long var0, long var2);

    private static native int DDS_Topic_set_qos(long var0, long var2, boolean var4);

    private static native long get_scratchpad_topic_qosI(long var0);

    private static native int DDS_Topic_call_listener(long var0, int var2);

    private final class InconsistentTopicStatusMixin
    extends NativeStructMixin {
        public InconsistentTopicStatusMixin() {
            super(TopicImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return TopicImpl.get_scratchpad_inconsistent_topic_statusI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return TopicImpl.DDS_Topic_get_inconsistent_topic_status(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return TopicImpl.DDS_Topic_set_inconsistent_topic_status(l, l2);
        }
    }

    private final class TopicQosMixin
    extends NativeStructMixin {
        public TopicQosMixin() {
            super(TopicImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return TopicImpl.get_scratchpad_topic_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return TopicImpl.DDS_Topic_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return TopicImpl.DDS_Topic_set_qos(l, l2, bl);
        }
    }
}

