/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.type.builtin;

import com.rti.dds.cdr.CdrEncapsulation;
import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.topic.DefaultEndpointBuiltinTypeConfigData;
import com.rti.dds.topic.DefaultEndpointData;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.topic.TypeSupportType;
import com.rti.dds.type.builtin.Bytes;
import com.rti.dds.type.builtin.BytesDataReader;
import com.rti.dds.type.builtin.BytesDataWriter;

public class BytesTypeSupport
extends TypeSupportImpl
implements TypeSupport {
    static final String TYPE_NAME = "DDS::Octets";
    private static final char[] PLUGIN_VERSION = new char[]{'\u0002', '\u0000', '\u0000', '\u0000'};
    private static final BytesTypeSupport _singleton = new BytesTypeSupport();

    public static void register_type(DomainParticipant domainParticipant, String string) {
        _singleton.register_typeI(domainParticipant, string);
    }

    public static void unregister_type(DomainParticipant domainParticipant, String string) {
        _singleton.unregister_typeI(domainParticipant, string);
    }

    public static String get_type_name() {
        return _singleton.get_type_nameI();
    }

    public static BytesTypeSupport get_instance() {
        return _singleton;
    }

    public Object create_data() {
        return new Bytes();
    }

    public Object create_data(Object object) {
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        return new Bytes(defaultEndpointBuiltinTypeConfigData.allocSize);
    }

    public void destroy_data(Object object) {
    }

    public Object create_key() {
        return null;
    }

    public Object create_key(Object object) {
        return null;
    }

    public void destroy_key(Object object) {
    }

    public Object copy_data(Object object, Object object2) {
        Bytes bytes = (Bytes)object;
        Bytes bytes2 = (Bytes)object2;
        return bytes.copy_from(bytes2);
    }

    public Class get_type() {
        return Bytes.class;
    }

    public long get_serialized_sample_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        l += CdrPrimitiveType.BYTE.getArrayMaxSizeSerialized(l, defaultEndpointBuiltinTypeConfigData.allocSize);
        return l - l2;
    }

    public long get_serialized_sample_min_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        return l - l2;
    }

    public long get_serialized_sample_size(Object object, boolean bl, short s, long l, Object object2) {
        long l2 = l;
        Bytes bytes = (Bytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        if (bytes.length > 0) {
            l += CdrPrimitiveType.BYTE.getArrayMaxSizeSerialized(l, bytes.length);
        }
        return l - l2;
    }

    public long get_serialized_key_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        if (bl) {
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        return l - l2;
    }

    public void serialize(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        Bytes bytes = (Bytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl2) {
            if (bytes.value == null && bytes.length != 0) {
                throw new RETCODE_ERROR("value cannot be null");
            }
            if (bytes.length > defaultEndpointBuiltinTypeConfigData.allocSize) {
                throw new RETCODE_ERROR("length cannot be greater or equal than alloc size");
            }
        }
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
        if (bl2) {
            cdrOutputStream.writeInt(bytes.length);
            if (bytes.length > 0) {
                cdrOutputStream.writeByteArray(bytes.value, bytes.offset, bytes.length);
            }
        }
    }

    public void serialize_key(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
    }

    public Object deserialize_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        Bytes bytes = (Bytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        if (bl2) {
            bytes.length = cdrInputStream.readInt();
            bytes.offset = 0;
            if (bytes.length > defaultEndpointBuiltinTypeConfigData.allocSize) {
                throw new RETCODE_ERROR("length greater than allocSize");
            }
            if (bytes.length > 0) {
                cdrInputStream.readByteArray(bytes.value, bytes.length);
            }
        }
        return object2;
    }

    public Object deserialize_key_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        return object2;
    }

    public void skip(Object object, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object2) {
        if (bl) {
            cdrInputStream.skipEncapsulation();
        }
        if (bl2) {
            int n = cdrInputStream.readInt();
            cdrInputStream.skipByteArray(n);
        }
    }

    protected DataWriter create_datawriter(long l, DataWriterListener dataWriterListener, int n) {
        return new BytesDataWriter(l, dataWriterListener, n, this);
    }

    protected DataReader create_datareader(long l, DataReaderListener dataReaderListener, int n) {
        return new BytesDataReader(l, dataReaderListener, n, this);
    }

    protected BytesTypeSupport() {
        super(TYPE_NAME, false, null, Bytes.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }

    protected BytesTypeSupport(boolean bl) {
        super(TYPE_NAME, bl, null, Bytes.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }
}

