/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.type.builtin;

import com.rti.dds.cdr.CdrHelper;
import com.rti.dds.infrastructure.Copyable;
import java.io.Serializable;

public class KeyedBytes
implements Copyable,
Serializable {
    private static final long serialVersionUID = 5807966923179238997L;
    public String key = "";
    public int length = 0;
    public int offset = 0;
    public byte[] value = null;

    public KeyedBytes() {
    }

    public KeyedBytes(KeyedBytes keyedBytes) {
        this.copy_from(keyedBytes);
    }

    public KeyedBytes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size");
        }
        this.value = new byte[n];
        this.offset = 0;
        this.length = n;
    }

    public static Object create() {
        return new KeyedBytes();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyedBytes keyedBytes = (KeyedBytes)object;
        if (!this.key.equals(keyedBytes.key)) {
            return false;
        }
        if (this.length != keyedBytes.length) {
            return false;
        }
        int n = this.offset;
        int n2 = keyedBytes.offset;
        while (n < this.offset + this.length) {
            if (this.value[n] != keyedBytes.value[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.key != null) {
            n += this.key.hashCode();
        }
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            n += this.value[i];
        }
        return n;
    }

    public Object copy_from(Object object) {
        if (object == null) {
            throw new NullPointerException("src");
        }
        KeyedBytes keyedBytes = (KeyedBytes)object;
        KeyedBytes keyedBytes2 = this;
        keyedBytes2.key = keyedBytes.key;
        keyedBytes2.length = keyedBytes.length;
        keyedBytes2.offset = 0;
        if (keyedBytes.value == null) {
            keyedBytes2.value = null;
        } else if (keyedBytes2.value == null || keyedBytes2.value.length < keyedBytes.length) {
            keyedBytes2.value = new byte[keyedBytes.length];
            System.arraycopy(keyedBytes.value, keyedBytes.offset, keyedBytes2.value, keyedBytes2.offset, keyedBytes.length);
        }
        return this;
    }

    public String toString() {
        return this.toString("", 0);
    }

    public String toString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            CdrHelper.printIndent(stringBuffer, n);
            stringBuffer.append(string).append(":\n");
        }
        CdrHelper.printIndent(stringBuffer, n + 1);
        stringBuffer.append("key: ").append(this.key).append("\n");
        CdrHelper.printIndent(stringBuffer, n + 1);
        stringBuffer.append("length: ").append(this.length).append("\n");
        CdrHelper.printIndent(stringBuffer, n + 1);
        stringBuffer.append("value: ");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.value[i]);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

