/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.typecode;

import com.rti.dds.infrastructure.Bounds;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.typecode.TypeCodeRepresentation;
import com.rti.dds.util.Utilities;
import java.io.Serializable;

class SparseMember
implements Serializable {
    public String name;
    public TypeCodeRepresentation[] representations;
    public byte member_flags;
    public short access;

    public SparseMember(String string, TypeCodeRepresentation[] typeCodeRepresentationArray, byte by, short s) {
        this.name = string;
        this.representations = new TypeCodeRepresentation[typeCodeRepresentationArray.length];
        for (int i = 0; i < typeCodeRepresentationArray.length; ++i) {
            this.representations[i] = new TypeCodeRepresentation(typeCodeRepresentationArray[i].pid, typeCodeRepresentationArray[i].is_pointer, typeCodeRepresentationArray[i].bits, typeCodeRepresentationArray[i].type);
        }
        this.member_flags = by;
        this.access = s;
    }

    public int member_representation_count() {
        return this.representations.length;
    }

    public int member_representation_id(int n) throws Bounds {
        if (n < 0 || n >= this.representations.length) {
            throw new Bounds();
        }
        return this.representations[n].pid;
    }

    public boolean is_member_representation_pointer(int n) throws Bounds {
        if (n < 0 || n >= this.representations.length) {
            throw new Bounds();
        }
        return this.representations[n].is_pointer;
    }

    public boolean is_member_representation_bitfield(int n) throws Bounds {
        if (n < 0 || n >= this.representations.length) {
            throw new Bounds();
        }
        return this.representations[n].bits >= 0;
    }

    public short member_representation_bitfield_bits(int n) throws Bounds {
        if (n < 0 || n >= this.representations.length) {
            throw new Bounds();
        }
        return this.representations[n].bits;
    }

    public TypeCode member_representation_type(int n) throws Bounds {
        if (n < 0 || n >= this.representations.length) {
            throw new Bounds();
        }
        return this.representations[n].type;
    }

    public boolean is_member_bitfield() {
        try {
            return this.is_member_representation_bitfield(0);
        }
        catch (Bounds bounds) {
            IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
            throw illegalStateException;
        }
    }

    public TypeCode get_type() {
        try {
            return this.member_representation_type(0);
        }
        catch (Bounds bounds) {
            IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
            throw illegalStateException;
        }
    }

    public boolean is_pointer() {
        try {
            return this.is_member_representation_pointer(0);
        }
        catch (Bounds bounds) {
            IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
            throw illegalStateException;
        }
    }

    public short bits() {
        try {
            return this.member_representation_bitfield_bits(0);
        }
        catch (Bounds bounds) {
            IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
            throw illegalStateException;
        }
    }

    public int hashCode() {
        int n = 0;
        n += Utilities.hashCodeNullSafe(this.name);
        for (int i = 0; i < this.representations.length; ++i) {
            n += this.representations[i].hashCode();
        }
        n += this.member_flags;
        return n += this.access;
    }

    public boolean equal(SparseMember sparseMember) {
        if (!Utilities.equalsNullSafe(this.name, sparseMember.name)) {
            return false;
        }
        if (this.representations.length != sparseMember.representations.length) {
            return false;
        }
        for (int i = 0; i < this.representations.length; ++i) {
            if (this.representations[i].equal(sparseMember.representations[i])) continue;
            return false;
        }
        if (this.member_flags != sparseMember.member_flags) {
            return false;
        }
        return this.access == sparseMember.access;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof SparseMember) {
            return this.equal((SparseMember)object);
        }
        return false;
    }
}

