/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.typecode;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.infrastructure.BAD_PARAM;
import com.rti.dds.infrastructure.BadKind;
import com.rti.dds.infrastructure.BadMemberId;
import com.rti.dds.infrastructure.BadMemberName;
import com.rti.dds.infrastructure.Bounds;
import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_ILLEGAL_OPERATION;
import com.rti.dds.infrastructure.UserException;
import com.rti.dds.typecode.EnumMember;
import com.rti.dds.typecode.ExtensibilityKind;
import com.rti.dds.typecode.SparseMember;
import com.rti.dds.typecode.StructMember;
import com.rti.dds.typecode.TCKind;
import com.rti.dds.typecode.TypeCodeFactory;
import com.rti.dds.typecode.TypeCodeRepresentation;
import com.rti.dds.typecode.UnionMember;
import com.rti.dds.typecode.ValueMember;
import com.rti.dds.util.NativeInterface;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.MessageDigest;

public class TypeCode
implements Serializable {
    public static int RTI_CDR_TYPE_CODE_MAX_SERIALIZED_SIZE = 65535;
    public static final TypeCode TC_NULL = new TypeCode(TCKind.TK_NULL);
    public static final TypeCode TC_SHORT = new TypeCode(TCKind.TK_SHORT);
    public static final TypeCode TC_LONG = new TypeCode(TCKind.TK_LONG);
    public static final TypeCode TC_USHORT = new TypeCode(TCKind.TK_USHORT);
    public static final TypeCode TC_ULONG = new TypeCode(TCKind.TK_ULONG);
    public static final TypeCode TC_FLOAT = new TypeCode(TCKind.TK_FLOAT);
    public static final TypeCode TC_DOUBLE = new TypeCode(TCKind.TK_DOUBLE);
    public static final TypeCode TC_BOOLEAN = new TypeCode(TCKind.TK_BOOLEAN);
    public static final TypeCode TC_CHAR = new TypeCode(TCKind.TK_CHAR);
    public static final TypeCode TC_OCTET = new TypeCode(TCKind.TK_OCTET);
    public static final TypeCode TC_LONGLONG = new TypeCode(TCKind.TK_LONGLONG);
    public static final TypeCode TC_ULONGLONG = new TypeCode(TCKind.TK_ULONGLONG);
    public static final TypeCode TC_LONGDOUBLE = new TypeCode(TCKind.TK_LONGDOUBLE);
    public static final TypeCode TC_WCHAR = new TypeCode(TCKind.TK_WCHAR);
    public static final int MEMBER_ID_INVALID = Integer.MAX_VALUE;
    public static final int MAX_MEMBER_ID = 0xFFFBFFF;
    public static final int MEMBER_ID_SPARSE_UNSPECIFIED = 0;
    public static final int INDEX_INVALID = -1;
    public static final byte NONKEY_MEMBER = 0;
    public static final byte KEY_MEMBER = 1;
    public static final byte NONKEY_REQUIRED_MEMBER = 2;
    public static final short NOT_BITFIELD = -1;
    private static int UNSPECIFIED_DEFAULT_INDEX = -1;
    private final TCKind _kind;
    private final String _name;
    private final boolean _isPointer;
    private final short _typeModifier;
    private final TypeCode _typeCode;
    private final int _maximumLength;
    private final int _default_index;
    private final int[] _dimensions;
    private ExtensibilityKind _extensibilityKind = ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY;
    private StructMember[] _structMembers = null;
    private UnionMember[] _unionMembers = null;
    private EnumMember[] _enumMembers = null;
    private ValueMember[] _valueMembers = null;
    private SparseMember[] _sparseMembers = null;
    private transient long _nativeTypeCode = 0L;
    private transient long _nativeTypeObject = 0L;
    private transient boolean lockTypeCode = false;

    public TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            this._kind = TCKind.TK_NULL;
            this._name = null;
            this._maximumLength = 0;
            this._typeCode = null;
            this._typeModifier = 0;
            this._isPointer = false;
            this._default_index = UNSPECIFIED_DEFAULT_INDEX;
            this._dimensions = null;
            return;
        }
        this._kind = typeCode.kind();
        this._extensibilityKind = typeCode.extensibility_kind();
        if (this._kind.equals(TCKind.TK_NULL) || this._kind.equals(TCKind.TK_SHORT) || this._kind.equals(TCKind.TK_LONG) || this._kind.equals(TCKind.TK_USHORT) || this._kind.equals(TCKind.TK_ULONG) || this._kind.equals(TCKind.TK_FLOAT) || this._kind.equals(TCKind.TK_DOUBLE) || this._kind.equals(TCKind.TK_BOOLEAN) || this._kind.equals(TCKind.TK_CHAR) || this._kind.equals(TCKind.TK_OCTET) || this._kind.equals(TCKind.TK_LONGLONG) || this._kind.equals(TCKind.TK_ULONGLONG) || this._kind.equals(TCKind.TK_LONGDOUBLE) || this._kind.equals(TCKind.TK_WCHAR)) {
            this._name = null;
            this._maximumLength = 0;
            this._typeCode = null;
            this._typeModifier = 0;
            this._isPointer = false;
            this._default_index = UNSPECIFIED_DEFAULT_INDEX;
            this._dimensions = null;
            return;
        }
        try {
            int n;
            this._isPointer = this._kind.equals(TCKind.TK_ALIAS) ? typeCode.is_alias_pointer() : false;
            this._default_index = this._kind.equals(TCKind.TK_UNION) ? typeCode.default_index() : UNSPECIFIED_DEFAULT_INDEX;
            this._name = this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_ALIAS) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) ? typeCode.name() : null;
            if (this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY) || this._kind.equals(TCKind.TK_ALIAS)) {
                this._typeCode = new TypeCode(typeCode.content_type());
            } else if (this._kind.equals(TCKind.TK_UNION)) {
                this._typeCode = new TypeCode(typeCode.discriminator_type());
            } else if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                TypeCode typeCode2 = typeCode.concrete_base_type();
                this._typeCode = new TypeCode(typeCode2);
            } else {
                this._typeCode = this._kind.equals(TCKind.TK_STRUCT) ? TC_NULL : null;
            }
            this._maximumLength = this._kind.equals(TCKind.TK_STRING) || this._kind.equals(TCKind.TK_WSTRING) || this._kind.equals(TCKind.TK_SEQUENCE) ? typeCode.length() : 0;
            if (this._kind.equals(TCKind.TK_ARRAY)) {
                int n2 = typeCode.array_dimension_count();
                this._dimensions = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this._dimensions[n] = typeCode.array_dimension(n);
                }
            } else {
                this._dimensions = null;
            }
            if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                int n3 = typeCode.member_count();
                if (this._kind.equals(TCKind.TK_STRUCT)) {
                    this._structMembers = new StructMember[n3];
                    for (n = 0; n < n3; ++n) {
                        this._structMembers[n] = new StructMember(typeCode.member_name(n), typeCode.is_member_pointer(n), typeCode.member_bitfield_bits(n), typeCode.is_member_key(n), new TypeCode(typeCode.member_type(n)), typeCode.member_id(n), !typeCode.is_member_required(n));
                    }
                }
                if (this._kind.equals(TCKind.TK_UNION)) {
                    this._unionMembers = new UnionMember[n3];
                    for (n = 0; n < n3; ++n) {
                        this._unionMembers[n] = new UnionMember(typeCode.member_name(n), typeCode.is_member_pointer(n), typeCode._unionMembers[n].labels, new TypeCode(typeCode.member_type(n)), typeCode.member_id(n));
                    }
                }
                if (this._kind.equals(TCKind.TK_ENUM)) {
                    this._enumMembers = new EnumMember[n3];
                    for (n = 0; n < n3; ++n) {
                        this._enumMembers[n] = new EnumMember(typeCode.member_name(n), typeCode.member_ordinal(n));
                    }
                }
                if (this._kind.equals(TCKind.TK_VALUE)) {
                    this._valueMembers = new ValueMember[n3];
                    for (n = 0; n < n3; ++n) {
                        this._valueMembers[n] = new ValueMember(typeCode.member_name(n), typeCode.is_member_pointer(n), typeCode.member_bitfield_bits(n), typeCode.is_member_key(n), typeCode.member_visibility(n), new TypeCode(typeCode.member_type(n)), typeCode.member_id(n), !typeCode.is_member_required(n));
                    }
                }
                if (this._kind.equals(TCKind.TK_SPARSE)) {
                    this._sparseMembers = new SparseMember[n3];
                    for (n = 0; n < n3; ++n) {
                        this._sparseMembers[n] = new SparseMember(typeCode.member_name(n), typeCode._sparseMembers[n].representations, typeCode.get_member_flags(n), typeCode.member_visibility(n));
                    }
                }
            }
            this._typeModifier = this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) ? typeCode.type_modifier() : (short)0;
        }
        catch (UserException userException) {
            IllegalStateException illegalStateException = new IllegalStateException(userException.getMessage());
            throw illegalStateException;
        }
    }

    public TypeCode(TCKind tCKind) throws BAD_PARAM {
        if (tCKind == null) {
            throw new BAD_PARAM("tcKind is null");
        }
        if (!(tCKind.equals(TCKind.TK_SHORT) || tCKind.equals(TCKind.TK_LONG) || tCKind.equals(TCKind.TK_USHORT) || tCKind.equals(TCKind.TK_ULONG) || tCKind.equals(TCKind.TK_FLOAT) || tCKind.equals(TCKind.TK_DOUBLE) || tCKind.equals(TCKind.TK_BOOLEAN) || tCKind.equals(TCKind.TK_CHAR) || tCKind.equals(TCKind.TK_OCTET) || tCKind.equals(TCKind.TK_LONGLONG) || tCKind.equals(TCKind.TK_ULONGLONG) || tCKind.equals(TCKind.TK_LONGDOUBLE) || tCKind.equals(TCKind.TK_WCHAR) || tCKind.equals(TCKind.TK_VALUE) || tCKind.equals(TCKind.TK_NULL))) {
            throw new BAD_PARAM("TCKind is not a basic kind (primitive type or TK_NULL)");
        }
        this._kind = tCKind;
        this._extensibilityKind = ExtensibilityKind.FINAL_EXTENSIBILITY;
        this._name = null;
        this._maximumLength = 0;
        this._typeCode = null;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(String string, ExtensibilityKind extensibilityKind, StructMember[] structMemberArray) throws BAD_PARAM {
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        this._kind = TCKind.TK_STRUCT;
        this._extensibilityKind = extensibilityKind;
        this._name = string;
        if (structMemberArray != null) {
            this._structMembers = new StructMember[structMemberArray.length];
            for (int i = 0; i < structMemberArray.length; ++i) {
                if (structMemberArray[i].is_key && structMemberArray[i].is_optional) {
                    throw new BAD_PARAM("members[" + i + "] is a key member and optional");
                }
                if (structMemberArray[i].name == null) {
                    throw new BAD_PARAM("members[" + i + "].name is null");
                }
                if (structMemberArray[i].type == null) {
                    throw new BAD_PARAM("members[" + i + "].type is null");
                }
                if (structMemberArray[i].type.kind().equals(TCKind.TK_NULL)) {
                    throw new BAD_PARAM("members[" + i + "].type is a TK_NULL type code");
                }
                int n = structMemberArray[i].id == Integer.MAX_VALUE ? (i > 0 ? this._structMembers[i - 1].id + 1 : 0) : structMemberArray[i].id;
                if (this.exist_member_id(n, i)) {
                    throw new BAD_PARAM("members[" + i + "]. Member ID " + n + " already exists");
                }
                if (n > 0xFFFBFFF) {
                    throw new BAD_PARAM("members[" + i + "]. Invalid member ID " + n);
                }
                this._structMembers[i] = new StructMember(structMemberArray[i].name, structMemberArray[i].is_pointer, structMemberArray[i].bits, structMemberArray[i].is_key, structMemberArray[i].type, n, structMemberArray[i].is_optional);
            }
        } else {
            this._structMembers = new StructMember[0];
        }
        this._maximumLength = 0;
        this._typeCode = TC_NULL;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(String string, ExtensibilityKind extensibilityKind, short s, TypeCode typeCode, ValueMember[] valueMemberArray) throws BAD_PARAM {
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        if (s != 3 && s != 0 && s != 2 && s != 1) {
            throw new BAD_PARAM("type_modifier is not valid");
        }
        if (typeCode == null) {
            this._typeCode = TC_NULL;
        } else {
            if (!(typeCode.is_base_kind(TCKind.TK_VALUE) || typeCode.is_base_kind(TCKind.TK_STRUCT) || typeCode.is_base_kind(TCKind.TK_ALIAS) || typeCode.kind().equals(TCKind.TK_NULL))) {
                throw new BAD_PARAM("concrete_base kind is not valid");
            }
            this._typeCode = typeCode;
        }
        this._kind = TCKind.TK_VALUE;
        this._name = string;
        this._typeModifier = s;
        this._extensibilityKind = extensibilityKind;
        if (valueMemberArray != null) {
            this._valueMembers = new ValueMember[valueMemberArray.length];
            for (int i = 0; i < valueMemberArray.length; ++i) {
                int n;
                if (valueMemberArray[i].is_key && valueMemberArray[i].is_optional) {
                    throw new BAD_PARAM("members[" + i + "] is a key member and optional");
                }
                if (valueMemberArray[i].name == null) {
                    throw new BAD_PARAM("members[" + i + "].name is null");
                }
                if (valueMemberArray[i].access != 1 && valueMemberArray[i].access != 0) {
                    throw new BAD_PARAM("members[" + i + "].access is not valid");
                }
                if (valueMemberArray[i].type == null) {
                    throw new BAD_PARAM("members[" + i + "].type is null");
                }
                if (valueMemberArray[i].type.kind().equals(TCKind.TK_NULL)) {
                    throw new BAD_PARAM("members[" + i + "].type is a TK_NULL type code");
                }
                if (valueMemberArray[i].id == Integer.MAX_VALUE) {
                    if (i > 0) {
                        n = this._valueMembers[i - 1].id + 1;
                    } else {
                        try {
                            if (typeCode != null && !typeCode.kind().equals(TCKind.TK_NULL)) {
                                while (typeCode.kind().equals(TCKind.TK_ALIAS)) {
                                    typeCode = typeCode.content_type();
                                }
                                n = typeCode.member_id(typeCode.member_count() - 1);
                                ++n;
                            }
                            n = 0;
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("Unexpected error");
                        }
                    }
                } else {
                    n = valueMemberArray[i].id;
                }
                if (this.exist_member_id(n, i)) {
                    throw new BAD_PARAM("members[" + i + "]. Member ID " + n + " already exists");
                }
                if (n > 0xFFFBFFF) {
                    throw new BAD_PARAM("members[" + i + "]. Invalid member ID " + n);
                }
                this._valueMembers[i] = new ValueMember(valueMemberArray[i].name, valueMemberArray[i].is_pointer, valueMemberArray[i].bits, valueMemberArray[i].is_key, valueMemberArray[i].access, valueMemberArray[i].type, n, valueMemberArray[i].is_optional);
            }
        } else {
            this._valueMembers = new ValueMember[0];
        }
        this._maximumLength = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(String string, short s, TypeCode typeCode) throws BAD_PARAM {
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        if (s != 3 && s != 0 && s != 2 && s != 1) {
            throw new BAD_PARAM("type_modifier is not valid");
        }
        if (typeCode == null) {
            this._typeCode = TC_NULL;
        } else {
            if (!typeCode.is_base_kind(TCKind.TK_SPARSE) && !typeCode.kind().equals(TCKind.TK_NULL)) {
                throw new BAD_PARAM("concrete_base kind is not valid");
            }
            this._typeCode = typeCode;
        }
        this._typeModifier = s;
        this._kind = TCKind.TK_SPARSE;
        this._name = string;
        this._extensibilityKind = ExtensibilityKind.MUTABLE_EXTENSIBILITY;
        this._maximumLength = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(TCKind tCKind, int n) throws BAD_PARAM {
        if (tCKind == null) {
            throw new BAD_PARAM("tcKind is null");
        }
        if (!tCKind.equals(TCKind.TK_STRING) && !tCKind.equals(TCKind.TK_WSTRING)) {
            throw new BAD_PARAM("tcKind is not TK_STRING or TK_WSTRING");
        }
        if (n < 0) {
            throw new BAD_PARAM("bound must be equal or greater than 0");
        }
        this._kind = tCKind;
        this._maximumLength = n;
        this._extensibilityKind = ExtensibilityKind.MUTABLE_EXTENSIBILITY;
        this._name = null;
        this._typeCode = null;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(int n, TypeCode typeCode) throws BAD_PARAM {
        if (typeCode == null) {
            throw new BAD_PARAM("element_type is null");
        }
        if (typeCode.kind().equals(TCKind.TK_NULL)) {
            throw new BAD_PARAM("element_type is a TK_NULL type code");
        }
        if (n < 0) {
            throw new BAD_PARAM("bound is negative");
        }
        this._kind = TCKind.TK_SEQUENCE;
        this._maximumLength = n;
        this._typeCode = typeCode;
        this._extensibilityKind = ExtensibilityKind.MUTABLE_EXTENSIBILITY;
        this._name = null;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(int[] nArray, TypeCode typeCode) throws BAD_PARAM {
        if (typeCode == null) {
            throw new BAD_PARAM("element_type is null");
        }
        if (typeCode.kind().equals(TCKind.TK_NULL)) {
            throw new BAD_PARAM("element_type is a TK_NULL type code");
        }
        if (nArray == null) {
            throw new BAD_PARAM("dimensions is null");
        }
        if (nArray.length == 0) {
            throw new BAD_PARAM("dimnesions length is 0");
        }
        this._extensibilityKind = ExtensibilityKind.FINAL_EXTENSIBILITY;
        this._dimensions = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw new BAD_PARAM("dimensions[" + i + "] is <= 0");
            }
            this._dimensions[i] = nArray[i];
        }
        this._kind = TCKind.TK_ARRAY;
        this._maximumLength = nArray[0];
        this._typeCode = typeCode;
        this._name = null;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
    }

    public TypeCode(String string, TypeCode typeCode, boolean bl) throws BAD_PARAM {
        if (typeCode == null) {
            throw new BAD_PARAM("original_type is null");
        }
        if (typeCode.kind().equals(TCKind.TK_NULL)) {
            throw new BAD_PARAM("original_type is a TK_NULL type code");
        }
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        this._kind = TCKind.TK_ALIAS;
        this._name = string;
        this._typeCode = typeCode;
        this._isPointer = bl;
        this._extensibilityKind = typeCode.extensibility_kind();
        this._maximumLength = 0;
        this._typeModifier = 0;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(String string, ExtensibilityKind extensibilityKind, EnumMember[] enumMemberArray) throws BAD_PARAM {
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        this._kind = TCKind.TK_ENUM;
        this._name = string;
        this._extensibilityKind = extensibilityKind;
        if (enumMemberArray != null) {
            this._enumMembers = new EnumMember[enumMemberArray.length];
            for (int i = 0; i < enumMemberArray.length; ++i) {
                if (enumMemberArray[i].name == null) {
                    throw new BAD_PARAM("members[" + i + "].name is null");
                }
                this._enumMembers[i] = new EnumMember(enumMemberArray[i].name, enumMemberArray[i].ordinal);
            }
        } else {
            this._enumMembers = new EnumMember[0];
        }
        this._maximumLength = 0;
        this._typeCode = null;
        this._typeModifier = 0;
        this._isPointer = false;
        this._default_index = UNSPECIFIED_DEFAULT_INDEX;
        this._dimensions = null;
    }

    public TypeCode(String string, ExtensibilityKind extensibilityKind, TypeCode typeCode, int n, UnionMember[] unionMemberArray) throws BAD_PARAM {
        if (string == null) {
            throw new BAD_PARAM("name is null");
        }
        if (typeCode == null || !typeCode.is_discriminator()) {
            throw new BAD_PARAM("Illegal union discriminator type");
        }
        this._kind = TCKind.TK_UNION;
        this._name = string;
        this._typeCode = typeCode;
        this._default_index = n;
        this._extensibilityKind = extensibilityKind;
        if (unionMemberArray != null) {
            this._unionMembers = new UnionMember[unionMemberArray.length];
            for (int i = 0; i < unionMemberArray.length; ++i) {
                if (unionMemberArray[i].name == null) {
                    throw new BAD_PARAM("members[" + i + "].name is null");
                }
                if (unionMemberArray[i].labels == null) {
                    throw new BAD_PARAM("members[" + i + "].labels is null");
                }
                if (unionMemberArray[i].labels.length == 0) {
                    throw new BAD_PARAM("members[" + i + "].labels.length is 0");
                }
                int[] nArray = new int[unionMemberArray[i].labels.length];
                System.arraycopy(unionMemberArray[i].labels, 0, nArray, 0, unionMemberArray[i].labels.length);
                if (unionMemberArray[i].type == null) {
                    throw new BAD_PARAM("members[" + i + "].type is null");
                }
                if (unionMemberArray[i].type.kind().equals(TCKind.TK_NULL)) {
                    throw new BAD_PARAM("members[" + i + "] is a TK_NULL type code");
                }
                int n2 = unionMemberArray[i].id == Integer.MAX_VALUE ? (i > 0 ? this._unionMembers[i - 1].id + 1 : 1) : unionMemberArray[i].id;
                if (this.exist_member_id(n2, i)) {
                    throw new BAD_PARAM("members[" + i + "]. Member ID " + n2 + " already exists");
                }
                if (n2 > 0xFFFBFFF) {
                    throw new BAD_PARAM("members[" + i + "]. Invalid member ID " + n2);
                }
                this._unionMembers[i] = new UnionMember(unionMemberArray[i].name, unionMemberArray[i].is_pointer, nArray, unionMemberArray[i].type, n2);
            }
        }
        this._maximumLength = 0;
        this._typeModifier = 0;
        this._isPointer = false;
        this._dimensions = null;
    }

    public TCKind kind() {
        return this._kind;
    }

    public ExtensibilityKind extensibility_kind() {
        return this._extensibilityKind;
    }

    public boolean equal(TypeCode typeCode) {
        try {
            int n;
            if (typeCode == null) {
                throw new BAD_PARAM("tc is null");
            }
            if (!(this._kind.equals(TCKind.TK_STRUCT) && typeCode.kind().equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_VALUE) && typeCode.kind().equals(TCKind.TK_STRUCT) || this._kind.equals(typeCode.kind()))) {
                return false;
            }
            if (!this._extensibilityKind.equals(typeCode.extensibility_kind())) {
                return false;
            }
            if ((this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_ALIAS) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) && !Utilities.equalsNullSafe(this._name, typeCode.name())) {
                return false;
            }
            if (this._kind.equals(TCKind.TK_ALIAS) && this._isPointer != typeCode.is_alias_pointer()) {
                return false;
            }
            if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_SPARSE)) {
                if (this._typeModifier != typeCode.type_modifier()) {
                    return false;
                }
                if (this._typeCode.equals(TC_NULL) ? typeCode.concrete_base_type() != null : typeCode.concrete_base_type() == null) {
                    return false;
                }
            }
            if ((this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY) || this._kind.equals(TCKind.TK_ALIAS)) && !this._typeCode.equal(typeCode.content_type())) {
                return false;
            }
            if (this._kind.equals(TCKind.TK_UNION) && !this._typeCode.equal(typeCode.discriminator_type())) {
                return false;
            }
            if ((this._kind.equals(TCKind.TK_STRING) || this._kind.equals(TCKind.TK_WSTRING) || this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY)) && this._maximumLength != typeCode.length()) {
                return false;
            }
            if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                int n2 = this.member_count();
                if (n2 != typeCode.member_count()) {
                    return false;
                }
                for (n = 0; n < n2; ++n) {
                    int n3;
                    if (!Utilities.equalsNullSafe(this.member_name(n), typeCode.member_name(n))) {
                        return false;
                    }
                    if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                        if (!Utilities.equalsNullSafe(this.member_type(n), typeCode.member_type(n))) {
                            return false;
                        }
                        if (this.is_member_pointer(n) != typeCode.is_member_pointer(n)) {
                            return false;
                        }
                        if (this.is_member_required(n) != typeCode.is_member_required(n)) {
                            return false;
                        }
                    }
                    if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                        if (this.is_member_bitfield(n) != typeCode.is_member_bitfield(n)) {
                            return false;
                        }
                        if (this.member_bitfield_bits(n) != typeCode.member_bitfield_bits(n)) {
                            return false;
                        }
                        if (this.is_member_key(n) != typeCode.is_member_key(n)) {
                            return false;
                        }
                        if ((this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_SPARSE)) && this.member_visibility(n) != typeCode.member_visibility(n)) {
                            return false;
                        }
                        if (this._kind.equals(TCKind.TK_SPARSE)) {
                            for (n3 = 0; n3 < this._sparseMembers[n].representations.length; ++n3) {
                                if (this.member_representation(n, n3).equal(typeCode.member_representation(n, n3))) continue;
                                return false;
                            }
                        }
                    }
                    if (this._kind.equals(TCKind.TK_ENUM) && this.member_ordinal(n) != typeCode.member_ordinal(n)) {
                        return false;
                    }
                    if (this._kind.equals(TCKind.TK_UNION)) {
                        int n4 = this.member_label_count(n);
                        if (n4 != typeCode.member_label_count(n)) {
                            return false;
                        }
                        for (n3 = 0; n3 < n4; ++n3) {
                            if (this.member_label(n, n3) == typeCode.member_label(n, n3)) continue;
                            return false;
                        }
                    }
                    if (!this._kind.equals(TCKind.TK_UNION) && !this._kind.equals(TCKind.TK_VALUE) && !this._kind.equals(TCKind.TK_STRUCT) || this.member_id(n) == typeCode.member_id(n)) continue;
                    return false;
                }
            }
            if (this._kind.equals(TCKind.TK_UNION) && this._default_index != typeCode.default_index()) {
                return false;
            }
            if (this._kind.equals(TCKind.TK_ARRAY)) {
                if (this._dimensions.length != typeCode.array_dimension_count()) {
                    return false;
                }
                for (n = 0; n < this._dimensions.length; ++n) {
                    if (this._dimensions[n] == typeCode.array_dimension(n)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (UserException userException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof TypeCode) {
            return this.equal((TypeCode)object);
        }
        return false;
    }

    public boolean assignable(TypeCode typeCode) {
        return TypeCode.is_native_assignable(this.get_native_typeobject(), typeCode.get_native_typeobject());
    }

    public boolean equivalent(TypeCode typeCode) {
        return TypeCode.is_native_equivalent(this.get_native_typeobject(), typeCode.get_native_typeobject());
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_ALIAS) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
            n2 += Utilities.hashCodeNullSafe(this._name);
        }
        if (this._kind.equals(TCKind.TK_ALIAS)) {
            n2 += this._isPointer ? 1 : 0;
        }
        if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
            n2 += this._typeModifier;
        }
        if (this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY) || this._kind.equals(TCKind.TK_ALIAS)) {
            n2 += Utilities.hashCodeNullSafe(this._typeCode);
        }
        if (this._kind.equals(TCKind.TK_STRING) || this._kind.equals(TCKind.TK_WSTRING) || this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY)) {
            n2 += this._maximumLength;
        }
        try {
            if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                n = this.member_count();
                n2 += n;
                for (int i = 0; i < n; ++i) {
                    int n3;
                    n2 += Utilities.hashCodeNullSafe(this.member_name(i));
                    if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                        n2 += Utilities.hashCodeNullSafe(this.member_type(i));
                        n2 += this.is_member_pointer(i) ? 1 : 0;
                    }
                    if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                        n2 += this.is_member_bitfield(i) ? 1 : 0;
                        n2 += this.member_bitfield_bits(i);
                        n2 += this.is_member_key(i) ? 1 : 0;
                        if (this._kind.equals(TCKind.TK_SPARSE)) {
                            n2 += this.is_member_required(i) ? 1 : 0;
                        }
                        if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                            n2 += this.member_visibility(i);
                        }
                        if (this._kind.equals(TCKind.TK_SPARSE)) {
                            for (n3 = 0; n3 < this._sparseMembers[i].representations.length; ++n3) {
                                n2 += this.member_representation(i, n3).hashCode();
                            }
                        }
                    }
                    if (this._kind.equals(TCKind.TK_ENUM)) {
                        n2 += this.member_ordinal(i);
                    }
                    if (!this._kind.equals(TCKind.TK_UNION)) continue;
                    n3 = this.member_label_count(i);
                    n2 += n3;
                    for (int j = 0; j < n3; ++j) {
                        n2 += this.member_label(i, j);
                    }
                }
            }
        }
        catch (UserException userException) {
            IllegalStateException illegalStateException = new IllegalStateException(userException.getMessage());
            throw illegalStateException;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            n2 += this._default_index;
        }
        if (this._kind.equals(TCKind.TK_ARRAY)) {
            n2 += this._dimensions.length;
            for (n = 0; n < this._dimensions.length; ++n) {
                n2 += this._dimensions[n];
            }
        }
        return n2;
    }

    public int length() throws BadKind {
        if (!(this._kind.equals(TCKind.TK_STRING) || this._kind.equals(TCKind.TK_WSTRING) || this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY))) {
            throw new BadKind();
        }
        return this._maximumLength;
    }

    public String name() throws BadKind {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_ALIAS) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        return this._name;
    }

    private boolean has_name() {
        return this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_ALIAS) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE);
    }

    public boolean is_alias_pointer() throws BadKind {
        if (!this._kind.equals(TCKind.TK_ALIAS)) {
            throw new BadKind();
        }
        return this._isPointer;
    }

    public short type_modifier() throws BadKind {
        if (!(this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        return this._typeModifier;
    }

    public TypeCode concrete_base_type() throws BadKind {
        if (!(this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (this._typeCode == null) {
            return TC_NULL;
        }
        if (this._typeCode.kind().equals(TCKind.TK_NULL)) {
            return null;
        }
        return this._typeCode;
    }

    public TypeCode content_type() throws BadKind {
        if (!(this._kind.equals(TCKind.TK_SEQUENCE) || this._kind.equals(TCKind.TK_ARRAY) || this._kind.equals(TCKind.TK_ALIAS))) {
            throw new BadKind();
        }
        return this._typeCode;
    }

    public int array_dimension_count() throws BadKind {
        if (!this._kind.equals(TCKind.TK_ARRAY)) {
            throw new BadKind();
        }
        return this._dimensions.length;
    }

    public int array_dimension(int n) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_ARRAY)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this._dimensions.length) {
            throw new Bounds();
        }
        return this._dimensions[n];
    }

    public int element_count() throws BadKind {
        if (!this._kind.equals(TCKind.TK_ARRAY)) {
            throw new BadKind();
        }
        int n = 1;
        for (int i = 0; i < this._dimensions.length; ++i) {
            try {
                n *= this.array_dimension(i);
                continue;
            }
            catch (Bounds bounds) {
                IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                throw illegalStateException;
            }
        }
        return n;
    }

    public int member_count() throws BadKind {
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers.length;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers.length;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers.length;
        }
        if (this._kind.equals(TCKind.TK_ENUM)) {
            return this._enumMembers.length;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers.length;
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers[n].name;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers[n].name;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers[n].name;
        }
        if (this._kind.equals(TCKind.TK_ENUM)) {
            return this._enumMembers[n].name;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].name;
        }
        throw new BadKind();
    }

    public TypeCode member_type(int n) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers[n].type;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers[n].type;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers[n].type;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].get_type();
        }
        throw new BadKind();
    }

    private int member_representation_count(int n) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].member_representation_count();
        }
        throw new BadKind();
    }

    public int member_id(int n) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].member_representation_id(0);
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers[n].id;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers[n].id;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers[n].id;
        }
        throw new BadKind();
    }

    private int member_representation_id(int n, int n2) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].member_representation_id(n2);
        }
        if (n2 == 0) {
            if (this._kind.equals(TCKind.TK_STRUCT)) {
                return this._structMembers[n].id;
            }
            if (this._kind.equals(TCKind.TK_VALUE)) {
                return this._valueMembers[n].id;
            }
            if (this._kind.equals(TCKind.TK_UNION)) {
                return this._unionMembers[n].id;
            }
            throw new Bounds();
        }
        throw new BadKind();
    }

    public int member_label_count(int n) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers[n].labels.length;
        }
        throw new BadKind();
    }

    public int member_label(int n, int n2) throws BadKind, Bounds {
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (!this._kind.equals(TCKind.TK_UNION)) {
            throw new BadKind();
        }
        int[] nArray = this._unionMembers[n].labels;
        if (n2 < 0 || n2 >= nArray.length) {
            throw new Bounds();
        }
        return nArray[n2];
    }

    public int member_ordinal(int n) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_ENUM)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        return this._enumMembers[n].ordinal;
    }

    public boolean is_member_key(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers[n].is_key;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].member_flags == 1;
        }
        return this._structMembers[n].is_key;
    }

    public boolean is_member_required(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) || this._kind.equals(TCKind.TK_UNION))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return false;
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return !this._structMembers[n].is_optional;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return !this._valueMembers[n].is_optional;
        }
        return this._sparseMembers[n].member_flags == 1 || this._sparseMembers[n].member_flags == 2;
    }

    public byte get_member_flags(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) || this._kind.equals(TCKind.TK_UNION))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            if (this._valueMembers[n].is_key) {
                return 1;
            }
            if (this._valueMembers[n].is_optional) {
                return 0;
            }
            return 2;
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return 0;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].member_flags;
        }
        if (this._structMembers[n].is_key) {
            return 1;
        }
        if (this._structMembers[n].is_optional) {
            return 0;
        }
        return 2;
    }

    public boolean is_member_pointer(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_UNION)) {
            return this._unionMembers[n].is_pointer;
        }
        if (this._kind.equals(TCKind.TK_VALUE)) {
            return this._valueMembers[n].is_pointer;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].is_pointer();
        }
        return this._structMembers[n].is_pointer;
    }

    private boolean is_member_representation_pointer(int n, int n2) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        return this._sparseMembers[n].is_member_representation_pointer(n2);
    }

    public boolean is_member_bitfield(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers[n].bits != -1;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].is_member_bitfield();
        }
        return this._valueMembers[n].bits != -1;
    }

    private boolean is_member_representation_bitfield(int n, int n2) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        return this._sparseMembers[n].is_member_representation_bitfield(n2);
    }

    public short member_bitfield_bits(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return this._structMembers[n].bits;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].bits();
        }
        return this._valueMembers[n].bits;
    }

    private short member_representation_bitfield_bits(int n, int n2) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        return this._sparseMembers[n].member_representation_bitfield_bits(n2);
    }

    public short member_visibility(int n) throws BadKind, Bounds {
        if (!(this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            return 1;
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            return this._sparseMembers[n].access;
        }
        return this._valueMembers[n].access;
    }

    private TypeCodeRepresentation member_representation(int n, int n2) throws BadKind, Bounds {
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count()) {
            throw new Bounds();
        }
        if (n2 < 0 || n2 >= this._sparseMembers[n].representations.length) {
            throw new Bounds();
        }
        return this._sparseMembers[n].representations[n2];
    }

    public TypeCode discriminator_type() throws BadKind {
        if (!this._kind.equals(TCKind.TK_UNION)) {
            throw new BadKind();
        }
        return this._typeCode;
    }

    public int default_index() throws BadKind {
        if (!this._kind.equals(TCKind.TK_UNION)) {
            throw new BadKind();
        }
        return this._default_index;
    }

    public int find_member_by_id(int n) throws BadKind {
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        int n2 = this.member_count();
        for (int i = 0; i < n2; ++i) {
            try {
                int n3 = this.member_representation_count(i);
                for (int j = 0; j < n3; ++j) {
                    if (this.member_representation_id(i, j) != n) continue;
                    return i;
                }
                continue;
            }
            catch (Bounds bounds) {
                IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                throw illegalStateException;
            }
        }
        return -1;
    }

    public int find_member_by_name(String string) throws BadKind {
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_SPARSE))) {
            throw new BadKind();
        }
        int n = this.member_count();
        for (int i = 0; i < n; ++i) {
            try {
                if (!Utilities.equalsNullSafe(this.member_name(i), string)) continue;
                return i;
            }
            catch (Bounds bounds) {
                IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                throw illegalStateException;
            }
        }
        return -1;
    }

    public int find_member_by_label(int n) throws BadKind {
        if (!this._kind.equals(TCKind.TK_UNION) && !this._kind.equals(TCKind.TK_ENUM)) {
            throw new BadKind();
        }
        int n2 = this.member_count();
        for (int i = 0; i < n2; ++i) {
            if (this._kind.equals(TCKind.TK_UNION)) {
                try {
                    int n3 = this.member_label_count(i);
                    for (int j = 0; j < n3; ++j) {
                        if (this.member_label(i, j) != n) continue;
                        return i;
                    }
                    continue;
                }
                catch (Bounds bounds) {
                    IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                    throw illegalStateException;
                }
            }
            try {
                if (this.member_ordinal(i) != n) continue;
                return i;
            }
            catch (Bounds bounds) {
                IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                throw illegalStateException;
            }
        }
        return -1;
    }

    public boolean is_primitive() {
        return this.kind().equals(TCKind.TK_SHORT) || this.kind().equals(TCKind.TK_LONG) || this.kind().equals(TCKind.TK_USHORT) || this.kind().equals(TCKind.TK_ULONG) || this.kind().equals(TCKind.TK_FLOAT) || this.kind().equals(TCKind.TK_DOUBLE) || this.kind().equals(TCKind.TK_BOOLEAN) || this.kind().equals(TCKind.TK_CHAR) || this.kind().equals(TCKind.TK_OCTET) || this.kind().equals(TCKind.TK_LONGLONG) || this.kind().equals(TCKind.TK_ULONGLONG) || this.kind().equals(TCKind.TK_LONGDOUBLE) || this.kind().equals(TCKind.TK_WCHAR) || this.kind().equals(TCKind.TK_NULL);
    }

    public long push_to_nativeI() {
        long l = TypeCode.create_native_tc_list();
        long l2 = TypeCode.create_native_deserialized_typecode(l, this);
        TypeCode.delete_native_tc_list(l);
        return l2;
    }

    private static long create_native_deserialized_typecode(long l, TypeCode typeCode) {
        try {
            if (typeCode.is_primitive()) {
                return TypeCode.get_native_primitive_tc(typeCode.kind().ordinal());
            }
            long l2 = 0L;
            if (typeCode.has_name()) {
                l2 = TypeCode.lookup_native_tc(l, typeCode.name());
                if (l2 != 0L) {
                    return l2;
                }
            }
            if (typeCode.kind().equals(TCKind.TK_ENUM)) {
                l2 = TypeCode.create_native_enum_tc(typeCode.name(), typeCode.extensibility_kind().ordinal());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    TypeCode.add_native_member_to_enum(l2, typeCode.member_name(i), typeCode.member_ordinal(i));
                }
            } else if (typeCode.kind().equals(TCKind.TK_UNION)) {
                l2 = TypeCode.create_native_union_tc(typeCode.name(), typeCode.extensibility_kind().ordinal(), TypeCode.create_native_deserialized_typecode(l, typeCode.discriminator_type()), typeCode.default_index());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    TypeCode.add_native_member_to_union(l2, typeCode.member_name(i), typeCode.member_id(i), typeCode._unionMembers[i].labels, typeCode.member_label_count(i), TypeCode.create_native_deserialized_typecode(l, typeCode.member_type(i)), typeCode.is_member_pointer(i));
                }
            } else if (typeCode.kind().equals(TCKind.TK_STRUCT)) {
                l2 = TypeCode.create_native_struct_tc(typeCode.name(), typeCode.extensibility_kind().ordinal());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    TypeCode.add_native_member_ex(l2, typeCode.member_name(i), typeCode.member_id(i), TypeCode.create_native_deserialized_typecode(l, typeCode.member_type(i)), typeCode.get_member_flags(i), (short)1, typeCode.is_member_pointer(i), typeCode.member_bitfield_bits(i));
                }
            } else if (typeCode.kind().equals(TCKind.TK_VALUE)) {
                long l3 = 0L;
                if (typeCode.concrete_base_type() != null) {
                    l3 = TypeCode.create_native_deserialized_typecode(l, typeCode.concrete_base_type());
                }
                l2 = TypeCode.create_native_value_tc(typeCode.name(), typeCode.extensibility_kind().ordinal(), typeCode.type_modifier(), l3);
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    TypeCode.add_native_member_ex(l2, typeCode.member_name(i), typeCode.member_id(i), TypeCode.create_native_deserialized_typecode(l, typeCode.member_type(i)), typeCode.get_member_flags(i), typeCode.member_visibility(i), typeCode.is_member_pointer(i), typeCode.member_bitfield_bits(i));
                }
            } else if (typeCode.kind().equals(TCKind.TK_SPARSE)) {
                long l4 = 0L;
                if (typeCode.concrete_base_type() != null) {
                    l4 = TypeCode.create_native_deserialized_typecode(l, typeCode.concrete_base_type());
                }
                l2 = TypeCode.create_native_sparse_tc(typeCode.name(), typeCode.type_modifier(), l4);
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    TypeCode.add_native_member_ex(l2, typeCode.member_name(i), typeCode.member_id(i), TypeCode.create_native_deserialized_typecode(l, typeCode.member_type(i)), typeCode.get_member_flags(i), typeCode.member_visibility(i), typeCode.is_member_pointer(i), typeCode.member_bitfield_bits(i));
                }
            } else if (typeCode.kind().equals(TCKind.TK_SEQUENCE)) {
                l2 = TypeCode.create_native_sequence_tc(typeCode.length(), TypeCode.create_native_deserialized_typecode(l, typeCode.content_type()));
            } else if (typeCode.kind().equals(TCKind.TK_ARRAY)) {
                l2 = TypeCode.create_native_array_tc(typeCode.array_dimension_count(), typeCode._dimensions, TypeCode.create_native_deserialized_typecode(l, typeCode.content_type()));
            } else if (typeCode.kind().equals(TCKind.TK_ALIAS)) {
                l2 = TypeCode.create_native_alias_tc(typeCode.name(), TypeCode.create_native_deserialized_typecode(l, typeCode.content_type()), typeCode.is_alias_pointer());
            } else if (typeCode.kind().equals(TCKind.TK_WSTRING)) {
                l2 = TypeCode.create_native_wstring_tc(typeCode.length());
            } else if (typeCode.kind().equals(TCKind.TK_STRING)) {
                l2 = TypeCode.create_native_string_tc(typeCode.length());
            }
            if (typeCode.has_name()) {
                TypeCode.add_tc_native_library(l, l2, typeCode.name());
            }
            return l2;
        }
        catch (UserException userException) {
            IllegalStateException illegalStateException = new IllegalStateException(userException.getMessage());
            throw illegalStateException;
        }
    }

    public void print_IDL(int n) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            this.print_IDL(n, bufferedWriter);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Error printing TypeCode as IDL");
        }
    }

    public void print_IDL(int n, Writer writer) throws IOException {
        try {
            if (this.kind().equals(TCKind.TK_SPARSE)) {
                this.print_indent(n, writer);
                if (this.type_modifier() == 1) {
                    writer.write("custom ");
                } else if (this.type_modifier() == 2) {
                    writer.write("abstract ");
                }
                writer.write("sparse struct " + this.name());
                if (this.concrete_base_type() != null) {
                    if (this.type_modifier() == 3) {
                        writer.write(": truncatable " + this.concrete_base_type().name());
                    } else {
                        writer.write(": " + this.concrete_base_type().name());
                    }
                }
                writer.write(" {\n");
                int n2 = this.member_count();
                for (int i = 0; i < n2; ++i) {
                    this.print_indent(n + 1, writer);
                    if (this.member_visibility(i) == 0) {
                        writer.write("private ");
                    } else {
                        writer.write("public ");
                    }
                    writer.write(this.member_name(i) + ":");
                    if (this.is_member_key(i)) {
                        writer.write(" //@key\n");
                    } else if (this.is_member_required(i)) {
                        writer.write(" //@required\n");
                    } else {
                        writer.write("\n");
                    }
                    int n3 = this._sparseMembers[i].member_representation_count();
                    for (int j = 0; j < n3; ++j) {
                        this.print_indent(n + 2, writer);
                        writer.write(this._sparseMembers[i].member_representation_id(j) + " = " + this._sparseMembers[i].member_representation_type(j).get_type_as_string());
                        if (j == this._sparseMembers[i].member_representation_count() - 1) {
                            if (this.is_member_representation_pointer(i, j)) {
                                writer.write(" *;\n");
                                continue;
                            }
                            if (!this.is_member_representation_bitfield(i, j)) {
                                writer.write(";\n");
                                continue;
                            }
                            writer.write(" : " + this.member_representation_bitfield_bits(i, j) + ";\n");
                            continue;
                        }
                        if (this.is_member_representation_pointer(i, j)) {
                            writer.write(" *,");
                            continue;
                        }
                        if (!this.is_member_representation_bitfield(i, j)) {
                            writer.write(",");
                            continue;
                        }
                        writer.write(" : " + this.member_representation_bitfield_bits(i, j) + ",");
                    }
                }
                this.print_indent(n, writer);
                writer.write("};\n");
            } else if (this.kind().equals(TCKind.TK_STRUCT) || this.kind().equals(TCKind.TK_VALUE)) {
                this.print_indent(n, writer);
                if (this.kind().equals(TCKind.TK_STRUCT)) {
                    writer.write("struct " + this.name() + "{\n");
                } else {
                    if (this.type_modifier() == 1) {
                        writer.write("custom ");
                    } else if (this.type_modifier() == 2) {
                        writer.write("abstract ");
                    }
                    writer.write("struct " + this.name());
                    if (this.concrete_base_type() != null) {
                        if (this.type_modifier() == 3) {
                            writer.write(": truncatable " + this.concrete_base_type().name());
                        } else {
                            writer.write(": " + this.concrete_base_type().name());
                        }
                    }
                    writer.write(" {\n");
                }
                int n4 = this.member_count();
                for (int i = 0; i < n4; ++i) {
                    this.print_indent(n + 1, writer);
                    if (this.kind().equals(TCKind.TK_VALUE)) {
                        if (this.member_visibility(i) == 0) {
                            writer.write("private ");
                        } else {
                            writer.write("public ");
                        }
                    }
                    writer.write(this.member_type(i).get_type_as_string());
                    if (this.is_member_pointer(i)) {
                        writer.write(" * " + this.member_name(i) + ";");
                    } else if (!this.is_member_bitfield(i)) {
                        writer.write(" " + this.member_name(i) + ";");
                    } else {
                        writer.write(" " + this.member_name(i) + " : " + this.member_bitfield_bits(i) + ";");
                    }
                    if (this.is_member_key(i)) {
                        writer.write(" //@key\n");
                    }
                    if (!this.is_member_required(i)) {
                        writer.write(" //@Optional\n");
                    }
                    this.print_indent(n + 1, writer);
                    writer.write("//@ID " + this.member_id(i) + "\n");
                }
                this.print_indent(n, writer);
                writer.write("};\n");
                this.print_indent(n, writer);
                writer.write("//@Extensibility " + this._extensibilityKind.toString() + "\n");
            } else if (this.kind().equals(TCKind.TK_ALIAS)) {
                this.print_indent(n, writer);
                writer.write("typedef ");
                writer.write(this.content_type().get_type_as_string());
                if (this.is_alias_pointer()) {
                    writer.write(" * " + this.name() + ";\n");
                } else {
                    writer.write(" " + this.name() + ";\n");
                }
            } else if (this.kind().equals(TCKind.TK_ENUM)) {
                this.print_indent(n, writer);
                writer.write("enum " + this.name() + " {\n");
                int n5 = this.member_count();
                for (int i = 0; i < n5; ++i) {
                    this.print_indent(n + 1, writer);
                    if (i < this.member_count() - 1) {
                        writer.write(this.member_name(i) + " = " + this.member_ordinal(i) + ",\n");
                        continue;
                    }
                    writer.write(this.member_name(i) + " = " + this.member_ordinal(i) + "\n");
                }
                this.print_indent(n, writer);
                writer.write("};\n");
                writer.write("//@Extensibility " + this._extensibilityKind.toString() + "\n");
            } else if (this.kind().equals(TCKind.TK_UNION)) {
                this.print_indent(n, writer);
                writer.write("union " + this.name() + " switch(");
                writer.write(this.discriminator_type().get_type_as_string());
                writer.write(") {\n");
                int n6 = this.member_count();
                for (int i = 0; i < n6; ++i) {
                    int n7 = this.member_label_count(i);
                    for (int j = 0; j < n7; ++j) {
                        this.print_indent(n + 1, writer);
                        if (this.default_index() == i) {
                            writer.write("default:\n");
                            continue;
                        }
                        writer.write("case " + this.member_label(i, j) + ":\n");
                    }
                    this.print_indent(n + 2, writer);
                    writer.write(this.member_type(i).get_type_as_string());
                    if (this.is_member_pointer(i)) {
                        writer.write(" * " + this.member_name(i) + "; ");
                    } else {
                        writer.write(" " + this.member_name(i) + "; ");
                    }
                    writer.write("//@ID " + this.member_id(i) + "\n");
                }
                this.print_indent(n, writer);
                writer.write("};\n");
                this.print_indent(n, writer);
                writer.write("//@Extensibility " + this._extensibilityKind.toString() + "\n");
            } else {
                writer.write(this.get_type_as_string() + "\n");
            }
        }
        catch (UserException userException) {
            IllegalStateException illegalStateException = new IllegalStateException(userException.getMessage());
            throw illegalStateException;
        }
    }

    public int add_member(String string, int n, TypeCode typeCode, byte by) throws BadKind, BadMemberName, BadMemberId {
        return this.add_member(string, n, typeCode, by, (short)1, false, (short)-1);
    }

    public synchronized int add_member(String string, int n, TypeCode typeCode, byte by, short s, boolean bl, short s2) throws BadKind, BadMemberName, BadMemberId, BAD_PARAM, IllegalStateException {
        if (this.lockTypeCode) {
            throw new RETCODE_ILLEGAL_OPERATION("add_member cannot be called after the native typecode is created");
        }
        int n2 = -1;
        if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) || this._kind.equals(TCKind.TK_UNION))) {
            throw new BadKind();
        }
        if (this._kind.equals(TCKind.TK_SPARSE)) {
            Object[] objectArray;
            if (n == 0) {
                throw new BadMemberId();
            }
            if (s2 != -1) {
                ModuleLogger.DDS.log(1, this.getClass(), "add_member", "bitfields not allowed");
                throw new BAD_PARAM("bitfields not allowed");
            }
            if (n == Integer.MAX_VALUE) {
                throw new BadMemberId();
            }
            if (this._sparseMembers == null || this._sparseMembers.length == 0) {
                this._sparseMembers = new SparseMember[1];
                n2 = 0;
            } else {
                for (n2 = 0; n2 < this._sparseMembers.length; ++n2) {
                    if (this._sparseMembers[n2].name.equals(string)) {
                        throw new BadMemberName();
                    }
                    for (int i = 0; i < this._sparseMembers[n2].representations.length; ++i) {
                        try {
                            if (this._sparseMembers[n2].member_representation_id(i) != n) continue;
                            throw new BadMemberId();
                        }
                        catch (Bounds bounds) {
                            IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                            throw illegalStateException;
                        }
                    }
                }
                n2 = this._sparseMembers.length;
                objectArray = new SparseMember[this._sparseMembers.length + 1];
                System.arraycopy(this._sparseMembers, 0, objectArray, 0, this._sparseMembers.length);
                this._sparseMembers = objectArray;
            }
            objectArray = new TypeCodeRepresentation[]{new TypeCodeRepresentation(n, bl, s2, typeCode)};
            this._sparseMembers[n2] = new SparseMember(string, (TypeCodeRepresentation[])objectArray, by, s);
        } else if (this._kind.equals(TCKind.TK_STRUCT)) {
            if (s != 1) {
                ModuleLogger.DDS.log(2, this.getClass(), "add_member", "Warning: ignoring non-public visibility");
            }
            boolean bl2 = by != 1 && by != 2;
            if (this._structMembers == null || this._structMembers.length == 0) {
                this._structMembers = new StructMember[1];
                n2 = 0;
            } else {
                for (n2 = 0; n2 < this._structMembers.length; ++n2) {
                    if (!this._structMembers[n2].name.equals(string)) continue;
                    throw new BadMemberName();
                }
                n2 = this._structMembers.length;
                StructMember[] structMemberArray = new StructMember[this._structMembers.length + 1];
                System.arraycopy(this._structMembers, 0, structMemberArray, 0, this._structMembers.length);
                this._structMembers = structMemberArray;
            }
            if (n == Integer.MAX_VALUE) {
                n = n2 > 0 ? this._structMembers[n2 - 1].id + 1 : 0;
            }
            if (this.exist_member_id(n, n2)) {
                throw new BadMemberId("Member ID " + n + " already exists");
            }
            if (n > 0xFFFBFFF) {
                throw new BadMemberId("Invalid member ID " + n);
            }
            this._structMembers[n2] = new StructMember(string, bl, s2, by == 1, typeCode, n, bl2);
        } else if (this._kind.equals(TCKind.TK_VALUE)) {
            Object object;
            boolean bl3 = by != 1 && by != 2;
            if (this._valueMembers == null || this._valueMembers.length == 0) {
                this._valueMembers = new ValueMember[1];
                n2 = 0;
            } else {
                for (n2 = 0; n2 < this._valueMembers.length; ++n2) {
                    if (!this._valueMembers[n2].name.equals(string)) continue;
                    throw new BadMemberName();
                }
                n2 = this._valueMembers.length;
                object = new ValueMember[this._valueMembers.length + 1];
                System.arraycopy(this._valueMembers, 0, object, 0, this._valueMembers.length);
                this._valueMembers = object;
            }
            if (n == Integer.MAX_VALUE) {
                object = null;
                if (n2 > 0) {
                    n = this._valueMembers[n2 - 1].id + 1;
                } else {
                    try {
                        object = this.concrete_base_type();
                        if (object != null && !object.kind().equals(TCKind.TK_NULL)) {
                            while (object.kind().equals(TCKind.TK_ALIAS)) {
                                object = object.content_type();
                            }
                            n = object.member_id(object.member_count() - 1);
                            ++n;
                        } else {
                            n = 0;
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException("Unexpected error");
                    }
                }
            }
            if (this.exist_member_id(n, n2)) {
                throw new BadMemberId("Member ID " + n + " already exists");
            }
            if (n > 0xFFFBFFF) {
                throw new BadMemberId("Invalid member ID " + n);
            }
            this._valueMembers[n2] = new ValueMember(string, bl, s2, by == 1, s, typeCode, n, bl3);
        } else if (this._kind.equals(TCKind.TK_UNION)) {
            if (s != 1) {
                ModuleLogger.DDS.log(2, this.getClass(), "add_member", "Warning: ignoring non-public visibility");
            }
            if (by != 0) {
                ModuleLogger.DDS.log(1, this.getClass(), "add_member", "required members and keys not allowed");
                throw new BAD_PARAM("required members and keys not allowed");
            }
            if (s2 != -1) {
                ModuleLogger.DDS.log(1, this.getClass(), "add_member", "bitfields not allowed");
                throw new BAD_PARAM("bitfields not allowed");
            }
            this.add_member_to_union(string, n, typeCode, bl);
        }
        return n2;
    }

    public synchronized int add_member_to_enum(String string, int n) throws BadKind, BadMemberName {
        if (this.lockTypeCode) {
            throw new RETCODE_ILLEGAL_OPERATION("add_member cannot be called after the native typecode is created");
        }
        int n2 = -1;
        if (!this._kind.equals(TCKind.TK_ENUM)) {
            throw new BadKind();
        }
        if (this._enumMembers == null || this._enumMembers.length == 0) {
            this._enumMembers = new EnumMember[1];
            n2 = 0;
        } else {
            for (n2 = 0; n2 < this._enumMembers.length; ++n2) {
                if (!this._enumMembers[n2].name.equals(string)) continue;
                throw new BadMemberName();
            }
            n2 = this._enumMembers.length;
            EnumMember[] enumMemberArray = new EnumMember[this._enumMembers.length + 1];
            System.arraycopy(this._enumMembers, 0, enumMemberArray, 0, this._enumMembers.length);
            this._enumMembers = enumMemberArray;
        }
        this._enumMembers[n2] = new EnumMember(string, n);
        if (this._nativeTypeObject != 0L) {
            TypeCode.delete_native_typeobject(this._nativeTypeObject);
            this._nativeTypeObject = 0L;
        }
        return n2;
    }

    public synchronized int add_member_to_union(String string, int n, TypeCode typeCode, boolean bl) throws BadKind, BadMemberName, BadMemberId {
        return this.add_member_to_union(string, Integer.MAX_VALUE, new int[]{n}, typeCode, bl);
    }

    public synchronized int add_member_to_union(String string, int n, int[] nArray, TypeCode typeCode, boolean bl) throws BadKind, BadMemberName, BadMemberId {
        Object[] objectArray;
        int n2;
        if (this.lockTypeCode) {
            throw new RETCODE_ILLEGAL_OPERATION("add_member cannot be called after the native typecode is created");
        }
        int n3 = -1;
        if (!this._kind.equals(TCKind.TK_UNION)) {
            throw new BadKind();
        }
        if (this._unionMembers == null || this._unionMembers.length == 0) {
            this._unionMembers = new UnionMember[1];
            n3 = 0;
        } else {
            for (n3 = 0; n3 < this._unionMembers.length; ++n3) {
                if (this._unionMembers[n3].name.equals(string)) {
                    throw new BadMemberName();
                }
                for (int i = 0; i < this._unionMembers[n3].labels.length; ++i) {
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (this._unionMembers[n3].labels[i] != nArray[n2]) continue;
                        throw new BadMemberId();
                    }
                }
            }
            n3 = this._unionMembers.length;
            objectArray = new UnionMember[this._unionMembers.length + 1];
            System.arraycopy(this._unionMembers, 0, objectArray, 0, this._unionMembers.length);
            this._unionMembers = (UnionMember[])objectArray;
        }
        objectArray = new int[nArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = nArray[n2];
        }
        if (n == Integer.MAX_VALUE) {
            n = n3 > 0 ? this._unionMembers[n3 - 1].id + 1 : 1;
        }
        if (this.exist_member_id(n, n3)) {
            throw new BadMemberId("Member ID " + n + " already exists");
        }
        if (n > 0xFFFBFFF) {
            throw new BadMemberId("Invalid member ID " + n);
        }
        this._unionMembers[n3] = new UnionMember(string, bl, (int[])objectArray, typeCode, n);
        return n3;
    }

    int add_representation(String string, int n, TypeCode typeCode, boolean bl, short s) throws BadKind, BadMemberId {
        if (this.lockTypeCode) {
            throw new RETCODE_ILLEGAL_OPERATION("add_member cannot be called after the native typecode is created");
        }
        int n2 = -1;
        if (!this._kind.equals(TCKind.TK_SPARSE)) {
            throw new BadKind();
        }
        for (n2 = 0; n2 < this._sparseMembers.length; ++n2) {
            for (int i = 0; i < this._sparseMembers[n2].representations.length; ++i) {
                try {
                    if (this._sparseMembers[n2].member_representation_id(i) != n) continue;
                    throw new BadMemberId();
                }
                catch (Bounds bounds) {
                    IllegalStateException illegalStateException = new IllegalStateException(bounds.getMessage());
                    throw illegalStateException;
                }
            }
        }
        for (n2 = 0; n2 < this._sparseMembers.length && !this._sparseMembers[n2].name.equals(string); ++n2) {
        }
        TypeCodeRepresentation[] typeCodeRepresentationArray = new TypeCodeRepresentation[this._sparseMembers[n2].representations.length + 1];
        System.arraycopy(this._sparseMembers[n2].representations, 0, typeCodeRepresentationArray, 0, this._sparseMembers[n2].representations.length);
        this._sparseMembers[n2].representations = this._sparseMembers[n2].representations;
        this._sparseMembers[n2].representations[this._sparseMembers[n2].representations.length] = new TypeCodeRepresentation(n, false, -1, typeCode);
        return this._sparseMembers[n2].representations.length - 1;
    }

    public String signature() throws RETCODE_ERROR {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = this.get_serialized_size(0, true);
            CdrOutputStream cdrOutputStream = new CdrOutputStream(n);
            this.serialize(cdrOutputStream, true);
            CdrBuffer cdrBuffer = cdrOutputStream.getBuffer();
            messageDigest.update(cdrBuffer.getBuffer(), 0, cdrBuffer.currentPosition());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF | 0x100).substring(1, 3));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new RETCODE_ERROR("error generating type code signature");
        }
    }

    public String toString() {
        return this.get_type_as_string();
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }

    public String get_type_as_string() {
        try {
            TCKind tCKind = this.kind();
            if (tCKind.equals(TCKind.TK_SHORT)) {
                return "short";
            }
            if (tCKind.equals(TCKind.TK_LONG)) {
                return "long";
            }
            if (tCKind.equals(TCKind.TK_USHORT)) {
                return "unsigned short";
            }
            if (tCKind.equals(TCKind.TK_ULONG)) {
                return "unsigned long";
            }
            if (tCKind.equals(TCKind.TK_FLOAT)) {
                return "float";
            }
            if (tCKind.equals(TCKind.TK_DOUBLE)) {
                return "double";
            }
            if (tCKind.equals(TCKind.TK_BOOLEAN)) {
                return "boolean";
            }
            if (tCKind.equals(TCKind.TK_CHAR)) {
                return "char";
            }
            if (tCKind.equals(TCKind.TK_OCTET)) {
                return "octet";
            }
            if (tCKind.equals(TCKind.TK_LONGLONG)) {
                return "long long";
            }
            if (tCKind.equals(TCKind.TK_ULONGLONG)) {
                return "unsigned long long";
            }
            if (tCKind.equals(TCKind.TK_LONGDOUBLE)) {
                return "long double";
            }
            if (tCKind.equals(TCKind.TK_WCHAR)) {
                return "wchar";
            }
            if (tCKind.equals(TCKind.TK_STRUCT) || tCKind.equals(TCKind.TK_UNION) || tCKind.equals(TCKind.TK_ENUM) || tCKind.equals(TCKind.TK_ALIAS) || tCKind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                return this.name();
            }
            if (tCKind.equals(TCKind.TK_STRING) || tCKind.equals(TCKind.TK_WSTRING) || tCKind.equals(TCKind.TK_SEQUENCE)) {
                String string;
                if (tCKind.equals(TCKind.TK_STRING)) {
                    string = "string<" + this.length() + ">";
                } else if (tCKind.equals(TCKind.TK_WSTRING)) {
                    string = "wstring<" + this.length() + ">";
                } else {
                    TypeCode typeCode = this.content_type();
                    string = "sequence<" + typeCode.get_type_as_string() + "," + this.length() + ">";
                }
                return string;
            }
            if (tCKind.equals(TCKind.TK_ARRAY)) {
                TypeCode typeCode = this.content_type();
                String string = typeCode.get_type_as_string();
                int n = this.array_dimension_count();
                for (int i = 0; i < n; ++i) {
                    string = string + "[" + this.array_dimension(i) + "]";
                }
                return string;
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private boolean exist_member_id(int n, int n2) {
        TypeCode typeCode = null;
        try {
            if (!(this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_UNION))) {
                throw new BadKind();
            }
            if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_STRUCT)) {
                TCKind tCKind;
                typeCode = this.concrete_base_type();
                if (typeCode != null && !(tCKind = typeCode.kind()).equals(TCKind.TK_NULL)) {
                    while (tCKind.equals(TCKind.TK_ALIAS)) {
                        typeCode = typeCode.content_type();
                        tCKind = typeCode.kind();
                    }
                    boolean bl = typeCode.exist_member_id(n, -1);
                    if (bl) {
                        return bl;
                    }
                }
            } else if (n == 0) {
                return false;
            }
            if (n2 == -1) {
                n2 = this.member_count();
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = this.member_id(i);
                if (n3 != n) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean is_base_kind(TCKind tCKind) {
        if (this._kind.equals(tCKind)) {
            return true;
        }
        if (this._kind.equals(TCKind.TK_ALIAS)) {
            return this._typeCode.is_base_kind(tCKind);
        }
        return false;
    }

    private boolean is_discriminator() {
        if (this._kind.equals(TCKind.TK_SHORT) || this._kind.equals(TCKind.TK_LONG) || this._kind.equals(TCKind.TK_LONGLONG) || this._kind.equals(TCKind.TK_USHORT) || this._kind.equals(TCKind.TK_ULONG) || this._kind.equals(TCKind.TK_ULONGLONG) || this._kind.equals(TCKind.TK_CHAR) || this._kind.equals(TCKind.TK_BOOLEAN) || this._kind.equals(TCKind.TK_ENUM)) {
            return true;
        }
        if (this._kind.equals(TCKind.TK_ALIAS)) {
            return this._typeCode.is_discriminator();
        }
        return false;
    }

    private void print_indent(int n, Writer writer) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write("    ");
        }
    }

    void delete() {
        if (this._nativeTypeCode != 0L) {
            TypeCode.delete_native_typecode(this._nativeTypeCode);
            this._nativeTypeCode = 0L;
        }
        if (this._nativeTypeObject != 0L) {
            TypeCode.delete_native_typeobject(this._nativeTypeObject);
            this._nativeTypeObject = 0L;
        }
        this._structMembers = null;
        this._unionMembers = null;
        this._enumMembers = null;
        this._valueMembers = null;
        this._sparseMembers = null;
    }

    public synchronized long get_native_typecode() {
        if (this._nativeTypeCode == 0L) {
            this._nativeTypeCode = this.push_to_nativeI();
            if (this._nativeTypeCode == 0L) {
                throw new RETCODE_ERROR("failed to allocate native TypeCode");
            }
            this.lockTypeCode = true;
        }
        return this._nativeTypeCode;
    }

    private synchronized long get_native_typeobject() {
        if (this._nativeTypeObject == 0L) {
            long l = this.get_native_typecode();
            this._nativeTypeObject = TypeCode.create_native_typeobject(l);
            if (this._nativeTypeObject == 0L) {
                throw new RETCODE_ERROR("failed to allocate native TypeObject");
            }
        }
        return this._nativeTypeObject;
    }

    public static TypeCode create_from_native(long l) {
        byte[] byArray = TypeCode.get_native_serialized_typecode(l);
        boolean bl = NativeInterface.getInstance().isNativeByteOrderLittleEndian();
        CdrInputStream cdrInputStream = new CdrInputStream(byArray, bl);
        TypeCode typeCode = TypeCodeFactory.get_instance().create_tc_from_stream(cdrInputStream);
        return typeCode;
    }

    private static native long create_native_tc_list();

    private static native void delete_native_tc_list(long var0);

    private static native boolean add_tc_native_library(long var0, long var2, String var4);

    private static native long get_native_primitive_tc(int var0);

    private static native long create_native_enum_tc(String var0, long var1);

    private static native long create_native_union_tc(String var0, long var1, long var3, long var5);

    private static native long lookup_native_tc(long var0, String var2);

    private static native long create_native_struct_tc(String var0, long var1);

    private static native long create_native_value_tc(String var0, long var1, short var3, long var4);

    private static native long create_native_sparse_tc(String var0, short var1, long var2);

    private static native long create_native_string_tc(long var0);

    private static native long create_native_wstring_tc(long var0);

    private static native long create_native_sequence_tc(long var0, long var2);

    private static native long create_native_array_tc(long var0, int[] var2, long var3);

    private static native long create_native_alias_tc(String var0, long var1, boolean var3);

    private static native long add_native_member_ex(long var0, String var2, int var3, long var4, byte var6, short var7, boolean var8, short var9);

    private static native long add_native_member_to_enum(long var0, String var2, long var3);

    private static native long add_native_member_to_union(long var0, String var2, int var3, int[] var4, long var5, long var7, boolean var9);

    private static native long create_native_typecode(byte[] var0, int var1);

    private static native void delete_native_typecode(long var0);

    private static native long create_native_typeobject(long var0);

    private static native void delete_native_typeobject(long var0);

    private static native byte[] get_native_serialized_typecode(long var0);

    private static native boolean is_native_assignable(long var0, long var2);

    private static native boolean is_native_equivalent(long var0, long var2);

    private int get_element_serialized_size_field_valueI(int n, int n2, boolean bl) {
        int n3 = n;
        try {
            n += (int)CdrPrimitiveType.getStringMaxSizeSerialized(n, this.member_name(n2).length() + 1);
        }
        catch (UserException userException) {
            // empty catch block
        }
        if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_VALUE)) {
            n += CdrPrimitiveType.BOOLEAN.getMaxSizeSerialized(n);
            n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
            n += CdrPrimitiveType.BOOLEAN.getMaxSizeSerialized(n);
            if (this._kind.equals(TCKind.TK_VALUE) || bl) {
                n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
                n = this._kind.equals(TCKind.TK_VALUE) ? (n += this._valueMembers[n2].type.get_serialized_size(n, bl)) : (n += this._structMembers[n2].type.get_serialized_size(n, bl));
            } else {
                n += this._structMembers[n2].type.get_serialized_size(n, bl);
            }
        } else if (this._kind.equals(TCKind.TK_SPARSE)) {
            n += CdrPrimitiveType.BYTE.getMaxSizeSerialized(n);
            n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
            n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
            for (int i = 0; i < this._sparseMembers[n2].representations.length; ++i) {
                n += this._sparseMembers[n2].representations[i].get_serialized_size(n, bl);
            }
        } else if (this._kind.equals(TCKind.TK_UNION)) {
            n += CdrPrimitiveType.BOOLEAN.getMaxSizeSerialized(n);
            n = (int)((long)n + CdrPrimitiveType.INT.getSequenceMaxSizeSerialized(n, this._unionMembers[n2].labels.length));
            n += this._unionMembers[n2].type.get_serialized_size(n, bl);
        } else {
            n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
        }
        return n - n3;
    }

    private int get_serialized_size_field_valueI(int n, boolean bl) {
        int n2 = n;
        try {
            if (this._kind.equals(TCKind.TK_STRING) || this._kind.equals(TCKind.TK_WSTRING)) {
                n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
            } else if (this._kind.equals(TCKind.TK_ARRAY)) {
                n = (int)((long)n + CdrPrimitiveType.INT.getSequenceMaxSizeSerialized(n, this._dimensions.length));
                n += this._typeCode.get_serialized_size(n, bl);
            } else if (this._kind.equals(TCKind.TK_SEQUENCE)) {
                n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
                n += this._typeCode.get_serialized_size(n, bl);
            } else if (this._kind.equals(TCKind.TK_ALIAS)) {
                n += (int)CdrPrimitiveType.getStringMaxSizeSerialized(n, this._name.length() + 1);
                n += CdrPrimitiveType.BOOLEAN.getMaxSizeSerialized(n);
                n += this._typeCode.get_serialized_size(n, bl);
            } else if (this._kind.equals(TCKind.TK_STRUCT) || this._kind.equals(TCKind.TK_UNION) || this._kind.equals(TCKind.TK_ENUM) || this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE)) {
                n += (int)CdrPrimitiveType.getStringMaxSizeSerialized(n, this._name.length() + 1);
                if (this._kind.equals(TCKind.TK_UNION)) {
                    n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
                    n += this._typeCode.get_serialized_size(n, bl);
                }
                if (this._kind.equals(TCKind.TK_VALUE) || this._kind.equals(TCKind.TK_SPARSE) || this._kind.equals(TCKind.TK_STRUCT) && bl) {
                    n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
                    n += this._typeCode.get_serialized_size(n, bl);
                }
                n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
                int n3 = this.member_count();
                for (int i = 0; i < n3; ++i) {
                    n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
                    n += this.get_element_serialized_size_field_valueI(n, i, bl);
                }
            } else {
                n += 0;
            }
            return n - n2;
        }
        catch (Exception exception) {
            return n - n2;
        }
    }

    public int get_serialized_size(int n, boolean bl) {
        int n2 = n;
        n += CdrPrimitiveType.INT.getMaxSizeSerialized(n);
        n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
        n += this.get_serialized_size_field_valueI(n, bl);
        return n - n2;
    }

    public int get_serialized_size(int n) {
        return this.get_serialized_size(n, false);
    }

    private void serialize_member(int n, CdrOutputStream cdrOutputStream, boolean bl) {
        IntSeq intSeq = null;
        if (this._kind.equals(TCKind.TK_STRUCT)) {
            cdrOutputStream.writeString(this._structMembers[n].name);
            cdrOutputStream.writeBoolean(this._structMembers[n].is_pointer);
            cdrOutputStream.writeShort(this._structMembers[n].bits);
            cdrOutputStream.writeBoolean(this._structMembers[n].is_key);
            if (bl) {
                cdrOutputStream.writeShort(1);
            }
            this._structMembers[n].type.serialize(cdrOutputStream, bl);
        } else if (this._kind.equals(TCKind.TK_VALUE)) {
            cdrOutputStream.writeString(this._valueMembers[n].name);
            cdrOutputStream.writeBoolean(this._valueMembers[n].is_pointer);
            cdrOutputStream.writeShort(this._valueMembers[n].bits);
            cdrOutputStream.writeBoolean(this._valueMembers[n].is_key);
            cdrOutputStream.writeShort(this._valueMembers[n].access);
            this._valueMembers[n].type.serialize(cdrOutputStream, bl);
        } else if (this._kind.equals(TCKind.TK_SPARSE)) {
            cdrOutputStream.writeString(this._sparseMembers[n].name);
            cdrOutputStream.writeByte(this._sparseMembers[n].member_flags);
            cdrOutputStream.writeShort(this._sparseMembers[n].access);
            cdrOutputStream.writeShort(this._sparseMembers[n].representations.length);
            for (int i = 0; i < this._sparseMembers[n].representations.length; ++i) {
                this._sparseMembers[n].representations[i].serialize(cdrOutputStream, bl);
            }
        } else if (this._kind.equals(TCKind.TK_UNION)) {
            cdrOutputStream.writeString(this._unionMembers[n].name);
            cdrOutputStream.writeBoolean(this._unionMembers[n].is_pointer);
            intSeq = new IntSeq(this._unionMembers[n].labels.length);
            intSeq.addAllInt(this._unionMembers[n].labels);
            cdrOutputStream.writeIntSeq(intSeq);
            this._unionMembers[n].type.serialize(cdrOutputStream, bl);
        } else {
            cdrOutputStream.writeString(this._enumMembers[n].name);
            cdrOutputStream.writeInt(this._enumMembers[n].ordinal);
        }
    }

    public void serialize(CdrOutputStream cdrOutputStream, boolean bl) {
        TCKind tCKind;
        CdrBuffer cdrBuffer = null;
        IntSeq intSeq = null;
        int n = this._kind.ordinal();
        if (bl && this._kind.equals(TCKind.TK_STRUCT)) {
            n = TCKind.TK_VALUE.ordinal();
            tCKind = TCKind.TK_VALUE;
        } else {
            tCKind = this._kind;
        }
        n |= Integer.MIN_VALUE;
        if (tCKind.equals(TCKind.TK_STRUCT) || tCKind.equals(TCKind.TK_VALUE) || tCKind.equals(TCKind.TK_ENUM)) {
            if (this._extensibilityKind.equals(ExtensibilityKind.FINAL_EXTENSIBILITY)) {
                n |= 0x4000;
            } else if (this._extensibilityKind.equals(ExtensibilityKind.MUTABLE_EXTENSIBILITY)) {
                n |= 0x2000;
            }
        }
        cdrBuffer = cdrOutputStream.getBuffer();
        int n2 = cdrBuffer.currentPosition();
        int n3 = this.get_serialized_size_field_valueI(cdrBuffer.currentPosition() + CdrPrimitiveType.INT.getMaxSizeSerialized(cdrBuffer.currentPosition()) + CdrPrimitiveType.SHORT.size, bl);
        if (n3 + CdrPrimitiveType.INT.getMaxSizeSerialized(cdrBuffer.currentPosition()) + CdrPrimitiveType.SHORT.size > RTI_CDR_TYPE_CODE_MAX_SERIALIZED_SIZE) {
            cdrOutputStream.writeInt(-1);
            cdrOutputStream.writeShort(0);
            return;
        }
        cdrOutputStream.writeInt(n);
        n3 = this.get_serialized_size_field_valueI(cdrBuffer.currentPosition() + CdrPrimitiveType.SHORT.size, bl);
        cdrOutputStream.writeShort(n3);
        if (tCKind.equals(TCKind.TK_STRING) || tCKind.equals(TCKind.TK_WSTRING)) {
            cdrOutputStream.writeInt(this._maximumLength);
        } else if (tCKind.equals(TCKind.TK_ARRAY)) {
            intSeq = new IntSeq(this._dimensions.length);
            intSeq.addAllInt(this._dimensions);
            cdrOutputStream.writeIntSeq(intSeq);
            this._typeCode.serialize(cdrOutputStream, bl);
        } else if (tCKind.equals(TCKind.TK_SEQUENCE)) {
            cdrOutputStream.writeInt(this._maximumLength);
            this._typeCode.serialize(cdrOutputStream, bl);
        } else if (tCKind.equals(TCKind.TK_ALIAS)) {
            cdrOutputStream.writeString(this._name);
            cdrOutputStream.writeBoolean(this._isPointer);
            this._typeCode.serialize(cdrOutputStream, bl);
        } else if (tCKind.equals(TCKind.TK_STRUCT) || tCKind.equals(TCKind.TK_UNION) || tCKind.equals(TCKind.TK_ENUM) || tCKind.equals(TCKind.TK_VALUE) || tCKind.equals(TCKind.TK_SPARSE)) {
            cdrOutputStream.writeString(this._name);
            if (tCKind.equals(TCKind.TK_UNION)) {
                cdrOutputStream.writeInt(this._default_index);
                this._typeCode.serialize(cdrOutputStream, bl);
            }
            if (tCKind.equals(TCKind.TK_VALUE) || tCKind.equals(TCKind.TK_SPARSE)) {
                cdrOutputStream.writeShort(this._typeModifier);
                this._typeCode.serialize(cdrOutputStream, bl);
            }
            try {
                cdrOutputStream.writeInt(this.member_count());
                int n4 = this.member_count();
                for (int i = 0; i < n4; ++i) {
                    cdrOutputStream.getBuffer().align(CdrPrimitiveType.SHORT.alignment);
                    n2 = cdrOutputStream.getBuffer().currentPosition();
                    n3 = this.get_element_serialized_size_field_valueI(n2 + CdrPrimitiveType.SHORT.size, i, bl);
                    cdrOutputStream.writeShort(n3);
                    this.serialize_member(i, cdrOutputStream, bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void serialize(CdrOutputStream cdrOutputStream) {
        this.serialize(cdrOutputStream, false);
    }

    static {
        NativeInterface.getInstance().loadNativeLibraries();
    }
}

