/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_OUT_OF_RESOURCES;
import com.rti.dds.util.AbstractSequence;
import com.rti.dds.util.NativeInterface;
import com.rti.ndds.config.ModuleLogger;

public abstract class AbstractNativeSequence
extends AbstractSequence {
    private long _nativeSequencePtr;
    protected static final RuntimeException FAILED_ALLOCATION = new RETCODE_OUT_OF_RESOURCES("unable to reallocate sequence");
    protected static final RuntimeException INCONSISTENT_STATE = new RETCODE_ERROR("possible concurrent modification");

    public AbstractNativeSequence(Class clazz, long l, int n) {
        super(clazz);
        if (l == 0L) {
            throw new IllegalArgumentException("NULL native pointer");
        }
        this._nativeSequencePtr = l;
        this.setMaximum(n);
    }

    public final void destroy() {
        if (this._nativeSequencePtr != 0L) {
            this.setMaximum(0);
            this.destroyNativeSequence(this._nativeSequencePtr);
            this._nativeSequencePtr = 0L;
        }
    }

    public abstract Object get(int var1);

    public abstract Object set(int var1, Object var2);

    protected long getNativeSequence() {
        return this._nativeSequencePtr;
    }

    protected abstract void destroyNativeSequence(long var1);

    protected abstract void incrementSize();

    protected abstract void decrementSize();

    protected final void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            ModuleLogger.DDS.logStackTrace(this.getClass(), "finalize", throwable);
            throw throwable;
        }
    }

    static {
        NativeInterface.getInstance().loadNativeLibraries();
    }
}

