/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.util.Sequence;
import com.rti.dds.util.Sequences;
import com.rti.dds.util.Utilities;
import java.io.Serializable;
import java.util.AbstractList;

public abstract class AbstractSequence
extends AbstractList
implements Sequence,
Serializable {
    private static final long serialVersionUID = 5442580504635520860L;
    private static final RuntimeException NEGATIVE_MAXIMUM = new IllegalArgumentException("max size < 0");
    private static final RuntimeException NULL_ELEMENT_TYPE = new NullPointerException("null element type");
    private static final RuntimeException OUT_OF_BOUNDS = new IndexOutOfBoundsException();
    private final Class _elementType;

    public void setMaximum(int n) {
        AbstractSequence.checkNegativeMaximum(n);
        if (n != this.getMaximum()) {
            this.reallocate(n);
        }
    }

    public Class getElementType() {
        return this._elementType;
    }

    public void add(int n, Object object) {
        Sequences.checkElementType(this._elementType, object);
        this.shiftAndEnlarge(n);
        this.set(n, object);
    }

    public boolean add(Object object) {
        return super.add(object);
    }

    public final Object remove(int n) {
        Object e = this.get(n);
        this.shiftLeftByOne(n);
        this.decrementSize();
        return e;
    }

    protected AbstractSequence(Class clazz) {
        AbstractSequence.checkNullElementType(clazz);
        this._elementType = clazz;
    }

    protected final void shiftAndEnlarge(int n) {
        this.checkBounds(n, true);
        this.ensureSpaceForAdditionalElements(1);
        this.incrementSize();
        this.shiftRightByOne(n);
    }

    protected void shiftRightByOne(int n) {
        for (int i = this.size() - 2; i >= n; --i) {
            Object e = this.get(i);
            this.set(i + 1, e);
        }
    }

    protected void shiftLeftByOne(int n) {
        int n2 = this.size() - 1;
        for (int i = n; i < n2; ++i) {
            Object e = this.get(i + 1);
            this.set(i, e);
        }
    }

    protected final void checkBounds(int n, boolean bl) {
        if (n < 0) {
            Utilities.rethrow(OUT_OF_BOUNDS);
        }
        this.checkIndexUpperBound(n, bl);
    }

    protected final void checkIndexUpperBound(int n, boolean bl) {
        if (bl) {
            --n;
        }
        if (n >= this.size()) {
            Utilities.rethrow(OUT_OF_BOUNDS);
        }
    }

    protected final void ensureSpaceForAdditionalElements(int n) {
        int n2 = this.size() + n;
        this.ensureMaximum(n2);
    }

    protected final void ensureMaximum(int n) {
        if (n > this.getMaximum()) {
            this.reallocate(n);
        }
    }

    protected abstract void reallocate(int var1);

    static void checkNegativeMaximum(int n) {
        if (n < 0) {
            Utilities.rethrow(NEGATIVE_MAXIMUM);
        }
    }

    static void checkNullElementType(Class clazz) {
        if (clazz == null) {
            Utilities.rethrow(NULL_ELEMENT_TYPE);
        }
    }

    abstract void incrementSize();

    abstract void decrementSize();
}

