/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.config;

public final class LogBitmap {
    private static final String SILENCE_NAME = "SILENCE";
    private static final String EXCEPTION_NAME = "EXCEPTION";
    private static final String WARN_NAME = "WARN";
    private static final String LOCAL_NAME = "LOCAL";
    private static final String REMOTE_NAME = "REMOTE";
    private static final String PERIODIC_NAME = "PERIODIC";
    private static final String CONTENT_NAME = "CONTENT";
    private static final String OTHER_NAME = "OTHER";
    private static final String WORKER_STAT_NAME = "WORKER_STAT";
    public static final int SILENCE = 0;
    public static final int EXCEPTION = 1;
    public static final int WARN = 2;
    public static final int LOCAL = 4;
    public static final int REMOTE = 8;
    public static final int PERIODIC = 16;
    public static final int CONTENT = 32;
    public static final int OTHER = 64;
    public static final int WORKER_STAT = 256;
    public static final int DEFAULT = 1;
    public static final int ALL = 255;
    public static final int NONE = -256;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int parse(String string, boolean bl) {
        int n = 0;
        if (string.startsWith("0x")) return Integer.parseInt(string.substring(2), 16);
        if (string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (!Character.isLetter(string.charAt(0))) return Integer.parseInt(string, 10);
        if (SILENCE_NAME.equalsIgnoreCase(string)) {
            return 0;
        }
        if (EXCEPTION_NAME.equalsIgnoreCase(string)) {
            return 1;
        }
        if (WARN_NAME.equalsIgnoreCase(string)) {
            return 2;
        }
        if (LOCAL_NAME.equalsIgnoreCase(string)) {
            return 4;
        }
        if (REMOTE_NAME.equalsIgnoreCase(string)) {
            return 8;
        }
        if (PERIODIC_NAME.equalsIgnoreCase(string)) {
            return 16;
        }
        if (CONTENT_NAME.equalsIgnoreCase(string)) {
            return 32;
        }
        if (OTHER_NAME.equalsIgnoreCase(string)) {
            return 64;
        }
        if (!WORKER_STAT_NAME.equalsIgnoreCase(string)) throw new NumberFormatException("unrecognized bitmap name: " + string);
        return 256;
    }

    private LogBitmap() {
    }
}

