/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.transport;

import com.rti.ndds.transport.Transport;

public interface ShmemTransport
extends Transport {
    public static final int CLASSID = 2;
    public static final int ADDRESS_BIT_COUNT = 0;
    public static final int MESSAGE_SIZE_MAX_DEFAULT = 65536;
    public static final int RECEIVED_MESSAGE_COUNT_MAX_DEFAULT = 64;
    public static final int RECEIVE_BUFFER_SIZE_DEFAULT = 0x100000;

    public static class Property_t
    extends Transport.Property_t {
        public int received_message_count_max = 64;
        public int receive_buffer_size = 0x100000;

        public Property_t() {
            super(2, 0, 0, 1024, 65536);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Property_t)) {
                return false;
            }
            Property_t property_t = (Property_t)object;
            return super.equals(object) && this.received_message_count_max == property_t.received_message_count_max && this.receive_buffer_size == property_t.receive_buffer_size;
        }

        public int hashCode() {
            return super.hashCode() + this.received_message_count_max + this.receive_buffer_size;
        }

        protected void pull_from_nativeI(long l) {
            super.pull_from_nativeI(l);
            this.received_message_count_max = Property_t.get_native_received_message_count_maxI(l);
            this.receive_buffer_size = Property_t.get_native_receive_buffer_sizeI(l);
        }

        protected void push_to_nativeI(long l) {
            super.push_to_nativeI(l);
            Property_t.set_native_received_message_count_maxI(l, this.received_message_count_max);
            Property_t.set_native_receive_buffer_sizeI(l, this.receive_buffer_size);
        }

        private static native int get_native_received_message_count_maxI(long var0);

        private static native void set_native_received_message_count_maxI(long var0, int var2);

        private static native int get_native_receive_buffer_sizeI(long var0);

        private static native void set_native_receive_buffer_sizeI(long var0, int var2);
    }
}

