/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.transport;

import com.rti.dds.infrastructure.StringHelper;
import com.rti.ndds.transport.Transport;

public interface UDPv4Transport
extends Transport {
    public static final int CLASSID = 1;
    public static final int ADDRESS_BIT_COUNT = 32;
    public static final int BLOCKING_NEVER = 0;
    public static final int BLOCKING_ALWAYS = 1;
    public static final int BLOCKING_UNICAST_ONLY = 2;
    public static final int UDPV4_PAYLOAD_SIZE_MAX = 65507;
    public static final int MESSAGE_SIZE_MAX_DEFAULT = 65507;
    public static final int SEND_SOCKET_BUFFER_SIZE_DEFAULT = 131072;
    public static final int RECV_SOCKET_BUFFER_SIZE_DEFAULT = 131072;

    public static class Property_t
    extends Transport.Property_t {
        public int send_socket_buffer_size = 131072;
        public int recv_socket_buffer_size = 131072;
        public int unicast_enabled = 1;
        public int multicast_enabled = 1;
        public int multicast_ttl = 1;
        public int multicast_loopback_disabled = 0;
        public int ignore_loopback_interface = -1;
        public int ignore_nonup_interfaces = 1;
        public int ignore_nonrunning_interfaces = 0;
        public int no_zero_copy = 0;
        public int send_blocking = 1;
        public long transport_priority_mask = 0L;
        public int transport_priority_mapping_low = 0;
        public int transport_priority_mapping_high = 255;
        public int send_ping = 1;
        public long interface_poll_period = 500L;
        public int reuse_multicast_receive_resource = 0;
        public int protocol_overhead_max = 28;
        public String public_address = null;

        public Property_t() {
            super(1, 32, 0, 16, 65507);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                return true;
            }
            if (!(object instanceof Property_t)) {
                return false;
            }
            Property_t property_t = (Property_t)object;
            if (this.public_address != null) {
                if (property_t.public_address != null) {
                    bl = this.public_address.equals(property_t.public_address);
                }
            } else if (property_t.public_address == null) {
                bl = true;
            }
            return super.equals(object) && bl && this.send_socket_buffer_size == property_t.send_socket_buffer_size && this.recv_socket_buffer_size == property_t.recv_socket_buffer_size && this.unicast_enabled == property_t.unicast_enabled && this.multicast_enabled == property_t.multicast_enabled && this.multicast_ttl == property_t.multicast_ttl && this.multicast_loopback_disabled == property_t.multicast_loopback_disabled && this.ignore_loopback_interface == property_t.ignore_loopback_interface && this.ignore_nonup_interfaces == property_t.ignore_nonup_interfaces && this.ignore_nonrunning_interfaces == property_t.ignore_nonrunning_interfaces && this.no_zero_copy == property_t.no_zero_copy && this.send_blocking == property_t.send_blocking && this.transport_priority_mask == property_t.transport_priority_mask && this.transport_priority_mapping_low == property_t.transport_priority_mapping_low && this.transport_priority_mapping_high == property_t.transport_priority_mapping_high && this.interface_poll_period == property_t.interface_poll_period && this.reuse_multicast_receive_resource == property_t.reuse_multicast_receive_resource && this.send_ping == property_t.send_ping && this.protocol_overhead_max == property_t.protocol_overhead_max;
        }

        public int hashCode() {
            return super.hashCode() + this.send_socket_buffer_size + this.recv_socket_buffer_size + this.unicast_enabled + this.multicast_enabled + this.multicast_ttl + this.multicast_loopback_disabled + this.ignore_loopback_interface + this.ignore_nonup_interfaces + this.ignore_nonrunning_interfaces + this.no_zero_copy + this.send_blocking + this.transport_priority_mapping_low + this.transport_priority_mapping_high + this.send_ping + this.reuse_multicast_receive_resource + this.protocol_overhead_max;
        }

        protected void pull_from_nativeI(long l) {
            super.pull_from_nativeI(l);
            this.send_socket_buffer_size = Property_t.get_native_send_socket_buffer_sizeI(l);
            this.recv_socket_buffer_size = Property_t.get_native_recv_socket_buffer_sizeI(l);
            this.unicast_enabled = Property_t.get_native_unicast_enabledI(l);
            this.multicast_enabled = Property_t.get_native_multicast_enabledI(l);
            this.multicast_ttl = Property_t.get_native_multicast_ttlI(l);
            this.multicast_loopback_disabled = Property_t.get_native_multicast_loopback_diabledI(l);
            this.ignore_loopback_interface = Property_t.get_native_ignore_loopback_interfaceI(l);
            this.ignore_nonup_interfaces = Property_t.get_native_ignore_nonup_interfacesI(l);
            this.ignore_nonrunning_interfaces = Property_t.get_native_ignore_nonrunning_interfacesI(l);
            this.no_zero_copy = Property_t.get_native_no_zero_copyI(l);
            this.send_blocking = Property_t.get_native_send_blockingI(l);
            this.transport_priority_mask = Property_t.get_native_transport_priority_maskI(l);
            this.transport_priority_mapping_low = Property_t.get_native_transport_priority_mapping_lowI(l);
            this.transport_priority_mapping_high = Property_t.get_native_transport_priority_mapping_highI(l);
            this.send_ping = Property_t.get_native_send_pingI(l);
            this.interface_poll_period = Property_t.get_native_interface_poll_periodI(l);
            this.reuse_multicast_receive_resource = Property_t.get_native_reuse_multicast_receive_resourceI(l);
            this.protocol_overhead_max = Property_t.get_native_protocol_overhead_maxI(l);
            long l2 = Property_t.get_native_public_addressI(l);
            this.public_address = StringHelper.dup_native_stringI(l2);
        }

        protected void push_to_nativeI(long l) {
            super.push_to_nativeI(l);
            Property_t.set_native_send_socket_buffer_sizeI(l, this.send_socket_buffer_size);
            Property_t.set_native_recv_socket_buffer_sizeI(l, this.recv_socket_buffer_size);
            Property_t.set_native_unicast_enabledI(l, this.unicast_enabled);
            Property_t.set_native_multicast_enabledI(l, this.multicast_enabled);
            Property_t.set_native_multicast_ttlI(l, this.multicast_ttl);
            Property_t.set_native_multicast_loopback_diabledI(l, this.multicast_loopback_disabled);
            Property_t.set_native_ignore_loopback_interfaceI(l, this.ignore_loopback_interface);
            Property_t.set_native_ignore_nonup_interfacesI(l, this.ignore_nonup_interfaces);
            Property_t.set_native_ignore_nonrunning_interfacesI(l, this.ignore_nonrunning_interfaces);
            Property_t.set_native_no_zero_copyI(l, this.no_zero_copy);
            Property_t.set_native_send_blockingI(l, this.send_blocking);
            Property_t.set_native_transport_priority_maskI(l, this.transport_priority_mask);
            Property_t.set_native_transport_priority_mapping_lowI(l, this.transport_priority_mapping_low);
            Property_t.set_native_transport_priority_mapping_highI(l, this.transport_priority_mapping_high);
            Property_t.set_native_send_pingI(l, this.send_ping);
            Property_t.set_native_interface_poll_periodI(l, this.interface_poll_period);
            Property_t.set_native_reuse_multicast_receive_resourceI(l, this.reuse_multicast_receive_resource);
            Property_t.set_native_protocol_overhead_maxI(l, this.protocol_overhead_max);
            long l2 = Property_t.get_native_public_addressI(l);
            StringHelper.replace_native_stringI(l2, this.public_address);
        }

        private static native int get_native_send_socket_buffer_sizeI(long var0);

        private static native void set_native_send_socket_buffer_sizeI(long var0, int var2);

        private static native int get_native_recv_socket_buffer_sizeI(long var0);

        private static native void set_native_recv_socket_buffer_sizeI(long var0, int var2);

        private static native int get_native_unicast_enabledI(long var0);

        private static native void set_native_unicast_enabledI(long var0, int var2);

        private static native int get_native_multicast_enabledI(long var0);

        private static native void set_native_multicast_enabledI(long var0, int var2);

        private static native int get_native_multicast_ttlI(long var0);

        private static native void set_native_multicast_ttlI(long var0, int var2);

        private static native int get_native_multicast_loopback_diabledI(long var0);

        private static native void set_native_multicast_loopback_diabledI(long var0, int var2);

        private static native int get_native_ignore_loopback_interfaceI(long var0);

        private static native void set_native_ignore_loopback_interfaceI(long var0, int var2);

        private static native int get_native_ignore_nonup_interfacesI(long var0);

        private static native void set_native_ignore_nonup_interfacesI(long var0, int var2);

        private static native int get_native_ignore_nonrunning_interfacesI(long var0);

        private static native void set_native_ignore_nonrunning_interfacesI(long var0, int var2);

        private static native int get_native_no_zero_copyI(long var0);

        private static native void set_native_no_zero_copyI(long var0, int var2);

        private static native int get_native_send_blockingI(long var0);

        private static native void set_native_send_blockingI(long var0, int var2);

        private static native long get_native_transport_priority_maskI(long var0);

        private static native void set_native_transport_priority_maskI(long var0, long var2);

        private static native int get_native_transport_priority_mapping_lowI(long var0);

        private static native void set_native_transport_priority_mapping_lowI(long var0, int var2);

        private static native int get_native_transport_priority_mapping_highI(long var0);

        private static native void set_native_transport_priority_mapping_highI(long var0, int var2);

        private static native int get_native_send_pingI(long var0);

        private static native void set_native_send_pingI(long var0, int var2);

        private static native long get_native_interface_poll_periodI(long var0);

        private static native void set_native_interface_poll_periodI(long var0, long var2);

        private static native int get_native_reuse_multicast_receive_resourceI(long var0);

        private static native void set_native_reuse_multicast_receive_resourceI(long var0, int var2);

        private static native int get_native_protocol_overhead_maxI(long var0);

        private static native void set_native_protocol_overhead_maxI(long var0, int var2);

        private static native long get_native_public_addressI(long var0);
    }
}

