/*
 * Decompiled with CFR 0.152.
 */
package com.toc.coredx.DDS;

import com.toc.coredx.DDS.CoreDX_IpTransportInterface;
import com.toc.coredx.DDS.CoreDX_IpTransportInterfaceSeq;
import com.toc.coredx.DDS.CoreDX_SslTransportConfig;
import com.toc.coredx.DDS.IpTransportInterface;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.coredx;
import java.util.Enumeration;
import java.util.Vector;

public class SslTransportConfig {
    public short participant_index;
    public Vector<IpTransportInterface> interfaces = new Vector();
    public boolean dynamic_interfaces;
    public int tx_max_packet_size;
    public int debug_flags;
    public String server_cert_file;
    public String server_key_file;
    public boolean server_verify_client;
    public String server_verify_ca_list_file;
    public String server_accept_ca_list_file;
    public String client_cert_file;
    public String client_key_file;
    public String client_verify_ca_list_file;

    public SslTransportConfig() {
        this.get_default_config();
    }

    public ReturnCode_t get_default_config() {
        CoreDX_SslTransportConfig coreDX_SslTransportConfig = this.toCore();
        int n = coredx.CoreDX_SslTransport_get_default_config(coreDX_SslTransportConfig);
        this.copyFromCore(coreDX_SslTransportConfig);
        coredx.CoreDX_SslTransport_clear_config(coreDX_SslTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    public ReturnCode_t get_env_config() {
        CoreDX_SslTransportConfig coreDX_SslTransportConfig = this.toCore();
        int n = coredx.CoreDX_SslTransport_get_env_config(coreDX_SslTransportConfig);
        this.copyFromCore(coreDX_SslTransportConfig);
        coredx.CoreDX_SslTransport_clear_config(coreDX_SslTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    void copyFromCore(CoreDX_SslTransportConfig coreDX_SslTransportConfig) {
        this.participant_index = coreDX_SslTransportConfig.getParticipant_index();
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_SslTransportConfig.getInterfaces();
        this.interfaces = new Vector((int)coreDX_IpTransportInterfaceSeq.get_length());
        for (long i = 0L; i < coreDX_IpTransportInterfaceSeq.get_length(); ++i) {
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = coredx.CoreDX_IpTransportInterfaceSeq_get(coreDX_IpTransportInterfaceSeq, i);
            IpTransportInterface ipTransportInterface = new IpTransportInterface(coreDX_IpTransportInterface);
            this.interfaces.add(ipTransportInterface);
            System.out.println("SslTransportConfig: added interface: " + ipTransportInterface);
            System.out.println(String.format("%d.%d.%d.%d", ipTransportInterface.addr[0], ipTransportInterface.addr[1], ipTransportInterface.addr[2], ipTransportInterface.addr[3]));
        }
        this.dynamic_interfaces = coreDX_SslTransportConfig.getDynamic_interfaces() != 0;
        this.tx_max_packet_size = coreDX_SslTransportConfig.getTx_max_packet_size();
        this.debug_flags = (int)coreDX_SslTransportConfig.getDebug_flags();
        this.server_cert_file = coreDX_SslTransportConfig.getServer_cert_file();
        this.server_key_file = coreDX_SslTransportConfig.getServer_key_file();
        this.server_verify_client = coreDX_SslTransportConfig.getServer_verify_client() != 0;
        this.server_verify_ca_list_file = coreDX_SslTransportConfig.getServer_verify_ca_list_file();
        this.server_accept_ca_list_file = coreDX_SslTransportConfig.getServer_accept_ca_list_file();
        this.client_cert_file = coreDX_SslTransportConfig.getClient_cert_file();
        this.client_key_file = coreDX_SslTransportConfig.getClient_key_file();
        this.client_verify_ca_list_file = coreDX_SslTransportConfig.getClient_verify_ca_list_file();
    }

    CoreDX_SslTransportConfig toCore() {
        CoreDX_SslTransportConfig coreDX_SslTransportConfig = new CoreDX_SslTransportConfig();
        coredx.CoreDX_SslTransport_get_default_config(coreDX_SslTransportConfig);
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_SslTransportConfig.getInterfaces();
        coreDX_SslTransportConfig.setParticipant_index(this.participant_index);
        Enumeration<IpTransportInterface> enumeration = this.interfaces.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            IpTransportInterface ipTransportInterface = enumeration.nextElement();
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = new CoreDX_IpTransportInterface();
            if (ipTransportInterface.kind == IpTransportInterface.Kind.IPV4_ADDRESS) {
                coreDX_IpTransportInterface.setAddr_family(1);
                for (n = 0; n < 4; ++n) {
                    coredx.CoreDX_IpTransportInterface_set_addr_byte(coreDX_IpTransportInterface, n, ipTransportInterface.addr[n]);
                }
                coredx.CoreDX_IpTransportInterfaceSeq_add(coreDX_IpTransportInterfaceSeq, coreDX_IpTransportInterface);
                continue;
            }
            if (ipTransportInterface.kind != IpTransportInterface.Kind.IPV6_ADDRESS) continue;
            coreDX_IpTransportInterface.setAddr_family(2);
            for (n = 0; n < 16; ++n) {
                coredx.CoreDX_IpTransportInterface_set_addr_byte(coreDX_IpTransportInterface, n, ipTransportInterface.addr[n]);
            }
            coredx.CoreDX_IpTransportInterfaceSeq_add(coreDX_IpTransportInterfaceSeq, coreDX_IpTransportInterface);
        }
        coreDX_SslTransportConfig.setDynamic_interfaces((short)(this.dynamic_interfaces ? 1 : 0));
        coreDX_SslTransportConfig.setTx_max_packet_size(this.tx_max_packet_size);
        coreDX_SslTransportConfig.setDebug_flags(this.debug_flags);
        coreDX_SslTransportConfig.setServer_cert_file(this.server_cert_file);
        coreDX_SslTransportConfig.setServer_key_file(this.server_key_file);
        coreDX_SslTransportConfig.setServer_verify_client((short)(this.server_verify_client ? 1 : 0));
        coreDX_SslTransportConfig.setServer_verify_ca_list_file(this.server_verify_ca_list_file);
        coreDX_SslTransportConfig.setServer_accept_ca_list_file(this.server_accept_ca_list_file);
        coreDX_SslTransportConfig.setClient_cert_file(this.client_cert_file);
        coreDX_SslTransportConfig.setClient_key_file(this.client_key_file);
        coreDX_SslTransportConfig.setClient_verify_ca_list_file(this.client_verify_ca_list_file);
        return coreDX_SslTransportConfig;
    }
}

