/*
 * Decompiled with CFR 0.152.
 */
package com.toc.coredx.DDS;

import com.toc.coredx.DDS.CoreDX_IpTransportInterface;
import com.toc.coredx.DDS.CoreDX_IpTransportInterfaceSeq;
import com.toc.coredx.DDS.CoreDX_TcpTransportConfig;
import com.toc.coredx.DDS.IpTransportInterface;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.coredx;
import java.util.Enumeration;
import java.util.Vector;

public class TcpTransportConfig {
    public short participant_index;
    public Vector<IpTransportInterface> interfaces = new Vector();
    public boolean dynamic_interfaces;
    public int tx_max_packet_size;
    public int debug_flags;

    public TcpTransportConfig() {
        this.get_default_config();
    }

    public ReturnCode_t get_default_config() {
        CoreDX_TcpTransportConfig coreDX_TcpTransportConfig = this.toCore();
        int n = coredx.CoreDX_TcpTransport_get_default_config(coreDX_TcpTransportConfig);
        this.copyFromCore(coreDX_TcpTransportConfig);
        coredx.CoreDX_TcpTransport_clear_config(coreDX_TcpTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    public ReturnCode_t get_env_config() {
        CoreDX_TcpTransportConfig coreDX_TcpTransportConfig = this.toCore();
        int n = coredx.CoreDX_TcpTransport_get_env_config(coreDX_TcpTransportConfig);
        this.copyFromCore(coreDX_TcpTransportConfig);
        coredx.CoreDX_TcpTransport_clear_config(coreDX_TcpTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    void copyFromCore(CoreDX_TcpTransportConfig coreDX_TcpTransportConfig) {
        this.participant_index = coreDX_TcpTransportConfig.getParticipant_index();
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_TcpTransportConfig.getInterfaces();
        this.interfaces = new Vector((int)coreDX_IpTransportInterfaceSeq.get_length());
        for (long i = 0L; i < coreDX_IpTransportInterfaceSeq.get_length(); ++i) {
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = coredx.CoreDX_IpTransportInterfaceSeq_get(coreDX_IpTransportInterfaceSeq, i);
            IpTransportInterface ipTransportInterface = new IpTransportInterface(coreDX_IpTransportInterface);
            this.interfaces.add(ipTransportInterface);
            System.out.println("TcpTransportConfig: added interface: " + ipTransportInterface);
            System.out.println(String.format("%d.%d.%d.%d", ipTransportInterface.addr[0], ipTransportInterface.addr[1], ipTransportInterface.addr[2], ipTransportInterface.addr[3]));
        }
        this.dynamic_interfaces = coreDX_TcpTransportConfig.getDynamic_interfaces() != 0;
        this.tx_max_packet_size = coreDX_TcpTransportConfig.getTx_max_packet_size();
        this.debug_flags = (int)coreDX_TcpTransportConfig.getDebug_flags();
    }

    CoreDX_TcpTransportConfig toCore() {
        CoreDX_TcpTransportConfig coreDX_TcpTransportConfig = new CoreDX_TcpTransportConfig();
        coredx.CoreDX_TcpTransport_get_default_config(coreDX_TcpTransportConfig);
        coreDX_TcpTransportConfig.setParticipant_index(this.participant_index);
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_TcpTransportConfig.getInterfaces();
        Enumeration<IpTransportInterface> enumeration = this.interfaces.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            IpTransportInterface ipTransportInterface = enumeration.nextElement();
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = new CoreDX_IpTransportInterface();
            if (ipTransportInterface.kind == IpTransportInterface.Kind.IPV4_ADDRESS) {
                coreDX_IpTransportInterface.setAddr_family(1);
                for (n = 0; n < 4; ++n) {
                    coredx.CoreDX_IpTransportInterface_set_addr_byte(coreDX_IpTransportInterface, n, ipTransportInterface.addr[n]);
                }
                coredx.CoreDX_IpTransportInterfaceSeq_add(coreDX_IpTransportInterfaceSeq, coreDX_IpTransportInterface);
                continue;
            }
            if (ipTransportInterface.kind != IpTransportInterface.Kind.IPV6_ADDRESS) continue;
            coreDX_IpTransportInterface.setAddr_family(2);
            for (n = 0; n < 16; ++n) {
                coredx.CoreDX_IpTransportInterface_set_addr_byte(coreDX_IpTransportInterface, n, ipTransportInterface.addr[n]);
            }
            coredx.CoreDX_IpTransportInterfaceSeq_add(coreDX_IpTransportInterfaceSeq, coreDX_IpTransportInterface);
        }
        coreDX_TcpTransportConfig.setDynamic_interfaces((short)(this.dynamic_interfaces ? 1 : 0));
        coreDX_TcpTransportConfig.setTx_max_packet_size(this.tx_max_packet_size);
        coreDX_TcpTransportConfig.setDebug_flags(this.debug_flags);
        return coreDX_TcpTransportConfig;
    }
}

