/*
 * Decompiled with CFR 0.152.
 */
package com.toc.coredx.DDS;

import com.toc.coredx.DDS.CoreDX_IpTransportInterface;
import com.toc.coredx.DDS.CoreDX_IpTransportInterfaceSeq;
import com.toc.coredx.DDS.CoreDX_UdpTransportConfig;
import com.toc.coredx.DDS.IpTransportInterface;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SWIGTYPE_p_unsigned_char;
import com.toc.coredx.DDS.coredx;
import java.util.Enumeration;
import java.util.Vector;

public class UdpTransportConfig {
    public short participant_index;
    public boolean use_ipv4;
    public boolean use_ipv6;
    public Vector<IpTransportInterface> interfaces;
    public boolean dynamic_interfaces;
    public int rx_init_buffer_size;
    public int rx_max_buffer_size;
    public int tx_max_packet_size;
    public int so_rcvbuf;
    public int so_sndbuf;
    public byte[] multicast_address_v4 = new byte[4];
    public byte[] multicast_address_v6 = new byte[16];
    public byte multicast_ttl;
    public boolean tx_meta_multicast;
    public boolean tx_meta_unicast;
    public boolean rx_meta_multicast;
    public boolean rx_user_multicast;
    public boolean advertise_meta_multicast;
    public boolean advertise_user_multicast;
    public byte[] broadcast_address = new byte[4];
    public boolean do_meta_broadcast;
    public int debug_flags;

    public UdpTransportConfig() {
        this.interfaces = new Vector();
        this.get_default_config();
    }

    public ReturnCode_t get_default_config() {
        CoreDX_UdpTransportConfig coreDX_UdpTransportConfig = this.toCore();
        int n = coredx.CoreDX_UdpTransport_get_default_config(coreDX_UdpTransportConfig);
        this.copyFromCore(coreDX_UdpTransportConfig);
        coredx.CoreDX_UdpTransport_clear_config(coreDX_UdpTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    public ReturnCode_t get_env_config() {
        CoreDX_UdpTransportConfig coreDX_UdpTransportConfig = this.toCore();
        int n = coredx.CoreDX_UdpTransport_get_env_config(coreDX_UdpTransportConfig);
        this.copyFromCore(coreDX_UdpTransportConfig);
        coredx.CoreDX_UdpTransport_clear_config(coreDX_UdpTransportConfig);
        return ReturnCode_t.swigToEnum(n);
    }

    void copyFromCore(CoreDX_UdpTransportConfig coreDX_UdpTransportConfig) {
        int n;
        this.participant_index = coreDX_UdpTransportConfig.getParticipant_index();
        this.use_ipv4 = coreDX_UdpTransportConfig.getUse_ipv4() != 0;
        this.use_ipv6 = coreDX_UdpTransportConfig.getUse_ipv6() != 0;
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_UdpTransportConfig.getInterfaces();
        this.interfaces = new Vector((int)coreDX_IpTransportInterfaceSeq.get_length());
        for (long i = 0L; i < coreDX_IpTransportInterfaceSeq.get_length(); ++i) {
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = coredx.CoreDX_IpTransportInterfaceSeq_get(coreDX_IpTransportInterfaceSeq, i);
            IpTransportInterface ipTransportInterface = new IpTransportInterface(coreDX_IpTransportInterface);
            this.interfaces.add(ipTransportInterface);
            System.out.println("UdpTransportConfig: added interface: " + ipTransportInterface);
            System.out.println(String.format("%d.%d.%d.%d", ipTransportInterface.addr[0], ipTransportInterface.addr[1], ipTransportInterface.addr[2], ipTransportInterface.addr[3]));
        }
        this.dynamic_interfaces = coreDX_UdpTransportConfig.getDynamic_interfaces() != 0;
        this.rx_init_buffer_size = coreDX_UdpTransportConfig.getRx_init_buffer_size();
        this.rx_max_buffer_size = coreDX_UdpTransportConfig.getRx_max_buffer_size();
        this.tx_max_packet_size = coreDX_UdpTransportConfig.getTx_max_packet_size();
        this.so_rcvbuf = coreDX_UdpTransportConfig.getSo_rcvbuf();
        this.so_sndbuf = coreDX_UdpTransportConfig.getSo_sndbuf();
        for (n = 0; n < 4; ++n) {
            this.multicast_address_v4[n] = UdpTransportConfig.get_ip_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getMulticast_address_v4()), n);
        }
        for (n = 0; n < 16; ++n) {
            this.multicast_address_v6[n] = UdpTransportConfig.get_ip_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getMulticast_address_v6()), n);
        }
        this.multicast_ttl = (byte)coreDX_UdpTransportConfig.getMulticast_ttl();
        this.tx_meta_multicast = coreDX_UdpTransportConfig.getTx_meta_multicast() != 0;
        this.tx_meta_unicast = coreDX_UdpTransportConfig.getTx_meta_unicast() != 0;
        this.rx_meta_multicast = coreDX_UdpTransportConfig.getRx_meta_multicast() != 0;
        this.rx_user_multicast = coreDX_UdpTransportConfig.getRx_user_multicast() != 0;
        this.advertise_meta_multicast = coreDX_UdpTransportConfig.getAdvertise_meta_multicast() != 0;
        this.advertise_user_multicast = coreDX_UdpTransportConfig.getAdvertise_user_multicast() != 0;
        for (n = 0; n < 4; ++n) {
            this.broadcast_address[n] = UdpTransportConfig.get_ip_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getBroadcast_address()), n);
        }
        this.do_meta_broadcast = coreDX_UdpTransportConfig.getDo_meta_broadcast() != 0;
        this.debug_flags = (int)coreDX_UdpTransportConfig.getDebug_flags();
    }

    CoreDX_UdpTransportConfig toCore() {
        CoreDX_UdpTransportConfig coreDX_UdpTransportConfig = new CoreDX_UdpTransportConfig();
        coredx.CoreDX_UdpTransport_get_default_config(coreDX_UdpTransportConfig);
        CoreDX_IpTransportInterfaceSeq coreDX_IpTransportInterfaceSeq = coreDX_UdpTransportConfig.getInterfaces();
        coreDX_UdpTransportConfig.setParticipant_index(this.participant_index);
        coreDX_UdpTransportConfig.setUse_ipv4((short)(this.use_ipv4 ? 1 : 0));
        coreDX_UdpTransportConfig.setUse_ipv6((short)(this.use_ipv6 ? 1 : 0));
        Enumeration<IpTransportInterface> enumeration = this.interfaces.elements();
        while (enumeration.hasMoreElements()) {
            IpTransportInterface ipTransportInterface = enumeration.nextElement();
            CoreDX_IpTransportInterface coreDX_IpTransportInterface = ipTransportInterface.toCore();
            if (coreDX_IpTransportInterface == null) continue;
            coredx.CoreDX_IpTransportInterfaceSeq_add(coreDX_IpTransportInterfaceSeq, coreDX_IpTransportInterface);
        }
        coreDX_UdpTransportConfig.setDynamic_interfaces((short)(this.dynamic_interfaces ? 1 : 0));
        coreDX_UdpTransportConfig.setRx_init_buffer_size(this.rx_init_buffer_size);
        coreDX_UdpTransportConfig.setRx_max_buffer_size(this.rx_max_buffer_size);
        coreDX_UdpTransportConfig.setTx_max_packet_size(this.tx_max_packet_size);
        coreDX_UdpTransportConfig.setSo_rcvbuf(this.so_rcvbuf);
        coreDX_UdpTransportConfig.setSo_sndbuf(this.so_sndbuf);
        UdpTransportConfig.set_ipv4_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getMulticast_address_v4()), this.multicast_address_v4[0], this.multicast_address_v4[1], this.multicast_address_v4[2], this.multicast_address_v4[3]);
        UdpTransportConfig.set_ipv6_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getMulticast_address_v6()), this.multicast_address_v6[0], this.multicast_address_v6[1], this.multicast_address_v6[2], this.multicast_address_v6[3], this.multicast_address_v6[4], this.multicast_address_v6[5], this.multicast_address_v6[6], this.multicast_address_v6[7], this.multicast_address_v6[8], this.multicast_address_v6[9], this.multicast_address_v6[10], this.multicast_address_v6[11], this.multicast_address_v6[12], this.multicast_address_v6[13], this.multicast_address_v6[14], this.multicast_address_v6[15]);
        coreDX_UdpTransportConfig.setMulticast_ttl(this.multicast_ttl);
        coreDX_UdpTransportConfig.setTx_meta_multicast((short)(this.tx_meta_multicast ? 1 : 0));
        coreDX_UdpTransportConfig.setTx_meta_unicast((short)(this.tx_meta_unicast ? 1 : 0));
        coreDX_UdpTransportConfig.setRx_meta_multicast((short)(this.rx_meta_multicast ? 1 : 0));
        coreDX_UdpTransportConfig.setRx_user_multicast((short)(this.rx_user_multicast ? 1 : 0));
        coreDX_UdpTransportConfig.setAdvertise_meta_multicast((short)(this.advertise_meta_multicast ? 1 : 0));
        coreDX_UdpTransportConfig.setAdvertise_user_multicast((short)(this.advertise_user_multicast ? 1 : 0));
        UdpTransportConfig.set_ipv4_addr(SWIGTYPE_p_unsigned_char.getCPtr(coreDX_UdpTransportConfig.getBroadcast_address()), this.broadcast_address[0], this.broadcast_address[1], this.broadcast_address[2], this.broadcast_address[3]);
        coreDX_UdpTransportConfig.setDo_meta_broadcast((short)(this.do_meta_broadcast ? 1 : 0));
        coreDX_UdpTransportConfig.setDebug_flags(this.debug_flags);
        return coreDX_UdpTransportConfig;
    }

    private static final native byte get_ip_addr(long var0, long var2);

    private static final native void set_ipv4_addr(long var0, byte var2, byte var3, byte var4, byte var5);

    private static final native void set_ipv6_addr(long var0, byte var2, byte var3, byte var4, byte var5, byte var6, byte var7, byte var8, byte var9, byte var10, byte var11, byte var12, byte var13, byte var14, byte var15, byte var16, byte var17);

    static {
        System.loadLibrary("dds_java");
    }
}

