/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.MessageCode;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import topics.AdaptationResponseTopic;

public class AdaptationResponseWrapper
implements ApplicationObject {
    private int adaptationId;
    private UUID nodeId;
    private UUID gatewayId;
    private byte[] message;
    private MessageCode messageCode;

    public AdaptationResponseWrapper() {
    }

    public AdaptationResponseWrapper(int adaptationId, UUID nodeId, UUID gatewayId, byte messageCode, byte[] message) {
        this.adaptationId = adaptationId;
        this.gatewayId = gatewayId;
        this.message = message;
        this.nodeId = nodeId;
        this.messageCode = MessageCode.values()[messageCode];
    }

    public AdaptationResponseWrapper(AdaptationResponseTopic adaptationResponseTopic) {
        this.adaptationId = adaptationResponseTopic.adaptationId;
        this.gatewayId = new UUID(adaptationResponseTopic.mostSignificantBitsGatewayId, adaptationResponseTopic.leastSignificantBitsGatewayId);
        this.messageCode = MessageCode.values()[adaptationResponseTopic.messageCode];
        this.message = adaptationResponseTopic.message;
        this.nodeId = new UUID(adaptationResponseTopic.mostSignificantBitsNodeId, adaptationResponseTopic.leastSignificantBitsNodeId);
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.message == null) {
            this.message = new byte[0];
        }
        switch (ddsVendor) {
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return AdaptationResponseTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    AdaptationResponseTopic getOpenSpliceTopic() {
        AdaptationResponseTopic adaptationResponseTopic = new AdaptationResponseTopic();
        adaptationResponseTopic.adaptationId = this.adaptationId;
        adaptationResponseTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        adaptationResponseTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        adaptationResponseTopic.leastSignificantBitsNodeId = this.nodeId.getLeastSignificantBits();
        adaptationResponseTopic.mostSignificantBitsNodeId = this.nodeId.getMostSignificantBits();
        adaptationResponseTopic.message = this.message;
        adaptationResponseTopic.messageCode = (byte)this.messageCode.ordinal();
        return adaptationResponseTopic;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public MessageCode getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(MessageCode messageCode) {
        this.messageCode = messageCode;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public int getAdaptationId() {
        return this.adaptationId;
    }

    public void setAdaptationId(int adaptationId) {
        this.adaptationId = adaptationId;
    }
}

