/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.AdaptationAction;
import data.CommandCode;
import java.io.File;
import java.util.jar.Attributes;
import utils.Utils;

public class CommandMessage
extends AdaptationAction {
    public CommandCode commandCode;
    public String componentName;
    public String componentClass;
    public String jarPathname;
    public byte[] jarBytes;

    public CommandMessage(CommandMessage commandMessage) throws Exception {
        this(commandMessage.componentName, commandMessage.componentClass, commandMessage.commandCode, commandMessage.jarPathname);
        if (this.jarPathname != null && this.jarBytes == null) {
            this.loadJarMetadata(this.jarPathname);
        }
    }

    public CommandMessage(String componentName, CommandCode commandCode) {
        this.commandCode = commandCode;
        this.componentName = componentName;
    }

    public CommandMessage(String componentName, String componentClass, CommandCode commandCode) {
        this(componentName, commandCode);
        this.componentClass = componentClass;
    }

    public CommandMessage(String componentName, String componentClass, CommandCode commandCode, String jarPathname) {
        this(componentName, componentClass, commandCode);
        this.jarPathname = jarPathname;
    }

    public CommandMessage(String jarPathname) throws Exception {
        this.jarPathname = jarPathname;
        this.commandCode = CommandCode.InsertComponent;
        this.loadJarMetadata(jarPathname);
    }

    public CommandMessage(CommandCode commandCode, String jarPathname) throws Exception {
        this(jarPathname);
        this.commandCode = commandCode;
    }

    public void loadJarMetadata(String jarPathname) throws Exception {
        if (this.jarBytes != null) {
            return;
        }
        File file = new File(jarPathname);
        this.jarBytes = Utils.getBytesFromFile(file);
        Attributes attribute = Utils.getManifest(file);
        this.componentName = attribute.getValue("Component-Name");
        this.componentClass = attribute.getValue("Component-Class");
        if (this.componentClass == null || this.componentName == null) {
            throw new Exception("Manifest malformed!");
        }
    }

    public CommandMessage copy(CommandCode commandCode) {
        return new CommandMessage(this.componentName, this.componentClass, commandCode, this.jarPathname);
    }
}

