/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.chat;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionServer;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;

public class SimpleServer
implements NodeConnectionServerListener,
NodeConnectionListener {
    public MrUdpNodeConnectionServer server;
    private static final int port = 5500;
    private static final Logger LOGGER = Logger.getLogger(SimpleServer.class.getCanonicalName());

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.ALL);
        new SimpleServer(5500);
    }

    public SimpleServer(int port) {
        try {
            this.server = new MrUdpNodeConnectionServer(port);
            this.server.addListener(this);
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void newNodeConnection(NodeConnection remoteCon) {
        LOGGER.fine("Node \t" + remoteCon.getUuid() + "\t connected.");
        remoteCon.addNodeConnectionListener(this);
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        LOGGER.finest("Received Message \n\t" + remoteCon.getUuid() + "\n\t" + message);
        ApplicationMessage msg = (ApplicationMessage)message;
        String content = (String)((Object)msg.getContentObject());
        content = new StringBuffer(content.toUpperCase()).reverse().toString();
        System.out.println("MANDANDO A SEGUINTE MSG: " + content);
        msg.setContentObject((Serializable)((Object)content));
        msg.setSenderID(remoteCon.getUuid());
        try {
            remoteCon.sendMessage(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        LOGGER.fine("We connected");
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("CONNECTED");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("DISCONNECTED FROM " + remoteCon.getUuid());
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("UNSENT MESSAGES " + remoteCon.getUuid());
        for (Message m : unsentMessages) {
            System.out.println(m);
        }
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }
}

