/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.group;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.groups.Group;
import lac.cnclib.net.groups.GroupCommunicationManager;
import lac.cnclib.net.groups.GroupMembershipListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.message.Message;

public class GroupReceiver
implements NodeConnectionListener,
GroupMembershipListener {
    private static InetSocketAddress address;
    private static int numReceivers;
    private static int enterGroupCount;
    private static Object monitor;
    private GroupCommunicationManager groupManager;
    private Group aGroup;
    private long initialTime;
    private int msgReceivedCount;
    private int id;
    private static int connCount;

    static {
        enterGroupCount = 1;
        monitor = new Object();
        connCount = 1;
    }

    public GroupReceiver(int id) {
        try {
            this.id = id;
            this.msgReceivedCount = 0;
            this.aGroup = new Group(250, 300);
            MrUdpNodeConnection connection = new MrUdpNodeConnection();
            connection.addNodeConnectionListener(this);
            connection.connect(address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Call: java -jar stresstest.jar <ip> <port> <number of senders>");
        } else {
            address = new InetSocketAddress(args[0], Integer.parseInt(args[1]));
            numReceivers = Integer.parseInt(args[2]);
        }
        ReceiverLauncher rlauncher = new ReceiverLauncher();
        try {
            rlauncher.launch();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        ReceiverLauncher receiverLauncher = rlauncher;
        synchronized (receiverLauncher) {
            try {
                Thread.sleep(3000L);
                rlauncher.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(NodeConnection remoteCon) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        InetSocketAddress inetSocketAddress = address;
        synchronized (inetSocketAddress) {
            System.out.println(String.valueOf(this.id) + " -- " + connCount++ + "CONNECTED");
        }
        this.groupManager = new GroupCommunicationManager(remoteCon);
        this.groupManager.addMembershipListener(this);
        try {
            this.groupManager.joinGroup(this.aGroup);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        ++this.msgReceivedCount;
        if (System.currentTimeMillis() - this.initialTime > 60000L) {
            double msgPerSecond = this.msgReceivedCount / 60;
            System.out.println("MSG PER SECOND: " + msgPerSecond);
            this.initialTime = System.currentTimeMillis();
            this.msgReceivedCount = 0;
        }
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringGroups(List<Group> groups) {
        System.out.println(String.valueOf(enterGroupCount++) + "Entered in the group");
        this.initialTime = System.currentTimeMillis();
        Object object = monitor;
        synchronized (object) {
            monitor.notify();
        }
    }

    @Override
    public void leavingGroups(List<Group> groups) {
    }

    public static class ReceiverLauncher {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void launch() throws InterruptedException {
            GroupReceiver gs = null;
            int n = 0;
            while (n < numReceivers) {
                gs = new GroupReceiver(n + 1);
                Object object = monitor;
                synchronized (object) {
                    monitor.wait();
                }
                ++n;
            }
            Thread.sleep(10000L);
        }
    }
}

