/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.mrudp;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.extension.ExtendedMessageListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionReliableSocketProfile;
import lac.cnclib.net.mrudp.MrUdpPassiveReader;
import lac.cnclib.sddl.PointsOfAttachment;
import lac.cnclib.sddl.SddlNetworkListener;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.message.ServiceMessage;
import lac.cnclib.sddl.serialization.Serialization;
import net.rudp.ReliableSocket;
import net.rudp.ReliableSocketOutputStream;
import net.rudp.ReliableSocketProfile;
import net.rudp.ReliableSocketStateListener;

public class MrUdpNodeConnection
implements NodeConnection {
    protected UUID uuid;
    protected UUID senderUUID;
    private SocketAddress gatewayAddress;
    protected ReliableSocket socket;
    protected ReliableSocketProfile customSocketProfile;
    protected BlockingQueue<SentObject> sentObjects;
    protected Object sendLock;
    private MyReliableSocketStateListener listener;
    private MrUdpPassiveReader passiveReader;
    protected List<NodeConnectionListener> externalListeners;
    protected Map<ClientLibProtocol.MSGType, List<ExtendedMessageListener>> advancedListeners;
    protected List<SddlNetworkListener> sddlListeners;
    private int nReconnections;
    protected boolean inHandover;
    protected int lastSqn;
    protected HandoverTask handoverTask;
    private boolean wasHandover = false;
    private boolean wasMandatoryHandover = false;
    private static int nNodeConnections = 0;
    private static Random random = new Random();
    protected PointsOfAttachment pointsOfAttachment;
    private static final int MAX_NUMBER_OF_RECONNECTIONS = 5;
    protected static ScheduledThreadPoolExecutor taskExecutionThreadPool = new ScheduledThreadPoolExecutor(1);
    private static final Logger LOGGER = Logger.getLogger(MrUdpNodeConnection.class.getName());

    public MrUdpNodeConnection() throws IOException {
        this(new MrUdpNodeConnectionReliableSocketProfile(), UUID.randomUUID());
    }

    public MrUdpNodeConnection(UUID senderUUID) throws IOException {
        this(new MrUdpNodeConnectionReliableSocketProfile(), senderUUID);
    }

    public MrUdpNodeConnection(ReliableSocketProfile socketProfile) throws IOException {
        this(socketProfile, UUID.randomUUID());
    }

    public MrUdpNodeConnection(ReliableSocketProfile socketProfile, UUID uuid) throws IOException {
        this(new ReliableSocket(socketProfile), socketProfile, uuid);
    }

    public MrUdpNodeConnection(ReliableSocket socket, ReliableSocketProfile socketProfile) throws IOException {
        this(socket, socketProfile, UUID.randomUUID());
    }

    public MrUdpNodeConnection(ReliableSocket socket, ReliableSocketProfile socketProfile, UUID senderUUID) throws IOException {
        this.socket = socket;
        this.inHandover = false;
        this.nReconnections = -1;
        this.uuid = UUID.randomUUID();
        this.senderUUID = senderUUID;
        this.sendLock = new Object();
        this.customSocketProfile = socketProfile;
        this.sentObjects = new LinkedBlockingQueue<SentObject>();
        this.sddlListeners = new ArrayList<SddlNetworkListener>();
        this.externalListeners = new ArrayList<NodeConnectionListener>();
        this.advancedListeners = new HashMap<ClientLibProtocol.MSGType, List<ExtendedMessageListener>>();
        ClientLibProtocol.MSGType[] mSGTypeArray = ClientLibProtocol.MSGType.values();
        int n = mSGTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientLibProtocol.MSGType protocolOperation = mSGTypeArray[n2];
            this.advancedListeners.put(protocolOperation, new ArrayList());
            ++n2;
        }
        int poolSize = (++nNodeConnections / 1000 + 1) * 2;
        taskExecutionThreadPool.setCorePoolSize(poolSize);
        if (this.listener == null) {
            this.listener = new MyReliableSocketStateListener();
        }
        if (this.passiveReader == null) {
            this.passiveReader = new MrUdpPassiveReader(this, socketProfile);
        }
        if (socket.isConnected()) {
            socket.addStateListener(this.listener);
            socket.addListener(this.passiveReader);
        }
    }

    public UUID getClientUUID() {
        return this.senderUUID;
    }

    public void setUuid(UUID uuid) {
        this.socket.setUUID(uuid);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public synchronized void connect(SocketAddress endpoint) throws IOException {
        this.gatewayAddress = endpoint;
        if (this.socket.wasPreviouslyConnected()) {
            this.socket = new ReliableSocket(this.customSocketProfile);
        }
        this.socket.addStateListener(this.listener);
        this.socket.addListener(this.passiveReader);
        this.socket.setUUID(this.uuid);
        this.socket.connect(this.gatewayAddress, this.customSocketProfile.nullSegmentTimeout());
    }

    protected void startHandover(boolean mustSwitch, boolean mandatory) {
        boolean didHandover = false;
        LOGGER.finest("[" + this.uuid + "] start handover: " + mustSwitch + "/" + mandatory + " ");
        didHandover = this.updatePointOfAttachment(mustSwitch, mandatory);
        if (didHandover) {
            this.inHandover = true;
            for (SddlNetworkListener lis : this.sddlListeners) {
                lis.startingHandover(this, this.gatewayAddress, mandatory);
            }
        }
        this.wasHandover = didHandover;
        this.wasMandatoryHandover = mandatory;
        if (didHandover || !this.socket.isConnected()) {
            LOGGER.finest("[" + this.uuid + "] create handover task");
            this.handoverTask = new HandoverTask(didHandover, mandatory);
            taskExecutionThreadPool.schedule(this.handoverTask, (long)(1000 + random.nextInt(7000)), TimeUnit.MILLISECONDS);
        } else {
            LOGGER.fine("[" + this.uuid + "] no need to handover");
        }
    }

    @Override
    public synchronized void disconnect() throws IOException {
        LOGGER.info("Node " + this.getUuid() + " about to be disconnected");
        if (!this.socket.isConnected()) {
            throw new IllegalStateException("Socket not connected.");
        }
        this.socket.close();
    }

    @Override
    public int getNumberOfReconnectionsMade() {
        return this.nReconnections;
    }

    protected boolean updatePointOfAttachment(boolean mustSwitch, boolean mandatoryHandover) {
        LOGGER.finest("[" + this.uuid + "] updating PoA?");
        if (this.pointsOfAttachment == null || this.pointsOfAttachment.getGatewayList().length <= 0) {
            LOGGER.warning("[" + this.uuid + "] PoAList nao existe");
            return false;
        }
        boolean poaChoosed = false;
        int poaIndex = 0;
        String newAddress = "";
        while (!poaChoosed) {
            poaIndex = mandatoryHandover ? 0 : random.nextInt(this.pointsOfAttachment.getGatewayList().length);
            newAddress = this.pointsOfAttachment.getGatewayList()[poaIndex];
            if (newAddress.equals(this.gatewayAddress.toString().substring(1))) continue;
            poaChoosed = true;
        }
        String[] addressParts = newAddress.split(":");
        this.gatewayAddress = new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1]));
        return true;
    }

    @Override
    public void sendMessage(Message message) throws IOException {
        LOGGER.fine("[" + this.uuid + "] send message");
        this.sendObject(message);
        LOGGER.fine("[" + this.uuid + "] message queued");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendObject(Serializable message) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            String className = ClientLibProtocol.ClientLibMessage.class.getCanonicalName().toString();
            this.sendObject(message, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendObject(Serializable obj, String className) throws IOException {
        if (!this.socket.isConnected() || this.inHandover) {
            LOGGER.warning("Can't send message now. Socket is closed or in handover");
            throw new IOException("Can't send message now. Socket is closed or in handover");
        }
        int seqn = -1;
        LOGGER.finest("[" + this.uuid + "] send message - preparing");
        ApplicationMessage appMsg = (ApplicationMessage)obj;
        if (appMsg.getSenderID() == null) {
            appMsg.setSenderID(this.senderUUID);
        }
        byte[] serializedObject = Serialization.toProtocolMessage(appMsg);
        String header = String.valueOf(className.getBytes().length) + "|" + serializedObject.length + "|";
        ReliableSocket reliableSocket = this.socket;
        synchronized (reliableSocket) {
            ReliableSocketOutputStream output;
            block9: {
                output = null;
                try {
                    output = (ReliableSocketOutputStream)this.socket.getOutputStream();
                    LOGGER.finest("[" + this.uuid + "] send message - write to outputstream");
                    output.write(header.getBytes());
                    output.write(className.getBytes());
                    output.write(serializedObject);
                }
                catch (IOException ex) {
                    if (this.gatewayAddress != null) break block9;
                    this.sentObjects.offer(new SentObject(obj, this.lastSqn++));
                    return;
                }
            }
            LOGGER.finest(header.getBytes().toString());
            LOGGER.finest(className.getBytes().toString());
            LOGGER.finest(serializedObject.toString());
            LOGGER.finest("[" + this.uuid + "] send message - flush");
            this.lastSqn = seqn = output.flushAndGetSeq();
            LOGGER.finest("[" + this.uuid + "] send message - flushed");
            if (this.inHandover) {
                LOGGER.warning("[" + this.uuid + "] in handover");
            }
            if (!(obj instanceof ServiceMessage)) {
                LOGGER.finest("[" + this.uuid + "] send message - offer to list");
                this.sentObjects.offer(new SentObject(obj, seqn));
                LOGGER.finest("[" + this.uuid + "] send message - offerered");
            }
        }
    }

    @Override
    public void addNodeConnectionListener(NodeConnectionListener lis) {
        this.externalListeners.add(lis);
    }

    @Override
    public void removeNodeConnectionListener(NodeConnectionListener lis) {
        this.externalListeners.remove(lis);
    }

    @Override
    public void addExtendedMessageListener(ExtendedMessageListener lis, ClientLibProtocol.MSGType messageType) {
        this.advancedListeners.get(messageType).add(lis);
    }

    @Override
    public void removeExtendedMessageListener(ExtendedMessageListener lis, ClientLibProtocol.MSGType messageType) {
        this.advancedListeners.get(messageType).remove(lis);
    }

    @Override
    public void addSddlListener(SddlNetworkListener lis) {
        this.sddlListeners.add(lis);
    }

    @Override
    public void removeSddlListener(SddlNetworkListener lis) {
        this.sddlListeners.remove(lis);
    }

    private void notifyUnsentMessages() {
        ArrayList<Message> unsent = new ArrayList<Message>();
        SentObject unsentObject = null;
        while ((unsentObject = (SentObject)this.sentObjects.poll()) != null) {
            if (!(unsentObject.sentObject instanceof ApplicationMessage)) continue;
            unsent.add((Message)unsentObject.sentObject);
        }
        for (NodeConnectionListener listener : this.externalListeners) {
            listener.unsentMessages(this, unsent);
        }
    }

    private void resetSentToUnsent() {
        Stack<Serializable> sentMessages = new Stack<Serializable>();
        ArrayList<SentObject> sentList = new ArrayList<SentObject>(this.sentObjects);
        Collections.sort(sentList);
        for (SentObject s : sentList) {
            sentMessages.push(s.sentObject);
        }
        this.sentObjects.clear();
    }

    static /* synthetic */ MyReliableSocketStateListener access$12(MrUdpNodeConnection mrUdpNodeConnection) {
        return mrUdpNodeConnection.listener;
    }

    class HandoverTask
    implements Runnable {
        private final boolean isHandover;
        private final boolean mandatoryHandover;
        private int step;

        public HandoverTask(boolean isHandover, boolean mandatoryHandover) {
            this.isHandover = isHandover;
            this.mandatoryHandover = mandatoryHandover;
            this.step = MrUdpNodeConnection.this.socket.isConnected() ? 0 : 1;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block9: {
                try {
                    switch (this.step) {
                        case 0: {
                            this.step = 1;
                            MrUdpNodeConnection.this.disconnect();
                            break;
                        }
                        case 1: {
                            MrUdpNodeConnection.access$0().finest("[" + MrUdpNodeConnection.this.uuid + "] handover connect - " + " at " + MrUdpNodeConnection.access$10(MrUdpNodeConnection.this));
                            MrUdpNodeConnection.this.socket.removeListener(MrUdpNodeConnection.access$1(MrUdpNodeConnection.this));
                            MrUdpNodeConnection.this.socket.removeStateListener(MrUdpNodeConnection.access$12(MrUdpNodeConnection.this));
                            MrUdpNodeConnection.this.socket = new ReliableSocket(MrUdpNodeConnection.this.customSocketProfile != null ? MrUdpNodeConnection.this.customSocketProfile : new MrUdpNodeConnectionReliableSocketProfile());
                            try {
                                this.step = 2;
                                MrUdpNodeConnection.access$0().finest("[" + MrUdpNodeConnection.this.uuid + "] handover connecting - at " + MrUdpNodeConnection.access$10(MrUdpNodeConnection.this));
                                MrUdpNodeConnection.this.connect(MrUdpNodeConnection.access$10(MrUdpNodeConnection.this));
                                MrUdpNodeConnection.access$0().finest("handover waiting connection - " + MrUdpNodeConnection.this.uuid + " at " + MrUdpNodeConnection.access$10(MrUdpNodeConnection.this));
                                break;
                            }
                            catch (IOException e) {
                                MrUdpNodeConnection.access$0().severe("[" + MrUdpNodeConnection.this.uuid + "] handover cant connect - at " + MrUdpNodeConnection.access$10(MrUdpNodeConnection.this));
                            }
                        }
                    }
                    break block9;
                }
                catch (IOException e) {
                    MrUdpNodeConnection.access$0().severe("[" + MrUdpNodeConnection.this.uuid + "] handover error - at " + MrUdpNodeConnection.access$10(MrUdpNodeConnection.this) + " : " + e.getMessage());
                    e.printStackTrace();
                    ** for (lis : MrUdpNodeConnection.this.externalListeners)
                }
lbl-1000:
                // 1 sources

                {
                    lis.internalException(MrUdpNodeConnection.this, e);
                    continue;
                }
            }
        }
    }

    private class MyReliableSocketStateListener
    implements ReliableSocketStateListener {
        private boolean reconnecting = false;
        private int reconnectionAttemps = 0;

        private MyReliableSocketStateListener() {
        }

        @Override
        public void connectionOpened(ReliableSocket sock) {
            LOGGER.fine("[" + MrUdpNodeConnection.this.uuid + "] connection opened ");
            MrUdpNodeConnection.this.passiveReader.reset();
            MrUdpNodeConnection mrUdpNodeConnection = MrUdpNodeConnection.this;
            mrUdpNodeConnection.nReconnections = mrUdpNodeConnection.nReconnections + 1;
            this.reconnectionAttemps = 0;
            this.reconnecting = false;
            MrUdpNodeConnection.this.inHandover = false;
            MrUdpNodeConnection.this.handoverTask = null;
            if (MrUdpNodeConnection.this.nReconnections > 0) {
                SentObject unsentObject;
                while ((unsentObject = (SentObject)MrUdpNodeConnection.this.sentObjects.poll()) != null) {
                    if (!(unsentObject.sentObject instanceof ApplicationMessage)) continue;
                    try {
                        MrUdpNodeConnection.this.sendObject((Message)unsentObject.sentObject);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            for (NodeConnectionListener lis : MrUdpNodeConnection.this.externalListeners.subList(0, MrUdpNodeConnection.this.externalListeners.size())) {
                if (MrUdpNodeConnection.this.nReconnections <= 0) {
                    lis.connected(MrUdpNodeConnection.this);
                    continue;
                }
                lis.reconnected(MrUdpNodeConnection.this, MrUdpNodeConnection.this.getSocket().getRemoteSocketAddress(), MrUdpNodeConnection.this.wasHandover, MrUdpNodeConnection.this.wasMandatoryHandover);
            }
            MrUdpNodeConnection.this.wasHandover = false;
            MrUdpNodeConnection.this.wasMandatoryHandover = false;
        }

        @Override
        public void connectionRefused(ReliableSocket sock) {
            LOGGER.warning("[" + MrUdpNodeConnection.this.uuid + "] connection refused ");
            if ((MrUdpNodeConnection.this.inHandover || this.reconnecting) && this.reconnectionAttemps < 5) {
                ++this.reconnectionAttemps;
                this.reconnecting = true;
                LOGGER.finest("[" + MrUdpNodeConnection.this.uuid + "] connection refused - start new handover ");
                MrUdpNodeConnection.this.startHandover(true, false);
            } else {
                LOGGER.severe("[" + MrUdpNodeConnection.this.uuid + "] connection refused - give up ");
                MrUdpNodeConnection.this.notifyUnsentMessages();
                for (NodeConnectionListener lis : MrUdpNodeConnection.this.externalListeners) {
                    lis.disconnected(MrUdpNodeConnection.this);
                }
            }
        }

        @Override
        public void connectionClosed(ReliableSocket sock) {
            LOGGER.finest("[" + MrUdpNodeConnection.this.uuid + "] connection closed to " + MrUdpNodeConnection.this.gatewayAddress);
            MrUdpNodeConnection.this.resetSentToUnsent();
            if (MrUdpNodeConnection.this.inHandover) {
                LOGGER.finest("[" + MrUdpNodeConnection.this.uuid + "] handover connect again ");
                taskExecutionThreadPool.schedule(MrUdpNodeConnection.this.handoverTask, 1000L, TimeUnit.MILLISECONDS);
                return;
            }
            LOGGER.finest("[" + MrUdpNodeConnection.this.uuid + "] closed connect again ");
            MrUdpNodeConnection.this.wasHandover = false;
            MrUdpNodeConnection.this.wasMandatoryHandover = false;
            int state = sock.getState();
            if (MrUdpNodeConnection.this.gatewayAddress == null || this.reconnectionAttemps >= 5 || state == 4 || state == 0) {
                MrUdpNodeConnection.this.notifyUnsentMessages();
                for (NodeConnectionListener lis : MrUdpNodeConnection.this.externalListeners) {
                    lis.disconnected(MrUdpNodeConnection.this);
                }
            } else {
                this.reconnecting = true;
                ++this.reconnectionAttemps;
                LOGGER.finest("[" + MrUdpNodeConnection.this.uuid + "] closed call start handover");
                MrUdpNodeConnection.this.startHandover(false, false);
            }
        }

        @Override
        public void connectionFailure(ReliableSocket sock) {
        }

        @Override
        public void connectionReset(ReliableSocket sock) {
        }
    }

    class SentObject
    implements Comparable<SentObject> {
        public Serializable sentObject;
        public int sequenceNumber;

        public SentObject(Serializable obj, int seqN) {
            this.sentObject = obj;
            this.sequenceNumber = seqN;
        }

        @Override
        public int compareTo(SentObject other) {
            if (this.sequenceNumber < other.sequenceNumber) {
                return -1;
            }
            if (this.sequenceNumber > other.sequenceNumber) {
                return 1;
            }
            return 0;
        }
    }
}

