/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.mrudp;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.extension.ExtendedMessageListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.Ping;
import lac.cnclib.sddl.PointsOfAttachment;
import lac.cnclib.sddl.SddlNetworkListener;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.serialization.Serialization;
import net.rudp.ReliableSocketListener;
import net.rudp.ReliableSocketProfile;

class MrUdpPassiveReader
implements ReliableSocketListener {
    private final MrUdpNodeConnection mrUdpNodeConnection;
    private volatile byte[] mainBuffer;
    private volatile byte[] objectBuffer;
    private int bufferIndex = 0;
    private int objectBufferIndex = 0;
    private int classNameSize = -1;
    private int objectSize = -1;
    private String className = null;
    private int lastAck;
    private static final Logger LOGGER = Logger.getLogger(MrUdpPassiveReader.class.getName());

    MrUdpPassiveReader(MrUdpNodeConnection mrUdpNodeConnection, ReliableSocketProfile profile) {
        this.mrUdpNodeConnection = mrUdpNodeConnection;
        this.mainBuffer = new byte[profile.maxSegmentSize() * profile.maxRecvQueueSize() / 2];
    }

    public synchronized void reset() {
        this.objectSize = -1;
        this.classNameSize = -1;
        this.className = null;
        this.objectBuffer = null;
        this.objectBufferIndex = -1;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void processBuffer() {
        do {
            block9: {
                if (this.classNameSize < 0 || this.objectSize < 0) {
                    terminatorPos = this.getCharPos('|');
                    if (terminatorPos < 0) continue;
                    size = Integer.parseInt(new String(this.mainBuffer, 0, terminatorPos));
                    if (this.classNameSize < 0) {
                        this.classNameSize = size;
                    } else {
                        this.objectSize = size;
                    }
                    System.arraycopy(this.mainBuffer, terminatorPos + 1, this.mainBuffer, 0, this.bufferIndex - (terminatorPos + 1));
                    this.bufferIndex -= terminatorPos + 1;
                    if (this.bufferIndex <= 0) continue;
                    continue;
                }
                availableBytes = this.bufferIndex;
                if (this.className == null) {
                    if (this.classNameSize > availableBytes) continue;
                    this.className = new String(this.mainBuffer, 0, this.classNameSize);
                    System.arraycopy(this.mainBuffer, this.classNameSize, this.mainBuffer, 0, this.bufferIndex - this.classNameSize);
                    this.bufferIndex -= this.classNameSize;
                    if (this.bufferIndex <= 0) continue;
                    continue;
                }
                if (this.objectBuffer == null) {
                    this.objectBuffer = new byte[this.objectSize];
                    this.objectBufferIndex = 0;
                }
                copiedSize = Math.min(availableBytes, this.objectSize - this.objectBufferIndex);
                System.arraycopy(this.mainBuffer, 0, this.objectBuffer, this.objectBufferIndex, copiedSize);
                this.objectBufferIndex += copiedSize;
                System.arraycopy(this.mainBuffer, copiedSize, this.mainBuffer, 0, this.bufferIndex - copiedSize);
                this.bufferIndex -= copiedSize;
                availableBytes -= copiedSize;
                if (this.objectBufferIndex != this.objectSize) continue;
                try {
                    obj = Serialization.fromProtocolMessage(this.objectBuffer);
                    this.processObject(obj);
                    break block9;
                }
                catch (IOException e) {
                    ** for (lis : this.mrUdpNodeConnection.externalListeners)
                }
lbl-1000:
                // 1 sources

                {
                    lis.internalException(this.mrUdpNodeConnection, e);
                    continue;
                }
            }
            this.reset();
            if (this.bufferIndex <= 0) continue;
        } while (this.bufferIndex > 0);
    }

    private void processObject(final Object obj) throws IOException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Message msg = (Message)obj;
                switch (msg.getType()) {
                    case APPLICATION: {
                        MrUdpPassiveReader.this.handleApplication(msg);
                        break;
                    }
                    case GROUPMEMBERSHIP: {
                        MrUdpPassiveReader.this.handleExtendedMessage(msg);
                        break;
                    }
                    case GROUPCAST: {
                        MrUdpPassiveReader.this.handleExtendedMessage(msg);
                        break;
                    }
                    case PING: {
                        MrUdpPassiveReader.this.handlePing(msg);
                        break;
                    }
                    case POA: {
                        MrUdpPassiveReader.this.handleHandOver(msg);
                        break;
                    }
                    default: {
                        MrUdpPassiveReader.this.handleApplication(msg);
                    }
                }
            }
        };
        new Thread(r).start();
    }

    private void handleApplication(Message msg) {
        for (NodeConnectionListener lis : this.mrUdpNodeConnection.externalListeners) {
            lis.newMessageReceived(this.mrUdpNodeConnection, msg);
        }
    }

    private void handlePing(Message msg) {
        Ping ping = (Ping)msg.getContentObject();
        if (!ping.isPong()) {
            ping.setPong(true);
            msg.setContentObject(ping);
            try {
                this.mrUdpNodeConnection.sendMessage(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (SddlNetworkListener lis : this.mrUdpNodeConnection.sddlListeners) {
            lis.pingReceived(this.mrUdpNodeConnection, ping);
        }
    }

    public void handleHandOver(Message msg) {
        PointsOfAttachment poaList = (PointsOfAttachment)msg.getContentObject();
        for (SddlNetworkListener lis : this.mrUdpNodeConnection.sddlListeners) {
            lis.newPointOfAttachmentListReceived(this.mrUdpNodeConnection, poaList);
        }
        this.mrUdpNodeConnection.pointsOfAttachment = poaList;
        if (poaList.mustSwitchGateway()) {
            this.mrUdpNodeConnection.startHandover(false, true);
        }
    }

    public void handleExtendedMessage(Message msg) {
        List<ExtendedMessageListener> listenersList = this.mrUdpNodeConnection.advancedListeners.get(msg.getType());
        for (ExtendedMessageListener listener : listenersList) {
            listener.newProtocolMessageReceived(this.mrUdpNodeConnection, msg);
        }
    }

    private int getCharPos(char c) {
        int i = 0;
        while (i < this.bufferIndex) {
            if (c == this.mainBuffer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void packetSent() {
        LOGGER.fine("Packet Sent");
    }

    @Override
    public void packetRetransmitted() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void packetReceivedInOrder() {
        block4: {
            try {
                read = this.mrUdpNodeConnection.socket.getInputStream().read(this.mainBuffer, this.bufferIndex, this.mainBuffer.length - this.bufferIndex);
                if (read < 0) {
                    throw new IOException("Reading error.");
                }
                this.bufferIndex += read;
                this.processBuffer();
                break block4;
            }
            catch (IOException e) {
                MrUdpPassiveReader.LOGGER.severe("error reading - " + this.mrUdpNodeConnection.uuid);
                ** for (lis : this.mrUdpNodeConnection.externalListeners)
            }
lbl-1000:
            // 1 sources

            {
                lis.internalException(this.mrUdpNodeConnection, e);
                continue;
            }
        }
    }

    @Override
    public void packetReceivedOutOfOrder() {
    }

    @Override
    public void ackReceived(int ackNumber) {
        boolean looped = false;
        if (ackNumber < this.lastAck) {
            looped = true;
        }
        this.lastAck = ackNumber;
        MrUdpNodeConnection.SentObject sentObj = null;
        while ((sentObj = (MrUdpNodeConnection.SentObject)this.mrUdpNodeConnection.sentObjects.peek()) != null) {
            if (sentObj.sequenceNumber < 0) break;
            if (looped) {
                if (sentObj.sequenceNumber > ackNumber) {
                    this.mrUdpNodeConnection.sentObjects.poll();
                    continue;
                }
                looped = false;
            }
            if (sentObj.sequenceNumber > ackNumber) break;
            this.mrUdpNodeConnection.sentObjects.poll();
        }
        looped = false;
    }
}

