/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.components;

import data.AdaptationResponseWrapper;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.extension.ExtendedMessageListener;
import lac.cnclib.net.groups.Group;
import lac.cnclib.net.groups.message.GroupMembershipOperation;
import lac.cnclib.net.groups.message.GroupcastMessage;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionServer;
import lac.cnclib.sddl.PointsOfAttachment;
import lac.cnclib.sddl.SddlNetworkListener;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.serialization.Serialization;
import lac.cnet.gateway.components.FastTotalOrder;
import lac.cnet.gateway.components.Plugin;
import lac.cnet.gateway.components.PongThread;
import lac.cnet.gateway.components.listeners.GroupAdvertisementTopicListener;
import lac.cnet.gateway.components.listeners.GroupMessageTopicListener;
import lac.cnet.gateway.components.listeners.LoadReportTopicListener;
import lac.cnet.gateway.components.listeners.PingTopicListener;
import lac.cnet.gateway.components.listeners.PrivateMessageTopicListener;
import lac.cnet.gateway.data.AssociatedNode;
import lac.cnet.gateway.data.LocalLogicalTime;
import lac.cnet.gateway.task.LoadReportObserverTask;
import lac.cnet.gateway.task.SendLoadReportTask;
import lac.cnet.gateway.task.SendMessageTask;
import lac.cnet.gateway.task.SendPingTask;
import lac.cnet.gateway.task.SendToDDSTask;
import lac.cnet.sddl.objects.ConnectionReport;
import lac.cnet.sddl.objects.GroupAdvertisement;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.GroupMessage;
import lac.cnet.sddl.objects.GroupReport;
import lac.cnet.sddl.objects.LoadReport;
import lac.cnet.sddl.objects.Ping;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.objects.UnsentMessage;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.contextnet.highlyscalablemap.HighlyScalableMap;
import lac.contextnet.highlyscalableset.ReadWriteLockSet;

public class Gateway
implements NodeConnectionServerListener,
NodeConnectionListener,
SddlNetworkListener,
ExtendedMessageListener {
    private static final boolean DEBUG = false;
    private final boolean useTotalOrderGroupcast;
    public static final int DEFAULT_PORT = 5500;
    private static final String GATEWAY_FILTER_EXPRESSION = "(mostSignificantBitsGatewayId = %0 and leastSignificantBitsGatewayId = %1) or (mostSignificantBitsGatewayId = %2 and leastSignificantBitsGatewayId = %2)";
    protected SddlLayer dds;
    private final MrUdpNodeConnectionServer connectionServer;
    private final UUID gatewayId;
    private final Map<UUID, AssociatedNode> nodeById;
    private final Map<UUID, AssociatedNode> nodesByConnection;
    private final Map<Group, Set<AssociatedNode>> nodesByGroup;
    private final ScheduledThreadPoolExecutor threadPool;
    private static final int maximumPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private final PongThread pongThread;
    private static final int LOAD_REPORT_OBSERVER_REFRESH_INTERVAL_IN_SECS = 2;
    private static final int SEND_LOAD_REPORT_INTERVAL_IN_SECS = 15;
    private long localLogicalTime;
    private Map<UUID, Long> gatewayLogicalTimeCollection;
    private FastTotalOrder fastTotalOrder;
    private UUID lowerKnownGatewayId;
    public Plugin plugin = null;

    public Gateway(int serverPort, String externalRUDPIp, UUID gatewayId, boolean useTotalOrderGroupcast, UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) throws IOException {
        this.gatewayId = gatewayId;
        this.prepareEntityManager(ddsVendor);
        this.connectionServer = new MrUdpNodeConnectionServer(serverPort);
        this.connectionServer.addListener(this);
        this.connectionServer.start();
        this.nodesByConnection = new HighlyScalableMap<UUID, AssociatedNode>();
        this.nodeById = new HighlyScalableMap<UUID, AssociatedNode>();
        this.nodesByGroup = new HighlyScalableMap<Group, Set<AssociatedNode>>();
        this.threadPool = new ScheduledThreadPoolExecutor(maximumPoolSize);
        this.threadPool.prestartAllCoreThreads();
        this.pongThread = new PongThread(this.dds, this.gatewayId);
        this.pongThread.start();
        LoadReportObserverTask loadObserver = new LoadReportObserverTask(String.valueOf(externalRUDPIp) + ":" + serverPort);
        SendLoadReportTask sendLoadReportTask = new SendLoadReportTask(this, loadObserver);
        this.threadPool.scheduleWithFixedDelay(loadObserver, 2L, 2L, TimeUnit.SECONDS);
        this.threadPool.scheduleWithFixedDelay(sendLoadReportTask, 8L, 15L, TimeUnit.SECONDS);
        this.useTotalOrderGroupcast = useTotalOrderGroupcast;
        if (this.useTotalOrderGroupcast) {
            this.localLogicalTime = 0L;
            this.gatewayLogicalTimeCollection = new LinkedHashMap<UUID, Long>();
            this.lowerKnownGatewayId = new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
            this.fastTotalOrder = new FastTotalOrder(this.gatewayLogicalTimeCollection);
        }
    }

    public Gateway(int serverPort, String externalRUDPIp, UUID gatewayId, UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) throws IOException {
        this(serverPort, externalRUDPIp, gatewayId, false, ddsVendor);
    }

    public Gateway(int serverPort, String externalRUDPIp, UUID gatewayId, UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor, Plugin plugin) throws IOException {
        this(serverPort, externalRUDPIp, gatewayId, false, ddsVendor);
        this.plugin = plugin;
    }

    private void prepareEntityManager(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        this.dds = UniversalDDSLayerFactory.getInstance(ddsVendor);
        this.dds.createParticipant(0L);
        this.dds.createPublisher();
        this.dds.createSubscriber();
        this.prepareMessageTopicDataWriter();
        this.prepareUnsentMessageTopicDataWriter();
        this.prepareLoadReportTopicDataWriter();
        this.preparePingTopicDataWriter();
        this.prepareConnectionReportTopicDataWriter();
        this.preparePrivateMessageTopicDataWriter();
        this.prepareGroupReporTopicDataWriter();
        this.prepareAdaptationResponseTopicDataWriter();
        ArrayList<String> gatewayFilterParameters = new ArrayList<String>(3);
        gatewayFilterParameters.add(Long.toString(this.gatewayId.getMostSignificantBits()));
        gatewayFilterParameters.add(Long.toString(this.gatewayId.getLeastSignificantBits()));
        gatewayFilterParameters.add(Long.toString(-1L));
        this.preparePrivateMessageTopicDataReader(gatewayFilterParameters);
        this.prepareGroupAdvertisementTopicDataReader(gatewayFilterParameters);
        this.preparePingTopicDataReader();
        if (this.useTotalOrderGroupcast) {
            this.prepareGroupMessageTopicDataWriter();
            this.prepareGroupMessageTopicDataReader(gatewayFilterParameters);
            this.prepareLoadReportTopicDataReader(gatewayFilterParameters);
        }
    }

    private void prepareAdaptationResponseTopicDataWriter() {
        Object adaptationResponseTopic = this.dds.createTopic(AdaptationResponseWrapper.class, AdaptationResponseWrapper.class.getSimpleName());
        this.dds.createDataWriter(adaptationResponseTopic);
    }

    private void prepareGroupAdvertisementTopicDataReader(List<String> gatewayFilterParameters) {
        GroupAdvertisementTopicListener groupAdvertisementTopicListener = new GroupAdvertisementTopicListener(this);
        Object groupAdvertisementTopic = this.dds.createTopic(GroupAdvertisement.class, GroupAdvertisement.class.getSimpleName());
        Object groupAdvertisementFilteredTopic = this.dds.createContentFilteredTopic(GroupAdvertisement.class.getSimpleName(), groupAdvertisementTopic, GATEWAY_FILTER_EXPRESSION, gatewayFilterParameters);
        this.dds.createDataReader(groupAdvertisementTopicListener, groupAdvertisementFilteredTopic);
    }

    private void preparePrivateMessageTopicDataReader(List<String> gatewayFilterParameters) {
        PrivateMessageTopicListener privateMessageTopicListener = new PrivateMessageTopicListener(this);
        Object privateMessageTopic = this.dds.createTopic(PrivateMessage.class, PrivateMessage.class.getSimpleName());
        Object privateMessageTopicFiltered = this.dds.createContentFilteredTopic(PrivateMessage.class.getSimpleName(), privateMessageTopic, GATEWAY_FILTER_EXPRESSION, gatewayFilterParameters);
        this.dds.createDataReader(privateMessageTopicListener, privateMessageTopicFiltered);
    }

    private void preparePingTopicDataReader() {
        String filterExpression = "ping = " + this.dds.getBooleanRepresentation(true) + " and " + "( (leastSignificantBitsGatewayId = %0 and mostSignificantBitsGatewayId = %1)" + "or (leastSignificantBitsGatewayId = %2 and mostSignificantBitsGatewayId = %2) )";
        Vector<String> gatewayFilterParameters = new Vector<String>(3);
        gatewayFilterParameters.add(Long.toString(this.gatewayId.getLeastSignificantBits()));
        gatewayFilterParameters.add(Long.toString(this.gatewayId.getMostSignificantBits()));
        gatewayFilterParameters.add(Long.toString(-1L));
        PingTopicListener pingTopicListener = new PingTopicListener(this);
        Object pingTopic = this.dds.createTopic(Ping.class, Ping.class.getSimpleName());
        Object filteredPingTopic = this.dds.createContentFilteredTopic(Ping.class.getSimpleName(), pingTopic, filterExpression, gatewayFilterParameters);
        this.dds.createDataReader(pingTopicListener, filteredPingTopic);
    }

    private void prepareGroupMessageTopicDataReader(List<String> parameters) {
        Object groupMessageTopic = this.dds.createTopic(GroupMessage.class, GroupMessage.class.getSimpleName());
        Object contentFilteredTopic = this.dds.createContentFilteredTopic(GroupMessage.class.getSimpleName(), groupMessageTopic, "mostSignificantBitsGatewayId <> %0 or leastSignificantBitsGatewayId <> %1", parameters);
        GroupMessageTopicListener listener = new GroupMessageTopicListener(this);
        this.dds.createDataReader(listener, contentFilteredTopic);
    }

    private void prepareLoadReportTopicDataReader(List<String> parameters) {
        Object loadReportTopic = this.dds.createTopic(LoadReport.class, LoadReport.class.getSimpleName());
        Object contentFilteredTopic = this.dds.createContentFilteredTopic(LoadReport.class.getSimpleName(), loadReportTopic, "mostSignificantBitsParticipantId <> %0 or leastSignificantBitsParticipantId <> %1", parameters);
        LoadReportTopicListener listener = new LoadReportTopicListener(this);
        this.dds.createDataReader(listener, contentFilteredTopic);
    }

    private void prepareMessageTopicDataWriter() {
        Object messageTopic = this.dds.createTopic(lac.cnet.sddl.objects.Message.class, lac.cnet.sddl.objects.Message.class.getSimpleName());
        this.dds.createDataWriter(messageTopic);
    }

    private void prepareLoadReportTopicDataWriter() {
        Object loadReportTopic = this.dds.createTopic(LoadReport.class, LoadReport.class.getSimpleName());
        this.dds.createDataWriter(loadReportTopic);
    }

    private void prepareGroupReporTopicDataWriter() {
        Object groupReportTopic = this.dds.createTopic(GroupReport.class, GroupReport.class.getSimpleName());
        this.dds.createDataWriter(groupReportTopic);
    }

    private void prepareUnsentMessageTopicDataWriter() {
        Object unsentMessageTopic = this.dds.createTopic(UnsentMessage.class, UnsentMessage.class.getSimpleName());
        this.dds.createDataWriter(unsentMessageTopic);
    }

    private void preparePingTopicDataWriter() {
        Object pingTopic = this.dds.createTopic(Ping.class, Ping.class.getSimpleName());
        this.dds.createDataWriter(pingTopic);
    }

    private void prepareConnectionReportTopicDataWriter() {
        Object connectionReportTopic = this.dds.createTopic(ConnectionReport.class, ConnectionReport.class.getSimpleName());
        this.dds.createDataWriter(connectionReportTopic);
    }

    private void preparePrivateMessageTopicDataWriter() {
        Object privateMessageTopic = this.dds.createTopic(PrivateMessage.class, PrivateMessage.class.getSimpleName());
        this.dds.createDataWriter(privateMessageTopic);
    }

    private void prepareGroupMessageTopicDataWriter() {
        Object groupMessageTopic = this.dds.createTopic(GroupMessage.class, GroupMessage.class.getSimpleName());
        this.dds.createDataWriter(groupMessageTopic);
    }

    @Override
    public void internalException(NodeConnection nodeConnection, Exception exception) {
        System.out.println("Gateway.internalException()");
        exception.printStackTrace();
        this.removeConnection(nodeConnection);
        try {
            nodeConnection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("Gateway.reconnected()");
    }

    @Override
    public void newNodeConnection(NodeConnection nodeCon) {
        nodeCon.addNodeConnectionListener(this);
        nodeCon.addSddlListener(this);
        nodeCon.addExtendedMessageListener(this, ClientLibProtocol.MSGType.GROUPCAST);
        nodeCon.addExtendedMessageListener(this, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
    }

    @Override
    public void connected(NodeConnection remoteCon) {
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        this.removeConnection(remoteCon);
    }

    @Override
    public void newMessageReceived(NodeConnection nodeConnection, Message message) {
        AssociatedNode node = this.nodesByConnection.get(nodeConnection.getUuid());
        if (node == null) {
            node = this.addNewNode(nodeConnection, message.getSenderID());
        }
        if (message.getRecipientID() == null) {
            this.sendMessageTopic(message, node.getGroups());
        } else {
            this.sendPrivateMessage(message);
        }
    }

    private AssociatedNode addNewNode(NodeConnection nodeConnection, UUID nodeId) {
        AssociatedNode node = new AssociatedNode(nodeId, nodeConnection);
        this.nodeById.put(node.getNodeId(), node);
        this.nodesByConnection.put(nodeConnection.getUuid(), node);
        ConnectionReport connectionReport = new ConnectionReport(node.getNodeId(), this.gatewayId, true);
        this.dds.writeTopic(ConnectionReport.class.getSimpleName(), connectionReport);
        return node;
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        if (unsentMessages.size() == 0) {
            return;
        }
        AssociatedNode node = this.nodesByConnection.get(remoteCon.getUuid());
        if (node != null) {
            UnsentMessage unsentMessageTopic = this.constructUnsentMessageTopic(unsentMessages, node);
            this.dds.writeTopic(UnsentMessage.class.getSimpleName(), unsentMessageTopic);
        }
    }

    private UnsentMessage constructUnsentMessageTopic(List<Message> unsentObjects, AssociatedNode node) {
        UnsentMessage unsentMessage = new UnsentMessage();
        unsentMessage.setGatewayId(this.gatewayId);
        unsentMessage.setNodeId(node.getNodeId());
        int i = 0;
        while (i < unsentObjects.size()) {
            Message message = unsentObjects.get(i);
            if (message.getType() != ClientLibProtocol.MSGType.PING && message.getType() != ClientLibProtocol.MSGType.POA) {
                byte[] unsentObject = null;
                unsentObject = Serialization.toProtocolMessage(message);
                unsentMessage.addUnsentMessage(unsentObject);
            }
            ++i;
        }
        return unsentMessage;
    }

    private Collection<GroupCollection> getGroupTopicCollection(Set<Group> nodeGroups) {
        HashMap<Integer, HashSet<Integer>> groupCollection = new HashMap<Integer, HashSet<Integer>>();
        for (Group group : nodeGroups) {
            HashSet<Integer> typedGroupCollection = (HashSet<Integer>)groupCollection.get(group.getGroupType());
            if (typedGroupCollection == null) {
                typedGroupCollection = new HashSet<Integer>();
                typedGroupCollection.add(group.getGroupID());
                groupCollection.put(group.getGroupType(), typedGroupCollection);
                continue;
            }
            typedGroupCollection.add(group.getGroupID());
        }
        ArrayList<GroupCollection> groupColectionArray = new ArrayList<GroupCollection>(groupCollection.size());
        for (Map.Entry group : groupCollection.entrySet()) {
            GroupCollection groupTopic = new GroupCollection();
            groupTopic.setGroupType((Integer)group.getKey());
            Iterator iterator = ((Set)group.getValue()).iterator();
            while (iterator.hasNext()) {
                int groupID = (Integer)iterator.next();
                groupTopic.addGroupId(groupID);
            }
            groupColectionArray.add(groupTopic);
        }
        return groupColectionArray;
    }

    private void sendMessageTopic(Message message, Set<Group> nodeGroups) {
        this.threadPool.execute(new SendToDDSTask(this, message, nodeGroups));
    }

    private void sendPrivateMessageTopic(byte[] message, Group group) throws IOException {
        PrivateMessage privateMessate = new PrivateMessage();
        privateMessate.setGatewayId(UniversalDDSLayerFactory.BROADCAST_ID);
        privateMessate.setNodeId(UniversalDDSLayerFactory.BROADCAST_ID);
        privateMessate.setGroupId(group.getGroupID());
        privateMessate.setGroupType(group.getGroupType());
        privateMessate.setMessage(message);
        boolean ret = this.dds.writeTopic(PrivateMessage.class.getSimpleName(), privateMessate);
    }

    private void sendPrivateMessageTopic(Message message, Group group) throws IOException {
        this.sendPrivateMessageTopic(Serialization.toProtocolMessage(message), group);
    }

    private void sendPrivateMessage(Message message) {
        AssociatedNode node = this.nodeById.get(message.getRecipientID());
        if (node != null) {
            SendMessageTask sendMessageTask = new SendMessageTask(this, node, Serialization.toProtocolMessage(message));
            this.threadPool.execute(sendMessageTask);
        } else {
            if (message.getRecipientGatewayID() == null) {
                UUID broadcastId = UniversalDDSLayerFactory.BROADCAST_ID;
                message.setRecipientGatewayID(broadcastId);
            }
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setGroupId(-1);
            privateMessage.setGroupType(-1);
            privateMessage.setGatewayId(message.getRecipientGatewayID());
            privateMessage.setNodeId(message.getRecipientID());
            privateMessage.setMessage(Serialization.toProtocolMessage(message));
            if (this.plugin != null) {
                privateMessage = this.plugin.processPrivateMessageTopic(privateMessage);
            }
            this.dds.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage);
        }
    }

    public lac.cnet.sddl.objects.Message toMessageTopic(Message nodeMessage, Set<Group> nodeGroups) throws IOException {
        lac.cnet.sddl.objects.Message messageTopic = new lac.cnet.sddl.objects.Message();
        messageTopic.setContent(nodeMessage.getContent());
        messageTopic.setGatewayId(this.gatewayId);
        messageTopic.setSenderId(nodeMessage.getSenderID());
        messageTopic.setGroupCollection(this.getGroupTopicCollection(nodeGroups));
        messageTopic.setStamps(nodeMessage.getTagList());
        return messageTopic;
    }

    private void removeConnection(NodeConnection remoteCon) {
        AssociatedNode node = this.nodesByConnection.remove(remoteCon.getUuid());
        if (node != null) {
            this.nodeById.remove(node.getNodeId());
            this.removeNodeFromAllGroups(node);
            ConnectionReport connectionReport = new ConnectionReport();
            connectionReport.setGatewayId(this.gatewayId);
            connectionReport.setNodeId(node.getNodeId());
            connectionReport.setConnected(false);
            this.dds.writeTopic(ConnectionReport.class.getSimpleName(), connectionReport);
        }
    }

    private void removeNodeFromAllGroups(AssociatedNode node) {
        this.removeNodeFromGroups(node, node.getGroups());
    }

    private void removeNodeFromGroups(AssociatedNode node, Set<Group> toBeRemovedGroupCollection) {
        for (Group group : toBeRemovedGroupCollection) {
            Set<AssociatedNode> nodesInGroup = this.nodesByGroup.get(group);
            if (nodesInGroup == null) continue;
            nodesInGroup.remove(node);
            if (nodesInGroup.size() != 0) continue;
            this.nodesByGroup.remove(group);
        }
    }

    private void addNodeToGroups(AssociatedNode node, Set<Group> groupCollection) {
        for (Group group : groupCollection) {
            Set<AssociatedNode> nodes = this.nodesByGroup.get(group);
            if (nodes == null) {
                nodes = new ReadWriteLockSet<AssociatedNode>();
                nodes.add(node);
                this.nodesByGroup.put(group, nodes);
                continue;
            }
            nodes.add(node);
        }
    }

    public void receiveGroupAdvertisementTopic(GroupAdvertisement groupAdvertisement) {
        AssociatedNode node = null;
        node = this.nodeById.get(groupAdvertisement.getNodeId());
        if (node != null) {
            HashSet<Group> addedGroupCollection = new HashSet<Group>(groupAdvertisement.getGroupOperationCollection().size(), 1.0f);
            HashSet<Group> deletedGroupCollection = new HashSet<Group>(groupAdvertisement.getGroupOperationCollection().size(), 1.0f);
            for (int groupID : groupAdvertisement.getGroupOperationCollection()) {
                Group group = new Group(groupAdvertisement.getGroupType(), Math.abs(groupID));
                if (groupID < 0) {
                    deletedGroupCollection.add(group);
                    continue;
                }
                addedGroupCollection.add(group);
            }
            node.removeAllGroups(deletedGroupCollection);
            node.addAllGroups(addedGroupCollection);
            this.removeNodeFromGroups(node, deletedGroupCollection);
            this.addNodeToGroups(node, addedGroupCollection);
            GroupMembershipOperation groupMembershipStatusData = new GroupMembershipOperation(addedGroupCollection, deletedGroupCollection);
            lac.cnclib.net.groups.message.GroupMessage groupMessage = new lac.cnclib.net.groups.message.GroupMessage();
            groupMessage.setMsgType(ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
            groupMessage.setContentObject(groupMembershipStatusData);
            groupMessage.setSenderID(this.gatewayId);
            groupMessage.setRecipientID(node.getNodeId());
            groupMessage.setTagList(new ArrayList<String>());
            groupMessage.addTag("_groupAPI");
            try {
                node.getNodeConnection().sendMessage(groupMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void receivePrivateMessageTopic(PrivateMessage privateMessage) {
        if (!privateMessage.getNodeId().equals(UniversalDDSLayerFactory.BROADCAST_ID)) {
            this.sendMessageToNode(privateMessage);
        } else if (privateMessage.getGroupType() > 0 && privateMessage.getGroupId() > 0) {
            this.sendMessageToGroup(privateMessage);
        } else {
            this.sendBroadcastMessage(privateMessage.getMessage(), privateMessage.getMessageId());
        }
    }

    public void receiveUnsentMessageTopic(UnsentMessage unsentMessage) {
    }

    public void receivePingTopic(Ping ping) {
        if (ping.isPingCore()) {
            this.sendPongCore(ping);
        } else {
            this.sendPingToNodes(ping);
        }
    }

    private void sendPongCore(Ping ping) {
        Ping pong = new Ping();
        pong.setGatewayId(this.gatewayId);
        pong.setNodeId(ping.getNodeId());
        pong.setPing(false);
        pong.setPingCore(true);
        pong.setPingId(ping.getPingId());
        pong.setTimestamp(0L);
        this.dds.writeTopic(Ping.class.getSimpleName(), pong);
    }

    private void sendPingToNodes(Ping ping) {
        if (!ping.getNodeId().equals(UniversalDDSLayerFactory.BROADCAST_ID)) {
            AssociatedNode node = this.nodeById.get(ping.getNodeId());
            if (node != null) {
                this.pongThread.addPingQuantity(ping.getPingId(), 1);
                this.threadPool.execute(new SendPingTask(node, ping.getPingId()));
                System.out.println("Ping unicast was sent to a Mobile Node...");
            }
        } else if (ping.getGroupId() > 0 && ping.getGroupType() > 0) {
            Group group = new Group(ping.getGroupType(), ping.getGroupId());
            Set<AssociatedNode> nodes = this.nodesByGroup.get(group);
            this.sendPingToNodeCollection(ping, nodes);
        } else {
            Collection<AssociatedNode> nodes = this.nodeById.values();
            this.sendPingToNodeCollection(ping, nodes);
        }
    }

    private void sendPingToNodeCollection(Ping ping, Collection<AssociatedNode> nodes) {
        if (nodes != null && nodes.size() > 0) {
            this.pongThread.addPingQuantity(ping.getPingId(), nodes.size());
            for (AssociatedNode node : nodes) {
                this.threadPool.execute(new SendPingTask(node, ping.getPingId()));
            }
            System.out.println("Ping was sent to " + nodes.size() + " Mobile Nodes...");
        }
    }

    private void sendMessageToNode(PrivateMessage privateMessage) {
        AssociatedNode node = this.nodeById.get(privateMessage.getNodeId());
        if (node != null) {
            this.threadPool.execute(new SendMessageTask(this, node, privateMessage.getMessage()));
        } else if (!privateMessage.getGatewayId().equals(UniversalDDSLayerFactory.BROADCAST_ID)) {
            this.sendUnsentMessage(privateMessage.getNodeId(), privateMessage.getMessage());
        }
    }

    public void sendUnsentMessage(UUID nodeId, byte[] unsentMessage) {
        UnsentMessage unsentMessageTopic = new UnsentMessage();
        unsentMessageTopic.setGatewayId(this.gatewayId);
        unsentMessageTopic.setNodeId(nodeId);
        unsentMessageTopic.addUnsentMessage(unsentMessage);
        this.dds.writeTopic(UnsentMessage.class.getSimpleName(), unsentMessageTopic);
    }

    private void sendGroupReport(int messageId, int numberOfNodes, int groupType, int groupId) {
        GroupReport groupReport = new GroupReport(messageId, groupId, groupType, numberOfNodes);
        this.dds.writeTopic(GroupReport.class.getSimpleName(), groupReport);
    }

    private void sendMessageToGroup(PrivateMessage privateMessage) {
        Set<AssociatedNode> nodes = this.nodesByGroup.get(new Group(privateMessage.getGroupType(), privateMessage.getGroupId()));
        if (nodes != null) {
            this.sendGroupReport(privateMessage.getMessageId(), nodes.size(), privateMessage.getGroupType(), privateMessage.getGroupId());
            for (AssociatedNode node : nodes) {
                this.threadPool.execute(new SendMessageTask(this, node, privateMessage.getMessage()));
            }
        }
    }

    private void sendBroadcastMessage(byte[] message, int messageId) {
        Collection<AssociatedNode> nodeCollection = this.nodeById.values();
        this.sendGroupReport(messageId, nodeCollection.size(), -1, -1);
        for (AssociatedNode node : nodeCollection) {
            this.threadPool.execute(new SendMessageTask(this, node, message));
        }
    }

    public void sendLoadReportTopic(LoadReport loadReport) {
        loadReport.setNumberOfConnectedNodes(this.nodeById.size());
        loadReport.setParticipantId(this.gatewayId);
        loadReport.setParticipantType(UniversalDDSLayerFactory.ParticipantType.GATEWAY);
        this.dds.writeTopic(LoadReport.class.getSimpleName(), loadReport);
    }

    public void close() {
        this.dds.close();
        this.dds = null;
        this.connectionServer.removeListener(this);
        this.nodesByConnection.clear();
        this.nodesByGroup.clear();
        this.nodeById.clear();
    }

    @Override
    public void pingReceived(NodeConnection remoteCon, lac.cnclib.sddl.Ping ping) {
        if (ping.isPong()) {
            this.pongThread.addPong(ping);
        }
    }

    @Override
    public void newPointOfAttachmentListReceived(NodeConnection remoteCon, PointsOfAttachment poaList) {
    }

    @Override
    public void startingHandover(NodeConnection remoteCon, SocketAddress endPoint, boolean wasMandatory) {
    }

    @Override
    public void newProtocolMessageReceived(NodeConnection remoteCon, Message message) {
        switch (message.getType()) {
            case GROUPMEMBERSHIP: {
                this.processGroupMembership(remoteCon, message);
                break;
            }
            case GROUPCAST: {
                this.processGroupcast(remoteCon, message);
                break;
            }
        }
    }

    private void processGroupMembership(NodeConnection remoteCon, Message groupMessage) {
        GroupMembershipOperation groupOperation = (GroupMembershipOperation)groupMessage.getContentObject();
        List<Group> joinGroup = groupOperation.getJoinedGroup();
        List<Group> leftGroup = groupOperation.getLeftGroup();
        AssociatedNode node = this.nodesByConnection.get(remoteCon.getUuid());
        if (node == null) {
            node = this.addNewNode(remoteCon, groupMessage.getSenderID());
        }
        HashSet<Group> removedGroups = new HashSet<Group>(leftGroup);
        HashSet<Group> addedGroups = new HashSet<Group>(joinGroup);
        node.removeAllGroups(removedGroups);
        node.addAllGroups(addedGroups);
        this.removeNodeFromGroups(node, removedGroups);
        this.addNodeToGroups(node, addedGroups);
        GroupMembershipOperation groupMembershipOperation = new GroupMembershipOperation(joinGroup, leftGroup);
        lac.cnclib.net.groups.message.GroupMessage joinMessage = new lac.cnclib.net.groups.message.GroupMessage();
        joinMessage.setMsgType(ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
        joinMessage.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
        joinMessage.setContentObject(groupMembershipOperation);
        joinMessage.setSenderID(this.gatewayId);
        joinMessage.setRecipientID(node.getNodeId());
        joinMessage.setTagList(new ArrayList<String>());
        joinMessage.addTag("_groupAPI");
        this.sendPrivateMessage(joinMessage);
    }

    private void processGroupcast(NodeConnection remoteCon, Message groupMessage) {
        GroupcastMessage groupcastMessage = (GroupcastMessage)groupMessage.getContentObject();
        if (this.useTotalOrderGroupcast) {
            GroupMessage messageTopic;
            ++this.localLogicalTime;
            this.fastTotalOrder.addMessageIntoBuffer(this.localLogicalTime, this.gatewayId, groupcastMessage);
            try {
                messageTopic = new GroupMessage(this.gatewayId, this.localLogicalTime, Serialization.toJavaByteStream(groupcastMessage));
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.dds.writeTopic(GroupMessage.class.getSimpleName(), messageTopic);
            if (this.gatewayLogicalTimeCollection.size() == 0 || this.gatewayId.compareTo(this.lowerKnownGatewayId) == -1) {
                Map<LocalLogicalTime, GroupcastMessage> deliverableMessages = this.fastTotalOrder.checkDeliverableMessages();
                this.sendGroupMessage(deliverableMessages);
            }
        } else {
            List<Group> group = groupcastMessage.getGroups();
            byte[] messageToSend = (byte[])groupcastMessage.getMessage();
            for (Group aGroup : group) {
                ++this.localLogicalTime;
                try {
                    this.sendPrivateMessageTopic(messageToSend, aGroup);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void receiveGroupMessageTopic(GroupMessage groupMessage) {
        this.localLogicalTime = Math.max(this.localLogicalTime, groupMessage.getLocalLogicalTime());
        GroupcastMessage groupcastMessage = (GroupcastMessage)Serialization.fromJavaByteStream(groupMessage.getMessage());
        this.fastTotalOrder.addMessageIntoBuffer(groupMessage.getLocalLogicalTime(), groupMessage.getGatewayId(), groupcastMessage);
        this.gatewayLogicalTimeCollection.put(groupMessage.getGatewayId(), groupMessage.getLocalLogicalTime());
        Map<LocalLogicalTime, GroupcastMessage> deliverableMessages = this.fastTotalOrder.checkDeliverableMessages();
        this.sendGroupMessage(deliverableMessages);
    }

    private void sendGroupMessage(Map<LocalLogicalTime, GroupcastMessage> deliverableMessages) {
        for (GroupcastMessage messageToSend : deliverableMessages.values()) {
            for (Group group : messageToSend.getGroups()) {
                ((Message)messageToSend.getMessage()).setGatewayLogicalTime(this.localLogicalTime);
                this.sendMessageToGroup(messageToSend, group);
            }
        }
    }

    private void sendMessageToGroup(GroupcastMessage message, Group group) {
        Collection nodeCollection = group == null || group.getGroupID() == -1 && group.getGroupType() == -1 ? this.nodeById.values() : (Collection)this.nodesByGroup.get(group);
        if (nodeCollection == null) {
            return;
        }
        for (AssociatedNode node : nodeCollection) {
            new SendMessageTask(this, node, Serialization.toProtocolMessage((Message)message.getMessage())).run();
        }
    }

    public void receiveLoadReportTopic(LoadReport loadReport) {
        if (this.lowerKnownGatewayId.compareTo(loadReport.getParticipantId()) == 1) {
            this.lowerKnownGatewayId = loadReport.getParticipantId();
        }
        if (this.gatewayLogicalTimeCollection.get(loadReport.getParticipantId()) == null) {
            this.gatewayLogicalTimeCollection.put(loadReport.getParticipantId(), 0L);
        }
    }

    public SddlLayer getDDS() {
        return this.dds;
    }
}

