/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.components;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import lac.cnet.sddl.objects.Ping;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;
import lac.contextnet.highlyscalableset.ReadWriteLockSet;

public class PongThread
extends Thread {
    private static final int TIMEOUT_IN_SECS = 120000;
    private Map<Byte, LinkedList<Long>> pongsById;
    private Map<Byte, Integer> pingsQuantity;
    private Map<Byte, Long> pingTimestamps;
    private Set<Byte> toBeProcessed;
    private SddlLayer entityManager;
    private UUID gatewayId;
    public Object lock;

    public PongThread(SddlLayer entityManager, UUID gatewayId) {
        this.entityManager = entityManager;
        this.gatewayId = gatewayId;
        this.pongsById = new ReadWriteLockMap<Byte, LinkedList<Long>>();
        this.pingsQuantity = new TreeMap<Byte, Integer>();
        this.toBeProcessed = new ReadWriteLockSet<Byte>();
        this.pingTimestamps = new TreeMap<Byte, Long>();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(lac.cnclib.sddl.Ping pong) {
        long pingTimestamp;
        long curretTime = System.currentTimeMillis();
        if (curretTime - (pingTimestamp = this.pingTimestamps.get(pong.getId()).longValue()) > 120000L) {
            return;
        }
        LinkedList<Long> pongs = null;
        Object object = this.lock;
        synchronized (object) {
            pongs = this.pongsById.get(pong.getId());
            pongs.add(System.currentTimeMillis());
            if (pongs.size() == this.pingsQuantity.get(pong.getId()).intValue()) {
                this.toBeProcessed.add(pong.getId());
                this.lock.notify();
            }
        }
    }

    public void addPingQuantity(byte pingId, int pingQuantity) {
        this.pingsQuantity.put(pingId, pingQuantity);
        this.pingTimestamps.put(pingId, System.currentTimeMillis());
        LinkedList pongs = new LinkedList();
        this.pongsById.put(pingId, pongs);
    }

    private void sengPongToDomain(Byte pingId, long highestPongDelay) {
        System.out.println("PongThread.sengPongToDomain()");
        Ping ping = new Ping(pingId, this.gatewayId, UniversalDDSLayerFactory.BROADCAST_ID, highestPongDelay, false, false, 0, 0);
        this.entityManager.writeTopic(Ping.class.getSimpleName(), ping);
    }

    private void removePing(byte pingId) {
        this.pongsById.remove(pingId);
        this.pingsQuantity.remove(pingId);
        this.toBeProcessed.remove(pingId);
        this.pingTimestamps.remove(pingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        while (true) {
            try {
                block6: while (true) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(120000L);
                    }
                    for (Byte pingId : this.toBeProcessed) {
                        long highestPongDelay = this.pongsById.get(pingId).getLast();
                        this.sengPongToDomain(pingId, System.currentTimeMillis() - highestPongDelay);
                        this.removePing(pingId);
                    }
                    Iterator<Object> iterator = this.pongsById.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        Map.Entry entryMap = (Map.Entry)iterator.next();
                        if (((LinkedList)entryMap.getValue()).size() <= 0) continue;
                        Long highestPongDelay = (Long)((LinkedList)entryMap.getValue()).getLast();
                        if (System.currentTimeMillis() - highestPongDelay <= 120000L) continue;
                        this.sengPongToDomain((Byte)entryMap.getKey(), System.currentTimeMillis() - highestPongDelay);
                        int pingDifference = this.pingsQuantity.get(entryMap.getKey()) - this.pongsById.get(entryMap.getKey()).size();
                        System.out.println("Ping ID: " + entryMap.getKey() + " Pings lost: " + pingDifference);
                        this.removePing((Byte)entryMap.getKey());
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

