/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.data;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.groups.Group;

public class AssociatedNode
implements Comparable<AssociatedNode> {
    private UUID nodeId;
    private NodeConnection nodeConnection;
    private final Set<Group> groups;

    public AssociatedNode(UUID nodeId, NodeConnection nodeConnection) {
        this.nodeId = nodeId;
        this.nodeConnection = nodeConnection;
        this.groups = new TreeSet<Group>();
    }

    public AssociatedNode(long MostSignificantBitsID, long LeastSignificantBitsID, NodeConnection nodeConnection) {
        this.nodeId = new UUID(MostSignificantBitsID, LeastSignificantBitsID);
        this.nodeConnection = nodeConnection;
        this.groups = new TreeSet<Group>();
    }

    public boolean addGroup(Group group) {
        return this.groups.add(group);
    }

    public void addAllGroups(Set<Group> groupCollection) {
        this.groups.addAll(groupCollection);
    }

    public void removeAllGroups(Set<Group> toBeRemovedGroupCollection) {
        this.groups.removeAll(toBeRemovedGroupCollection);
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeConnection(NodeConnection nodeConnection) {
        this.nodeConnection = nodeConnection;
    }

    public NodeConnection getNodeConnection() {
        return this.nodeConnection;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    @Override
    public int compareTo(AssociatedNode specifiedNode) {
        return this.nodeId.compareTo(specifiedNode.nodeId);
    }
}

