/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.task;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import lac.cnet.sddl.objects.LoadReport;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class LoadReportObserverTask
extends SigarCommandBase
implements Runnable {
    public static final boolean DEBUG = false;
    private LinkedList<Byte> cpuUsage;
    private int numberOfCpuUsageMeasurement;
    private int freeMemoryInMB;
    private String participantIpAndPort;
    private Map<String, NetInterfaceStat> networkInterfaces;

    public LoadReportObserverTask(String participantIp, int numberOfCpuUsageMeasurement) {
        this.numberOfCpuUsageMeasurement = numberOfCpuUsageMeasurement;
        this.cpuUsage = new LinkedList();
        this.participantIpAndPort = participantIp;
        this.prepareNetworkInterfaces();
    }

    public LoadReportObserverTask(String participantIp) {
        this.numberOfCpuUsageMeasurement = 3;
        this.cpuUsage = new LinkedList();
        this.participantIpAndPort = participantIp;
        System.setProperty("java.library.path", String.valueOf(System.getProperty("user.dir")) + "\\libs" + File.pathSeparatorChar + System.getProperty("java.library.path"));
    }

    @Override
    public void output(String[] args) throws SigarException {
        CpuInfo[] infos = this.sigar.getCpuInfoList();
        CpuInfo info = infos[0];
        long cacheSize = info.getCacheSize();
        this.println("Vendor........." + info.getVendor());
        this.println("Model.........." + info.getModel());
        this.println("Mhz............" + info.getMhz());
        this.println("Total CPUs....." + info.getTotalCores());
        if (info.getTotalCores() != info.getTotalSockets() || info.getCoresPerSocket() > info.getTotalCores()) {
            this.println("Physical CPUs.." + info.getTotalSockets());
            this.println("Cores per CPU.." + info.getCoresPerSocket());
        }
        if (cacheSize != -1L) {
            this.println("Cache size...." + cacheSize);
        }
        this.println("");
    }

    private static byte convertCpuUsage(double cpuUsage) {
        return (byte)Math.round(cpuUsage * 100.0);
    }

    private void prepareNetworkInterfaces() {
        this.networkInterfaces = new TreeMap<String, NetInterfaceStat>();
        TreeSet<Long> validInterfaces = new TreeSet<Long>();
        try {
            String[] stringArray = this.sigar.getNetInterfaceList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                NetInterfaceStat currentInterface = this.sigar.getNetInterfaceStat(string);
                if (currentInterface.getRxPackets() > 0L && validInterfaces.add(currentInterface.getTxPackets())) {
                    this.networkInterfaces.put(string, currentInterface);
                }
                ++n2;
            }
            for (NetInterfaceStat netInterfaceStat : this.networkInterfaces.values()) {
                System.out.println(netInterfaceStat.toString());
            }
            System.out.println("validInterfaces.size() " + validInterfaces.size());
        }
        catch (SigarException sigarException) {
            sigarException.printStackTrace();
        }
    }

    public byte getCurrentCpuUsage() {
        try {
            return LoadReportObserverTask.convertCpuUsage(this.sigar.getCpuPerc().getCombined());
        }
        catch (SigarException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getAverageCpuUsage() {
        int count;
        int sumCpuUsage = 0;
        LinkedList<Byte> linkedList = this.cpuUsage;
        synchronized (linkedList) {
            for (Byte cpuUsage : this.cpuUsage) {
                sumCpuUsage += cpuUsage.byteValue();
            }
            count = this.cpuUsage.size();
        }
        return (byte)Math.round(sumCpuUsage / count);
    }

    public LoadReport getLoadReportTopic() {
        LoadReport loadReport = new LoadReport();
        loadReport.setCpuUsage(this.getAverageCpuUsage());
        loadReport.setFreeMemory(this.freeMemoryInMB);
        loadReport.setParticipantIp(this.participantIpAndPort);
        return loadReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<Byte> linkedList = this.cpuUsage;
        synchronized (linkedList) {
            if (this.cpuUsage.size() == this.numberOfCpuUsageMeasurement) {
                this.cpuUsage.remove(0);
            }
            try {
                this.cpuUsage.add(LoadReportObserverTask.convertCpuUsage(this.sigar.getCpuPerc().getCombined()));
                this.freeMemoryInMB = (int)((Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory()) / 0x100000L);
            }
            catch (SigarException e) {
                e.printStackTrace();
            }
        }
    }
}

