/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.task;

import data.AdaptationResponse;
import data.AdaptationResponseWrapper;
import java.io.IOException;
import java.util.Set;
import lac.cnclib.net.groups.Group;
import lac.cnclib.sddl.message.Message;
import lac.cnet.gateway.components.Gateway;

public class SendToDDSTask
implements Runnable {
    private final Gateway gateway;
    private final Set<Group> nodeGroups;
    private final Message message;

    public SendToDDSTask(Gateway gateway, Message message, Set<Group> groups) {
        this.gateway = gateway;
        this.nodeGroups = groups;
        this.message = message;
    }

    @Override
    public void run() {
        if (this.message.getTagList() != null && this.message.getTagList().contains("@")) {
            AdaptationResponseWrapper messageTopic = new AdaptationResponseWrapper();
            AdaptationResponse adaptationResponse = (AdaptationResponse)this.message.getContentObject();
            messageTopic.setMessage(adaptationResponse.message);
            messageTopic.setMessageCode(adaptationResponse.messageCode);
            messageTopic.setAdaptationId(adaptationResponse.adaptationId);
            messageTopic.setNodeId(this.message.getSenderID());
            this.gateway.getDDS().writeTopic(AdaptationResponseWrapper.class.getSimpleName(), messageTopic);
            return;
        }
        try {
            lac.cnet.sddl.objects.Message messageTopic = this.gateway.toMessageTopic(this.message, this.nodeGroups);
            if (this.gateway.plugin != null) {
                messageTopic = this.gateway.plugin.processMessageTopic(messageTopic);
            }
            this.gateway.getDDS().writeTopic(lac.cnet.sddl.objects.Message.class.getSimpleName(), messageTopic);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

