/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.groupdefiner.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lac.cnclib.net.groups.Group;
import lac.cnet.groupdefiner.components.Node;
import lac.cnet.groupdefiner.components.groupselector.GroupSelector;
import lac.cnet.groupdefiner.components.listeners.AllGroupsInfoRequestListener;
import lac.cnet.groupdefiner.components.listeners.GroupDefinerListener;
import lac.cnet.groupdefiner.components.listeners.GroupRegionListener;
import lac.cnet.groupdefiner.task.GroupMembershipGDiffMessageTask;
import lac.cnet.sddl.objects.AllGroupsInfo;
import lac.cnet.sddl.objects.AllGroupsInfoRequest;
import lac.cnet.sddl.objects.GroupAdvertisement;
import lac.cnet.sddl.objects.GroupInfoStructure;
import lac.cnet.sddl.objects.GroupRegion;
import lac.cnet.sddl.objects.Message;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.contextnet.highlyscalablemap.HighlyScalableMap;
import lac.contextnet.highlyscalableset.ReadWriteLockSet;

public class GroupDefiner {
    private SddlLayer dds;
    private final GroupSelector groupSelectionModule;
    private ScheduledThreadPoolExecutor threadPoolExecutor;
    private final Map<Group, Set<Node>> nodesByGroup;
    private final Map<UUID, Node> nodeById;

    public GroupDefiner(GroupSelector groupSelector) {
        this.groupSelectionModule = groupSelector;
        this.nodesByGroup = new HighlyScalableMap<Group, Set<Node>>();
        this.nodeById = new TreeMap<UUID, Node>();
        this.prepareThreadPoolExecutor();
        this.prepareDDSEntityManager();
    }

    private void prepareThreadPoolExecutor() {
        int availableCPUCores = Runtime.getRuntime().availableProcessors();
        this.threadPoolExecutor = new ScheduledThreadPoolExecutor(availableCPUCores);
    }

    private void prepareDDSEntityManager() {
        this.dds = UniversalDDSLayerFactory.getInstance();
        this.dds.createParticipant(0L);
        this.dds.createPublisher();
        this.dds.createSubscriber();
        GroupDefinerListener groupDefinerDDSListener = new GroupDefinerListener(this);
        Object messageTopic = this.dds.createTopic(Message.class, Message.class.getSimpleName());
        this.dds.createDataReader(groupDefinerDDSListener, messageTopic);
        Object groupAdvertisementTopic = this.dds.createTopic(GroupAdvertisement.class, GroupAdvertisement.class.getSimpleName());
        this.dds.createDataWriter(groupAdvertisementTopic);
        Object prohibitedGroupAdvertisementTopic = this.dds.createTopic(GroupAdvertisement.class, "ProhibitedGroupAdvertisementTopic");
        this.dds.createDataWriter(prohibitedGroupAdvertisementTopic);
        Object groupRegionTopic = this.dds.createTopic(GroupRegion.class, GroupRegion.class.getSimpleName());
        GroupRegionListener groupRegionListener = new GroupRegionListener(this);
        this.dds.createDataReader(groupRegionListener, groupRegionTopic);
        Object allGroupsInfoRequestTopic = this.dds.createTopic(AllGroupsInfoRequest.class, AllGroupsInfoRequest.class.getSimpleName());
        this.dds.createDataReader(new AllGroupsInfoRequestListener(this), allGroupsInfoRequestTopic);
        Object AllGroupsInfoTopic2 = this.dds.createTopic(AllGroupsInfo.class, AllGroupsInfo.class.getSimpleName());
        this.dds.createDataWriter(AllGroupsInfoTopic2);
    }

    public void receiveMessageTopic(Message mobileNodeInformation) {
        GroupMembershipGDiffMessageTask groupMembershipDiffMessageTask = new GroupMembershipGDiffMessageTask(this, mobileNodeInformation);
        this.threadPoolExecutor.execute(groupMembershipDiffMessageTask);
    }

    public void sendGDiffMessageToDomain(Message mobileNodeInformation, Collection<Integer> gDiffMessage, int groupType) {
        GroupAdvertisement groupAdvertisementTopic = new GroupAdvertisement();
        groupAdvertisementTopic.setGatewayId(mobileNodeInformation.getGatewayId());
        groupAdvertisementTopic.setNodeId(mobileNodeInformation.getSenderId());
        groupAdvertisementTopic.setGroupType(groupType);
        groupAdvertisementTopic.setGroupOperationCollection(gDiffMessage);
        boolean returnCode = this.dds.writeTopic(GroupAdvertisement.class.getSimpleName(), groupAdvertisementTopic);
        assert (!returnCode) : "GroupDefiner could not write on DDS Domain";
    }

    public void sendGDiffProhibiteMessageToDomain(Message mobileNodeInformation, Collection<Integer> prohibiteGroupCollection, int groupType) {
        GroupAdvertisement prohibitedGroupAdvertisementTopic = new GroupAdvertisement();
        prohibitedGroupAdvertisementTopic.setGatewayId(mobileNodeInformation.getGatewayId());
        prohibitedGroupAdvertisementTopic.setNodeId(mobileNodeInformation.getSenderId());
        prohibitedGroupAdvertisementTopic.setGroupOperationCollection(prohibiteGroupCollection);
        prohibitedGroupAdvertisementTopic.setGroupType(groupType);
        this.dds.writeTopic("ProhibitedGroupAdvertisementTopic", prohibitedGroupAdvertisementTopic);
    }

    public void updateNodeGroups(Set<Integer> groupsToBeAdded, Set<Integer> groupsToBeRemoved, UUID nodeId, UUID gatewayId) {
        Node node = this.nodeById.get(nodeId);
        if (node == null) {
            node = new Node(nodeId);
            this.nodeById.put(nodeId, node);
        }
        ArrayList<Group> removeGroups = new ArrayList<Group>(groupsToBeRemoved.size());
        ArrayList<Group> addGroups = new ArrayList<Group>(groupsToBeAdded.size());
        for (Integer groupId : groupsToBeRemoved) {
            removeGroups.add(new Group(this.groupSelectionModule.getGroupType(), groupId));
        }
        for (Integer groupId : groupsToBeAdded) {
            addGroups.add(new Group(this.groupSelectionModule.getGroupType(), groupId));
        }
        node.removeAllGroups(removeGroups);
        node.addAllGroups(addGroups);
        this.removeNodeFromGroups(node, removeGroups);
        this.addNodeToGroups(node, addGroups);
    }

    private void removeNodeFromGroups(Node node, Collection<Group> toBeRemovedGroupCollection) {
        for (Group group : toBeRemovedGroupCollection) {
            Set<Node> nodesInGroup = this.nodesByGroup.get(group);
            if (nodesInGroup == null) continue;
            nodesInGroup.remove(node);
            if (nodesInGroup.size() != 0) continue;
            this.nodesByGroup.remove(group);
        }
    }

    private void addNodeToGroups(Node node, Collection<Group> groupCollection) {
        for (Group group : groupCollection) {
            Set<Node> nodes = this.nodesByGroup.get(group);
            if (nodes == null) {
                nodes = new ReadWriteLockSet<Node>();
                nodes.add(node);
                this.nodesByGroup.put(group, nodes);
                continue;
            }
            nodes.add(node);
        }
    }

    public void receiveGroupRegion(GroupRegion groupRegion) {
        this.groupSelectionModule.createGroup(groupRegion);
    }

    public void receiveAllGroupsInfoRequest(AllGroupsInfoRequest allGroupsInfoRequest) {
        AllGroupsInfo allGroupsInfo = new AllGroupsInfo();
        allGroupsInfo.setRequestId(allGroupsInfoRequest.getRequestId());
        allGroupsInfo.setGroups(new GroupInfoStructure[this.nodesByGroup.size()]);
        int count = 0;
        for (Map.Entry<Group, Set<Node>> entry : this.nodesByGroup.entrySet()) {
            GroupInfoStructure group = new GroupInfoStructure();
            group.setGroupId(entry.getKey().getGroupID());
            group.setGroupType(entry.getKey().getGroupType());
            UUID[] ids = new UUID[entry.getValue().size()];
            Iterator<Node> iterator = entry.getValue().iterator();
            int i = 0;
            while (i < ids.length) {
                ids[i] = iterator.next().getNodeId();
                ++i;
            }
            group.setMobileNodesIds(ids);
            allGroupsInfo.getGroups()[count] = group;
            ++count;
        }
        this.dds.writeTopic(AllGroupsInfo.class.getSimpleName(), allGroupsInfo);
    }

    public GroupSelector getGroupProcessor() {
        return this.groupSelectionModule;
    }

    public Map<UUID, Node> getNodeById() {
        return this.nodeById;
    }

    public Map<Group, Set<Node>> getNodesByGroup() {
        return this.nodesByGroup;
    }
}

