/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.groupdefiner.task;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lac.cnet.groupdefiner.components.GroupDefiner;
import lac.cnet.groupdefiner.components.groupselector.GroupSelector;
import lac.cnet.groupdefiner.components.groupselector.GroupSelectorSupportingProhibitedGroups;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.Message;

public class GroupMembershipGDiffMessageTask
implements Runnable {
    private final GroupDefiner groupDefiner;
    private final Message mobileNodeInformation;

    public GroupMembershipGDiffMessageTask(GroupDefiner groupDefiner, Message mobileNodeInformation) {
        this.groupDefiner = groupDefiner;
        this.mobileNodeInformation = mobileNodeInformation;
    }

    @Override
    public void run() {
        Set<Integer> oldGroupCollection;
        Set<Integer> gDiffMessage;
        boolean supportingProhibitedGroups = false;
        GroupSelector groupProcessorSelectionModule = this.groupDefiner.getGroupProcessor();
        assert (groupProcessorSelectionModule != null) : "groupProcessorSelectionModule cannot be NULL";
        Set<Integer> newGroupCollection = groupProcessorSelectionModule.processGroups(this.mobileNodeInformation);
        if (groupProcessorSelectionModule instanceof GroupSelectorSupportingProhibitedGroups) {
            supportingProhibitedGroups = true;
            Set<Integer> prohibiteGroupCollection = ((GroupSelectorSupportingProhibitedGroups)groupProcessorSelectionModule).processProhibitedGroups(this.mobileNodeInformation);
            newGroupCollection.addAll(prohibiteGroupCollection);
        }
        if ((gDiffMessage = this.getGDiffMessage(newGroupCollection, oldGroupCollection = GroupMembershipGDiffMessageTask.getGroupCollection(this.mobileNodeInformation, groupProcessorSelectionModule.getGroupType()))) != null && gDiffMessage.size() > 0) {
            this.groupDefiner.sendGDiffMessageToDomain(this.mobileNodeInformation, gDiffMessage, groupProcessorSelectionModule.getGroupType());
            if (supportingProhibitedGroups) {
                HashSet<Integer> newProhibitedGroups = new HashSet<Integer>();
                for (Integer groupId : newGroupCollection) {
                    if (!((GroupSelectorSupportingProhibitedGroups)groupProcessorSelectionModule).isProhibitedGroup(groupId)) continue;
                    newProhibitedGroups.add(groupId);
                }
                if (newProhibitedGroups.size() > 0) {
                    this.groupDefiner.sendGDiffProhibiteMessageToDomain(this.mobileNodeInformation, newProhibitedGroups, groupProcessorSelectionModule.getGroupType());
                }
                for (Integer groupId : gDiffMessage) {
                    if (groupId >= 0 || !((GroupSelectorSupportingProhibitedGroups)groupProcessorSelectionModule).isProhibitedGroup(Math.abs(groupId))) continue;
                    this.groupDefiner.sendGDiffProhibiteMessageToDomain(this.mobileNodeInformation, gDiffMessage, groupProcessorSelectionModule.getGroupType());
                }
            }
        }
    }

    public static Set<Integer> getGroupCollection(Message nodeMessage, int groupType) {
        assert (nodeMessage != null) : "nodeInformation cannot be NULL!";
        assert (groupType > 0) : "groupType must be greater than 0!";
        HashSet<Integer> groupCollection = null;
        for (GroupCollection group : nodeMessage.getGroupCollection()) {
            assert (group != null) : "group cannot be NULL!";
            if (group.getGroupType() != groupType) continue;
            groupCollection = new HashSet<Integer>(group.getGroupIdCollection().size(), 1.0f);
            GroupMembershipGDiffMessageTask.addAllGroups(groupCollection, group.getGroupIdCollection());
            return groupCollection;
        }
        return new HashSet<Integer>(0);
    }

    public static void addAllGroups(Set<Integer> groupCollection, Collection<Integer> groupsToBeInserted) {
        assert (groupCollection != null) : "groupCollection cannot be NULL!";
        assert (groupsToBeInserted != null) : "groupsToBeInserted cannot be NULL!";
        for (int groupID : groupsToBeInserted) {
            assert (groupID > 0) : "groupID must be greater than 0!";
            groupCollection.add(groupID);
        }
    }

    public Set<Integer> getGDiffMessage(Set<Integer> newGroupCollection, Set<Integer> oldGroupCollection) {
        assert (newGroupCollection != null) : "newGroupCollection cannot be NULL!";
        assert (oldGroupCollection != null) : "oldGroupCollection cannot be NULL!";
        HashSet<Integer> gDiffMessage = new HashSet<Integer>(newGroupCollection.size() + oldGroupCollection.size(), 1.0f);
        HashSet<Integer> toBeRemovedGroupCollection = new HashSet<Integer>(newGroupCollection.size() + oldGroupCollection.size(), 1.0f);
        gDiffMessage.addAll(newGroupCollection);
        gDiffMessage.removeAll(oldGroupCollection);
        toBeRemovedGroupCollection.addAll(oldGroupCollection);
        toBeRemovedGroupCollection.removeAll(newGroupCollection);
        this.groupDefiner.updateNodeGroups(gDiffMessage, toBeRemovedGroupCollection, this.mobileNodeInformation.getSenderId(), this.mobileNodeInformation.getGatewayId());
        for (Integer groupID : toBeRemovedGroupCollection) {
            gDiffMessage.add(groupID * -1);
        }
        return gDiffMessage;
    }
}

