/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import com.rti.dds.infrastructure.IntSeq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.topics.coredx.GroupAdvertisementTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class GroupAdvertisement
implements ApplicationObject {
    private UUID nodeId;
    private UUID gatewayId;
    private int groupType;
    private Collection<Integer> groupOperationCollection;

    public GroupAdvertisement() {
    }

    public GroupAdvertisement(UUID nodeId, UUID gatewayId, int groupType, Collection<Integer> groupOperationCollection) {
        this.nodeId = nodeId;
        this.gatewayId = gatewayId;
        this.groupType = groupType;
        this.groupOperationCollection = groupOperationCollection;
    }

    public GroupAdvertisement(UUID nodeId, UUID gatewayId, int groupType, int[] groupOperationCollection) {
        this.nodeId = nodeId;
        this.gatewayId = gatewayId;
        this.groupType = groupType;
        this.groupOperationCollection = Utils.convertArrayToCollection(groupOperationCollection);
    }

    public GroupAdvertisement(GroupAdvertisementTopic groupAdvertisementTopic) {
        this.nodeId = new UUID(groupAdvertisementTopic.mostSignificantBitsVehicleId, groupAdvertisementTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(groupAdvertisementTopic.mostSignificantBitsGatewayId, groupAdvertisementTopic.leastSignificantBitsGatewayId);
        this.groupType = groupAdvertisementTopic.groupType;
        this.groupOperationCollection = Utils.convertArrayToCollection(groupAdvertisementTopic.groupOperationCollection);
    }

    public GroupAdvertisement(SddlOpenSpliceTopics.GroupAdvertisementTopic groupAdvertisementTopic) {
        this.nodeId = new UUID(groupAdvertisementTopic.mostSignificantBitsVehicleId, groupAdvertisementTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(groupAdvertisementTopic.mostSignificantBitsGatewayId, groupAdvertisementTopic.leastSignificantBitsGatewayId);
        this.groupType = groupAdvertisementTopic.groupType;
        this.groupOperationCollection = Utils.convertArrayToCollection(groupAdvertisementTopic.groupOperationCollection);
    }

    public GroupAdvertisement(lac.cnet.sddl.topics.rti.GroupAdvertisementTopic groupAdvertisementTopic) {
        this.nodeId = new UUID(groupAdvertisementTopic.mostSignificantBitsVehicleId, groupAdvertisementTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(groupAdvertisementTopic.mostSignificantBitsGatewayId, groupAdvertisementTopic.leastSignificantBitsGatewayId);
        this.groupType = groupAdvertisementTopic.groupType;
        this.groupOperationCollection = new ArrayList<Integer>(groupAdvertisementTopic.groupOperationCollection.subList(0, groupAdvertisementTopic.groupOperationCollection.size()));
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.groupOperationCollection == null) {
            this.groupOperationCollection = new ArrayList<Integer>(0);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    GroupAdvertisementTopic getCoreDxTopic() {
        GroupAdvertisementTopic groupAdvertisementTopic = new GroupAdvertisementTopic();
        groupAdvertisementTopic.groupOperationCollection = Utils.convertCollectionToArray(this.groupOperationCollection);
        groupAdvertisementTopic.groupType = this.groupType;
        groupAdvertisementTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupAdvertisementTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return groupAdvertisementTopic;
    }

    SddlOpenSpliceTopics.GroupAdvertisementTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.GroupAdvertisementTopic groupAdvertisementTopic = new SddlOpenSpliceTopics.GroupAdvertisementTopic();
        groupAdvertisementTopic.groupOperationCollection = Utils.convertCollectionToArray(this.groupOperationCollection);
        groupAdvertisementTopic.groupType = this.groupType;
        groupAdvertisementTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupAdvertisementTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return groupAdvertisementTopic;
    }

    lac.cnet.sddl.topics.rti.GroupAdvertisementTopic getRtiTopic() {
        lac.cnet.sddl.topics.rti.GroupAdvertisementTopic groupAdvertisementTopic = new lac.cnet.sddl.topics.rti.GroupAdvertisementTopic();
        groupAdvertisementTopic.groupOperationCollection = new IntSeq(this.groupOperationCollection.size());
        groupAdvertisementTopic.groupOperationCollection.addAll(this.groupOperationCollection);
        groupAdvertisementTopic.groupType = this.groupType;
        groupAdvertisementTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupAdvertisementTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupAdvertisementTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return groupAdvertisementTopic;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return GroupAdvertisementTopic.class.getCanonicalName();
            }
            case RTI: {
                return lac.cnet.sddl.topics.rti.GroupAdvertisementTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.GroupAdvertisementTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public Collection<Integer> getGroupOperationCollection() {
        return this.groupOperationCollection;
    }

    public void setGroupOperationCollection(Collection<Integer> groupOperationCollection) {
        this.groupOperationCollection = groupOperationCollection;
    }

    public void addGroupOperation(int groupOperation) {
        if (this.groupOperationCollection == null) {
            this.groupOperationCollection = new ArrayList<Integer>();
        }
        this.groupOperationCollection.add(groupOperation);
    }
}

