/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import SddlOpenSpliceTopics.PingTopic;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class Ping
implements ApplicationObject {
    private byte pingId;
    private UUID gatewayId;
    private UUID nodeId;
    private long timestamp;
    private boolean pingCore;
    private boolean ping;
    private int groupType;
    private int groupId;

    public Ping() {
    }

    public Ping(byte pingId, UUID gatewayId, UUID nodeId, long timestamp, boolean pingCore, boolean ping, int groupType, int groupId) {
        this.gatewayId = gatewayId;
        this.groupId = groupId;
        this.groupType = groupType;
        this.ping = ping;
        this.pingCore = pingCore;
        this.pingId = pingId;
        this.timestamp = timestamp;
        this.nodeId = nodeId;
    }

    public Ping(lac.cnet.sddl.topics.coredx.PingTopic pingTopic) {
        this.gatewayId = new UUID(pingTopic.mostSignificantBitsGatewayId, pingTopic.leastSignificantBitsGatewayId);
        this.groupId = pingTopic.groupId;
        this.groupType = pingTopic.groupType;
        this.nodeId = new UUID(pingTopic.mostSignificantBitsVehicleId, pingTopic.leastSignificantBitsVehicleId);
        this.ping = pingTopic.ping;
        this.pingCore = pingTopic.pingCore;
        this.pingId = pingTopic.pingId;
        this.timestamp = pingTopic.timestamp;
    }

    public Ping(PingTopic pingTopic) {
        this.gatewayId = new UUID(pingTopic.mostSignificantBitsGatewayId, pingTopic.leastSignificantBitsGatewayId);
        this.groupId = pingTopic.groupId;
        this.groupType = pingTopic.groupType;
        this.nodeId = new UUID(pingTopic.mostSignificantBitsVehicleId, pingTopic.leastSignificantBitsVehicleId);
        this.ping = pingTopic.ping;
        this.pingCore = pingTopic.pingCore;
        this.pingId = pingTopic.pingId;
        this.timestamp = pingTopic.timestamp;
    }

    public Ping(lac.cnet.sddl.topics.rti.PingTopic pingTopic) {
        this.gatewayId = new UUID(pingTopic.mostSignificantBitsGatewayId, pingTopic.leastSignificantBitsGatewayId);
        this.groupId = pingTopic.groupId;
        this.groupType = pingTopic.groupType;
        this.nodeId = new UUID(pingTopic.mostSignificantBitsVehicleId, pingTopic.leastSignificantBitsVehicleId);
        this.ping = pingTopic.ping;
        this.pingCore = pingTopic.pingCore;
        this.pingId = pingTopic.pingId;
        this.timestamp = pingTopic.timestamp;
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.PingTopic.class.getCanonicalName();
            }
            case RTI: {
                return lac.cnet.sddl.topics.rti.PingTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return PingTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    lac.cnet.sddl.topics.coredx.PingTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.PingTopic pingTopic = new lac.cnet.sddl.topics.coredx.PingTopic();
        pingTopic.groupId = this.groupId;
        pingTopic.groupType = this.groupType;
        pingTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        pingTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        pingTopic.ping = this.ping;
        pingTopic.pingCore = this.pingCore;
        pingTopic.pingId = this.pingId;
        pingTopic.timestamp = this.timestamp;
        return pingTopic;
    }

    PingTopic getOpenSpliceTopic() {
        PingTopic pingTopic = new PingTopic();
        pingTopic.groupId = this.groupId;
        pingTopic.groupType = this.groupType;
        pingTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        pingTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        pingTopic.ping = this.ping;
        pingTopic.pingCore = this.pingCore;
        pingTopic.pingId = this.pingId;
        pingTopic.timestamp = this.timestamp;
        return pingTopic;
    }

    lac.cnet.sddl.topics.rti.PingTopic getRtiTopic() {
        lac.cnet.sddl.topics.rti.PingTopic pingTopic = new lac.cnet.sddl.topics.rti.PingTopic();
        pingTopic.groupId = this.groupId;
        pingTopic.groupType = this.groupType;
        pingTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        pingTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        pingTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        pingTopic.ping = this.ping;
        pingTopic.pingCore = this.pingCore;
        pingTopic.pingId = this.pingId;
        pingTopic.timestamp = this.timestamp;
        return pingTopic;
    }

    public byte getPingId() {
        return this.pingId;
    }

    public void setPingId(byte pingId) {
        this.pingId = pingId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isPingCore() {
        return this.pingCore;
    }

    public void setPingCore(boolean pingCore) {
        this.pingCore = pingCore;
    }

    public boolean isPing() {
        return this.ping;
    }

    public void setPing(boolean ping) {
        this.ping = ping;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }
}

