/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import com.rti.dds.infrastructure.ByteSeq;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.topics.rti.PrivateMessageTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class PrivateMessage
implements ApplicationObject {
    private UUID nodeId;
    private UUID gatewayId;
    private int groupId;
    private int groupType;
    private byte[] message;
    private int messageId;

    public PrivateMessage() {
    }

    public PrivateMessage(UUID nodeId, UUID gatewayId, int groupId, int groupType, byte[] message, int messageId) {
        this.gatewayId = gatewayId;
        this.groupId = groupId;
        this.groupType = groupType;
        this.message = message;
        this.nodeId = nodeId;
        this.messageId = messageId;
    }

    public PrivateMessage(lac.cnet.sddl.topics.coredx.PrivateMessageTopic privateMessageTopic) {
        this.gatewayId = new UUID(privateMessageTopic.mostSignificantBitsGatewayId, privateMessageTopic.leastSignificantBitsGatewayId);
        this.groupId = privateMessageTopic.groupId;
        this.groupType = privateMessageTopic.groupType;
        this.message = privateMessageTopic.message;
        this.nodeId = new UUID(privateMessageTopic.mostSignificantBitsVehicleId, privateMessageTopic.leastSignificantBitsVehicleId);
    }

    public PrivateMessage(SddlOpenSpliceTopics.PrivateMessageTopic privateMessageTopic) {
        this.gatewayId = new UUID(privateMessageTopic.mostSignificantBitsGatewayId, privateMessageTopic.leastSignificantBitsGatewayId);
        this.groupId = privateMessageTopic.groupId;
        this.groupType = privateMessageTopic.groupType;
        this.message = privateMessageTopic.message;
        this.nodeId = new UUID(privateMessageTopic.mostSignificantBitsVehicleId, privateMessageTopic.leastSignificantBitsVehicleId);
        this.messageId = privateMessageTopic.messageId;
    }

    public PrivateMessage(PrivateMessageTopic privateMessageTopic) {
        this.gatewayId = new UUID(privateMessageTopic.mostSignificantBitsGatewayId, privateMessageTopic.leastSignificantBitsGatewayId);
        this.groupId = privateMessageTopic.groupId;
        this.groupType = privateMessageTopic.groupType;
        this.message = privateMessageTopic.message.toArrayByte(new byte[0]);
        this.nodeId = new UUID(privateMessageTopic.mostSignificantBitsVehicleId, privateMessageTopic.leastSignificantBitsVehicleId);
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.message == null) {
            this.message = new byte[0];
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.PrivateMessageTopic.class.getCanonicalName();
            }
            case RTI: {
                return PrivateMessageTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.PrivateMessageTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    lac.cnet.sddl.topics.coredx.PrivateMessageTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.PrivateMessageTopic privateMessageTopic = new lac.cnet.sddl.topics.coredx.PrivateMessageTopic();
        privateMessageTopic.groupId = this.groupId;
        privateMessageTopic.groupType = this.groupType;
        privateMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        privateMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        privateMessageTopic.message = this.message;
        return privateMessageTopic;
    }

    SddlOpenSpliceTopics.PrivateMessageTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.PrivateMessageTopic privateMessageTopic = new SddlOpenSpliceTopics.PrivateMessageTopic();
        privateMessageTopic.groupId = this.groupId;
        privateMessageTopic.groupType = this.groupType;
        privateMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        privateMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        privateMessageTopic.message = this.message;
        privateMessageTopic.messageId = this.messageId;
        return privateMessageTopic;
    }

    PrivateMessageTopic getRtiTopic() {
        PrivateMessageTopic privateMessageTopic = new PrivateMessageTopic();
        privateMessageTopic.groupId = this.groupId;
        privateMessageTopic.groupType = this.groupType;
        privateMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        privateMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        privateMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        privateMessageTopic.message = new ByteSeq(this.message);
        return privateMessageTopic;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }
}

