/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.GroupAdvertisement;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.topics.coredx.GroupAdvertisementTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class GroupAdvertisementTest
extends TestCase {
    @Test
    public final void testGroupAdvertisement() {
        GroupAdvertisement object = new GroupAdvertisement();
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        int groupType = 15;
        ArrayList<Integer> collection = new ArrayList<Integer>();
        collection.add(79);
        collection.add(5);
        collection.add(18);
        object.setGatewayId(gatewayId);
        object.setNodeId(nodeId);
        object.setGroupType(groupType);
        object.setGroupOperationCollection(collection);
        GroupAdvertisementTest.assertEquals("set/getGatewayId ERROR", gatewayId, object.getGatewayId());
        GroupAdvertisementTest.assertEquals("set/getNodeId ERROR", nodeId, object.getNodeId());
        GroupAdvertisementTest.assertEquals("set/getGroupType ERROR", groupType, object.getGroupType());
        GroupAdvertisementTest.assertEquals("set/getGroupOperationCollection ERROR", collection, object.getGroupOperationCollection());
    }

    @Test
    public final void testGroupAdvertisementUUIDUUIDIntCollectionOfInteger() {
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        int groupType = 15;
        ArrayList<Integer> collection = new ArrayList<Integer>();
        collection.add(79);
        collection.add(5);
        collection.add(18);
        GroupAdvertisement object = new GroupAdvertisement(nodeId, gatewayId, groupType, collection);
        GroupAdvertisementTest.assertEquals("set/getGatewayId ERROR", gatewayId, object.getGatewayId());
        GroupAdvertisementTest.assertEquals("set/getNodeId ERROR", nodeId, object.getNodeId());
        GroupAdvertisementTest.assertEquals("set/getGroupType ERROR", groupType, object.getGroupType());
        GroupAdvertisementTest.assertEquals("set/getGroupOperationCollection ERROR", collection, object.getGroupOperationCollection());
    }

    @Test
    public final void testGroupAdvertisementUUIDUUIDIntIntArray() {
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        int groupType = 15;
        int[] array = new int[]{79, 5, 18};
        GroupAdvertisement object = new GroupAdvertisement(nodeId, gatewayId, groupType, array);
        GroupAdvertisementTest.assertEquals("set/getGatewayId ERROR", gatewayId, object.getGatewayId());
        GroupAdvertisementTest.assertEquals("set/getNodeId ERROR", nodeId, object.getNodeId());
        GroupAdvertisementTest.assertEquals("set/getGroupType ERROR", groupType, object.getGroupType());
        Collection<Integer> collection = Utils.convertArrayToCollection(array);
        GroupAdvertisementTest.assertEquals("set/getGroupOperationCollection ERROR", collection, object.getGroupOperationCollection());
    }

    @Test
    public final void testGroupAdvertisementGroupAdvertisementTopic() {
        GroupAdvertisementTopic coreDx = new GroupAdvertisementTopic();
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        int groupType = 83;
        int[] array = new int[]{79, 5, 18, 1, 47};
        ArrayList<Integer> collection = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            collection.add(array[i]);
            ++i;
        }
        coreDx.groupOperationCollection = array;
        coreDx.groupType = groupType;
        coreDx.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        coreDx.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        coreDx.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        coreDx.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        GroupAdvertisement object = new GroupAdvertisement(coreDx);
        lac.cnet.sddl.topics.rti.GroupAdvertisementTopic rti = (lac.cnet.sddl.topics.rti.GroupAdvertisementTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        GroupAdvertisementTest.assertEquals("ERROR", gatewayId.getLeastSignificantBits(), rti.leastSignificantBitsGatewayId);
        GroupAdvertisementTest.assertEquals("ERROR", gatewayId.getMostSignificantBits(), rti.mostSignificantBitsGatewayId);
        GroupAdvertisementTest.assertEquals("ERROR", nodeId.getMostSignificantBits(), rti.mostSignificantBitsVehicleId);
        GroupAdvertisementTest.assertEquals("ERROR", nodeId.getLeastSignificantBits(), rti.leastSignificantBitsVehicleId);
        GroupAdvertisementTest.assertEquals("ERROR", groupType, rti.groupType);
        GroupAdvertisementTest.assertTrue(Arrays.equals(array, rti.groupOperationCollection.toArrayInt(new int[0])));
    }

    @Test
    public final void testGroupAdvertisementGroupAdvertisementTopic1() {
        lac.cnet.sddl.topics.rti.GroupAdvertisementTopic topic = new lac.cnet.sddl.topics.rti.GroupAdvertisementTopic();
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        int groupType = 83;
        int[] array = new int[]{79, 5, 18, 1, 47};
        ArrayList<Integer> collection = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            collection.add(array[i]);
            ++i;
        }
        topic.groupOperationCollection.addAllInt(array);
        topic.groupType = groupType;
        topic.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        topic.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        topic.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        topic.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        GroupAdvertisement object = new GroupAdvertisement(topic);
        GroupAdvertisementTopic coreDx = (GroupAdvertisementTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        GroupAdvertisementTest.assertEquals("ERROR", gatewayId.getLeastSignificantBits(), coreDx.leastSignificantBitsGatewayId);
        GroupAdvertisementTest.assertEquals("ERROR", gatewayId.getMostSignificantBits(), coreDx.mostSignificantBitsGatewayId);
        GroupAdvertisementTest.assertEquals("ERROR", nodeId.getMostSignificantBits(), coreDx.mostSignificantBitsVehicleId);
        GroupAdvertisementTest.assertEquals("ERROR", nodeId.getLeastSignificantBits(), coreDx.leastSignificantBitsVehicleId);
        GroupAdvertisementTest.assertEquals("ERROR", groupType, coreDx.groupType);
        GroupAdvertisementTest.assertTrue(Arrays.equals(array, coreDx.groupOperationCollection));
    }

    @Test
    public final void testGetSpecificDdsTopic() {
        this.testGroupAdvertisementGroupAdvertisementTopic();
        this.testGroupAdvertisementGroupAdvertisementTopic1();
    }

    @Test
    public final void testAddGroupOperation() {
        GroupAdvertisement object = new GroupAdvertisement();
        LinkedList<Integer> collection = new LinkedList<Integer>();
        int i = 0;
        while (i < 10) {
            collection.add(i);
            object.addGroupOperation(i);
            ++i;
        }
        GroupAdvertisementTest.assertEquals(collection, object.getGroupOperationCollection());
    }
}

