/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.LoadReport;
import lac.cnet.sddl.topics.rti.LoadReportTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class LoadReportTest
extends TestCase {
    @Test
    public final void testLoadReport() {
        LoadReport object = new LoadReport();
        byte cpuUsage = 74;
        int freeMemory = 465;
        int numberOfConnectedNodes = 5646;
        UUID id = UUID.randomUUID();
        String ip = "127.0.0.1:5500";
        object.setCpuUsage(cpuUsage);
        object.setFreeMemory(freeMemory);
        object.setNumberOfConnectedNodes(numberOfConnectedNodes);
        object.setParticipantId(id);
        object.setParticipantIp(ip);
        object.setParticipantType(UniversalDDSLayerFactory.ParticipantType.GATEWAY);
        LoadReportTest.assertEquals(cpuUsage, object.getCpuUsage());
        LoadReportTest.assertEquals(numberOfConnectedNodes, object.getNumberOfConnectedNodes());
        LoadReportTest.assertEquals(id, object.getParticipantId());
        LoadReportTest.assertEquals(ip, object.getParticipantIp());
        LoadReportTest.assertEquals(UniversalDDSLayerFactory.ParticipantType.GATEWAY.ordinal(), object.getParticipantType().ordinal());
    }

    @Test
    public final void testLoadReportUUIDParticipantTypeByteIntIntString() {
        byte cpuUsage = 74;
        int freeMemory = 465;
        int numberOfConnectedNodes = 5646;
        UUID id = UUID.randomUUID();
        String ip = "127.0.0.1:5500";
        LoadReport object = new LoadReport(id, UniversalDDSLayerFactory.ParticipantType.GATEWAY, cpuUsage, freeMemory, numberOfConnectedNodes, ip);
        LoadReportTest.assertEquals(cpuUsage, object.getCpuUsage());
        LoadReportTest.assertEquals(numberOfConnectedNodes, object.getNumberOfConnectedNodes());
        LoadReportTest.assertEquals(id, object.getParticipantId());
        LoadReportTest.assertEquals(ip, object.getParticipantIp());
        LoadReportTest.assertEquals(UniversalDDSLayerFactory.ParticipantType.GATEWAY.ordinal(), object.getParticipantType().ordinal());
    }

    @Test
    public final void testLoadReportLoadReportTopic() {
        int cpuUsage = 74;
        int freeMemory = 465;
        int numberOfConnectedNodes = 5646;
        UUID id = UUID.randomUUID();
        String ip = "127.0.0.1:5500";
        lac.cnet.sddl.topics.coredx.LoadReportTopic coreDx = new lac.cnet.sddl.topics.coredx.LoadReportTopic();
        coreDx.cpuUsage = (byte)cpuUsage;
        coreDx.freeMemory = freeMemory;
        coreDx.leastSignificantBitsParticipantId = id.getLeastSignificantBits();
        coreDx.mostSignificantBitsParticipantId = id.getMostSignificantBits();
        coreDx.numberOfConnectedVehicles = numberOfConnectedNodes;
        coreDx.participantIp = ip;
        coreDx.participantType = (byte)UniversalDDSLayerFactory.ParticipantType.GROUPDEFINER.ordinal();
        LoadReport object = new LoadReport(coreDx);
        LoadReportTopic rti = (LoadReportTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        LoadReportTest.assertEquals(rti.cpuUsage, object.getCpuUsage());
        LoadReportTest.assertEquals(rti.numberOfConnectedVehicles, object.getNumberOfConnectedNodes());
        LoadReportTest.assertEquals(rti.leastSignificantBitsParticipantId, object.getParticipantId().getLeastSignificantBits());
        LoadReportTest.assertEquals(rti.mostSignificantBitsParticipantId, object.getParticipantId().getMostSignificantBits());
        LoadReportTest.assertEquals(rti.participantIp, object.getParticipantIp());
        LoadReportTest.assertEquals((int)rti.participantType, object.getParticipantType().ordinal());
    }

    @Test
    public final void testLoadReportLoadReportTopic1() {
        int cpuUsage = 74;
        int freeMemory = 465;
        int numberOfConnectedNodes = 5646;
        UUID id = UUID.randomUUID();
        String ip = "127.0.0.1:5500";
        LoadReportTopic rti = new LoadReportTopic();
        rti.cpuUsage = (byte)cpuUsage;
        rti.freeMemory = freeMemory;
        rti.leastSignificantBitsParticipantId = id.getLeastSignificantBits();
        rti.mostSignificantBitsParticipantId = id.getMostSignificantBits();
        rti.numberOfConnectedVehicles = numberOfConnectedNodes;
        rti.participantIp = ip;
        rti.participantType = (byte)UniversalDDSLayerFactory.ParticipantType.GROUPDEFINER.ordinal();
        LoadReport object = new LoadReport(rti);
        lac.cnet.sddl.topics.coredx.LoadReportTopic coreDx = (lac.cnet.sddl.topics.coredx.LoadReportTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        LoadReportTest.assertEquals(coreDx.cpuUsage, object.getCpuUsage());
        LoadReportTest.assertEquals(coreDx.numberOfConnectedVehicles, object.getNumberOfConnectedNodes());
        LoadReportTest.assertEquals(coreDx.leastSignificantBitsParticipantId, object.getParticipantId().getLeastSignificantBits());
        LoadReportTest.assertEquals(coreDx.mostSignificantBitsParticipantId, object.getParticipantId().getMostSignificantBits());
        LoadReportTest.assertEquals(coreDx.participantIp, object.getParticipantIp());
        LoadReportTest.assertEquals((int)coreDx.participantType, object.getParticipantType().ordinal());
    }

    @Test
    public final void testGetSpecificDdsTopic() {
        this.testLoadReportLoadReportTopic();
        this.testLoadReportLoadReportTopic1();
    }
}

