/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.Arrays;
import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.topics.rti.PrivateMessageTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class PrivateMessageTest
extends TestCase {
    @Test
    public final void testPrivateMessage() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        int groupId = 2984;
        int groupType = 306;
        byte[] message = new byte[]{5, 68, 25, 16, 7, 81};
        PrivateMessage object = new PrivateMessage();
        object.setGatewayId(gatewayId);
        object.setGroupId(2984);
        object.setGroupType(306);
        object.setMessage(message);
        object.setNodeId(nodeId);
        PrivateMessageTest.assertEquals(gatewayId, object.getGatewayId());
        PrivateMessageTest.assertEquals(2984, object.getGroupId());
        PrivateMessageTest.assertEquals(306, object.getGroupType());
        PrivateMessageTest.assertEquals(message, object.getMessage());
        PrivateMessageTest.assertEquals(nodeId, object.getNodeId());
    }

    @Test
    public final void testPrivateMessageUUIDUUIDIntIntByteArray() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        int groupId = 2984;
        int groupType = 306;
        byte[] message = new byte[]{5, 68, 25, 16, 7, 81};
        PrivateMessage object = new PrivateMessage(nodeId, gatewayId, 2984, 306, message, 9);
        PrivateMessageTest.assertEquals(gatewayId, object.getGatewayId());
        PrivateMessageTest.assertEquals(2984, object.getGroupId());
        PrivateMessageTest.assertEquals(306, object.getGroupType());
        PrivateMessageTest.assertEquals(message, object.getMessage());
        PrivateMessageTest.assertEquals(nodeId, object.getNodeId());
    }

    @Test
    public final void testPrivateMessagePrivateMessageTopic() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        int groupId = 2984;
        int groupType = 306;
        byte[] message = new byte[]{5, 68, 25, 16, 7, 81};
        lac.cnet.sddl.topics.coredx.PrivateMessageTopic coreDx = new lac.cnet.sddl.topics.coredx.PrivateMessageTopic();
        coreDx.groupId = 2984;
        coreDx.groupType = 306;
        coreDx.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        coreDx.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        coreDx.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        coreDx.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        coreDx.message = message;
        PrivateMessage object = new PrivateMessage(coreDx);
        PrivateMessageTest.assertEquals(gatewayId, object.getGatewayId());
        PrivateMessageTest.assertEquals(2984, object.getGroupId());
        PrivateMessageTest.assertEquals(306, object.getGroupType());
        PrivateMessageTest.assertEquals(message, object.getMessage());
        PrivateMessageTest.assertEquals(nodeId, object.getNodeId());
        PrivateMessageTopic rti = (PrivateMessageTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        PrivateMessageTest.assertEquals(gatewayId.getLeastSignificantBits(), rti.leastSignificantBitsGatewayId);
        PrivateMessageTest.assertEquals(gatewayId.getMostSignificantBits(), rti.mostSignificantBitsGatewayId);
        PrivateMessageTest.assertEquals(2984, rti.groupId);
        PrivateMessageTest.assertEquals(306, rti.groupType);
        PrivateMessageTest.assertTrue(Arrays.equals(message, rti.message.toArrayByte(new byte[0])));
        PrivateMessageTest.assertEquals(nodeId.getLeastSignificantBits(), rti.leastSignificantBitsVehicleId);
        PrivateMessageTest.assertEquals(nodeId.getMostSignificantBits(), rti.mostSignificantBitsVehicleId);
    }

    @Test
    public final void testPrivateMessagePrivateMessageTopic1() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        int groupId = 2984;
        int groupType = 306;
        byte[] message = new byte[]{5, 68, 25, 16, 7, 81};
        lac.cnet.sddl.topics.coredx.PrivateMessageTopic rti = new lac.cnet.sddl.topics.coredx.PrivateMessageTopic();
        rti.groupId = 2984;
        rti.groupType = 306;
        rti.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        rti.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        rti.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        rti.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        rti.message = message;
        PrivateMessage object = new PrivateMessage(rti);
        PrivateMessageTest.assertEquals(gatewayId, object.getGatewayId());
        PrivateMessageTest.assertEquals(2984, object.getGroupId());
        PrivateMessageTest.assertEquals(306, object.getGroupType());
        PrivateMessageTest.assertEquals(message, object.getMessage());
        PrivateMessageTest.assertEquals(nodeId, object.getNodeId());
        lac.cnet.sddl.topics.coredx.PrivateMessageTopic coreDx = (lac.cnet.sddl.topics.coredx.PrivateMessageTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        PrivateMessageTest.assertEquals(gatewayId.getLeastSignificantBits(), coreDx.leastSignificantBitsGatewayId);
        PrivateMessageTest.assertEquals(gatewayId.getMostSignificantBits(), coreDx.mostSignificantBitsGatewayId);
        PrivateMessageTest.assertEquals(2984, coreDx.groupId);
        PrivateMessageTest.assertEquals(306, coreDx.groupType);
        PrivateMessageTest.assertTrue(Arrays.equals(message, coreDx.message));
        PrivateMessageTest.assertEquals(nodeId.getLeastSignificantBits(), coreDx.leastSignificantBitsVehicleId);
        PrivateMessageTest.assertEquals(nodeId.getMostSignificantBits(), coreDx.mostSignificantBitsVehicleId);
    }
}

