/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.topics.coredx;

import com.toc.coredx.DDS.CoreDX_FieldDef;
import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataWriter;
import com.toc.coredx.DDS.DomainParticipant;
import com.toc.coredx.DDS.Publisher;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SWIGTYPE_p__DataReader;
import com.toc.coredx.DDS.SWIGTYPE_p__DataWriter;
import com.toc.coredx.DDS.Subscriber;
import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import com.toc.coredx.DDS.TypeSupport;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lac.cnet.sddl.topics.coredx.LoadReportTopic;
import lac.cnet.sddl.topics.coredx.LoadReportTopicDataReader;
import lac.cnet.sddl.topics.coredx.LoadReportTopicDataWriter;

public final class LoadReportTopicTypeSupport
implements TypeSupport {
    private long cTypeSupport = 0L;

    @Override
    public ReturnCode_t register_type(DomainParticipant dp, String type_name) {
        if (dp.check_version("3", "6", "8") != 0) {
            System.out.println("WARNING: LoadReportTopic TypeSupport version does not match CoreDX Library version.");
            System.out.println("This may cause software instability or crashes.");
        }
        return dp.register_type(this, type_name);
    }

    @Override
    public String get_type_name() {
        return "LoadReportTopic";
    }

    @Override
    public long getCTypeSupport() {
        return this.cTypeSupport;
    }

    public LoadReportTopicTypeSupport() {
        LoadReportTopic tmp = new LoadReportTopic();
        this.cTypeSupport = DomainParticipant.createTypeSupport(this, this.getClass().getName(), tmp.getClass().getName());
    }

    @Override
    public DataReader create_datareader(Subscriber sub, TopicDescription td, SWIGTYPE_p__DataReader jni_dr) {
        return new LoadReportTopicDataReader(sub, td, jni_dr);
    }

    @Override
    public DataWriter create_datawriter(Publisher pub, Topic topic, SWIGTYPE_p__DataWriter jni_dw) {
        return new LoadReportTopicDataWriter(pub, topic, jni_dw);
    }

    public int marshall(ByteBuffer out_stream, LoadReportTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            ++size;
            ++size;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            if (src.participantIp == null) {
                ++size;
            } else {
                try {
                    byte[] sbytes = src.participantIp.getBytes("UTF-8");
                    size += sbytes.length + 1;
                }
                catch (Exception e) {
                    ++size;
                }
            }
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsParticipantId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsParticipantId);
            ++offset;
            out_stream.put(src.participantType);
            ++offset;
            out_stream.put(src.cpuUsage);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.freeMemory);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.numberOfConnectedVehicles);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            if (src.participantIp == null) {
                out_stream.putInt(1);
            } else {
                try {
                    byte[] sbytes = src.participantIp.getBytes("UTF-8");
                    out_stream.putInt(sbytes.length + 1);
                    out_stream.put(sbytes);
                    offset += sbytes.length;
                }
                catch (Exception e) {
                    out_stream.putInt(1);
                }
            }
            out_stream.put((byte)0);
            offset += 5;
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_fixed_size() {
        return 0;
    }

    public int marshall_key(ByteBuffer out_stream, LoadReportTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsParticipantId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsParticipantId);
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_key_hash(ByteBuffer out_stream, LoadReportTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.BIG_ENDIAN);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsParticipantId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsParticipantId);
            size = out_stream.position();
        }
        return size;
    }

    public boolean key_must_hash() {
        return false;
    }

    public int unmarshall(LoadReportTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsParticipantId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsParticipantId = data.getLong();
            ++offset;
            t.participantType = data.get();
            ++offset;
            t.cpuUsage = data.get();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.freeMemory = data.getInt();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.numberOfConnectedVehicles = data.getInt();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            int slen = data.getInt() - 1;
            byte[] sbytes = new byte[slen];
            data.get(sbytes, 0, slen);
            data.get();
            try {
                t.participantIp = new String(sbytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                t.participantIp = new String();
            }
            offset += 4 + slen + 1;
        }
        return 1;
    }

    public int unmarshall_key(LoadReportTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsParticipantId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsParticipantId = data.getLong();
        }
        return 1;
    }

    public int unmarshall_key_hash(LoadReportTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.order(ByteOrder.BIG_ENDIAN);
        while ((offset & 7) != 0) {
            ++offset;
            data.position(data.position() + 1);
        }
        offset += 8;
        t.leastSignificantBitsParticipantId = data.getLong();
        while ((offset & 7) != 0) {
            ++offset;
            data.position(data.position() + 1);
        }
        offset += 8;
        t.mostSignificantBitsParticipantId = data.getLong();
        return 0;
    }

    public int gen_typecode(ByteBuffer b) {
        byte[] byArray = new byte[312];
        byArray[0] = 10;
        byArray[4] = 50;
        byArray[5] = 1;
        byArray[8] = 16;
        byArray[12] = 76;
        byArray[13] = 111;
        byArray[14] = 97;
        byArray[15] = 100;
        byArray[16] = 82;
        byArray[17] = 101;
        byArray[18] = 112;
        byArray[19] = 111;
        byArray[20] = 114;
        byArray[21] = 116;
        byArray[22] = 84;
        byArray[23] = 111;
        byArray[24] = 112;
        byArray[25] = 105;
        byArray[26] = 99;
        byArray[28] = 7;
        byArray[32] = 52;
        byArray[36] = 34;
        byArray[40] = 108;
        byArray[41] = 101;
        byArray[42] = 97;
        byArray[43] = 115;
        byArray[44] = 116;
        byArray[45] = 83;
        byArray[46] = 105;
        byArray[47] = 103;
        byArray[48] = 110;
        byArray[49] = 105;
        byArray[50] = 102;
        byArray[51] = 105;
        byArray[52] = 99;
        byArray[53] = 97;
        byArray[54] = 110;
        byArray[55] = 116;
        byArray[56] = 66;
        byArray[57] = 105;
        byArray[58] = 116;
        byArray[59] = 115;
        byArray[60] = 80;
        byArray[61] = 97;
        byArray[62] = 114;
        byArray[63] = 116;
        byArray[64] = 105;
        byArray[65] = 99;
        byArray[66] = 105;
        byArray[67] = 112;
        byArray[68] = 97;
        byArray[69] = 110;
        byArray[70] = 116;
        byArray[71] = 73;
        byArray[72] = 100;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = 1;
        byArray[80] = 17;
        byArray[86] = 50;
        byArray[88] = 33;
        byArray[92] = 109;
        byArray[93] = 111;
        byArray[94] = 115;
        byArray[95] = 116;
        byArray[96] = 83;
        byArray[97] = 105;
        byArray[98] = 103;
        byArray[99] = 110;
        byArray[100] = 105;
        byArray[101] = 102;
        byArray[102] = 105;
        byArray[103] = 99;
        byArray[104] = 97;
        byArray[105] = 110;
        byArray[106] = 116;
        byArray[107] = 66;
        byArray[108] = 105;
        byArray[109] = 116;
        byArray[110] = 115;
        byArray[111] = 80;
        byArray[112] = 97;
        byArray[113] = 114;
        byArray[114] = 116;
        byArray[115] = 105;
        byArray[116] = 99;
        byArray[117] = 105;
        byArray[118] = 112;
        byArray[119] = 97;
        byArray[120] = 110;
        byArray[121] = 116;
        byArray[122] = 73;
        byArray[123] = 100;
        byArray[126] = -1;
        byArray[127] = -1;
        byArray[128] = 1;
        byArray[132] = 17;
        byArray[138] = 34;
        byArray[140] = 16;
        byArray[144] = 112;
        byArray[145] = 97;
        byArray[146] = 114;
        byArray[147] = 116;
        byArray[148] = 105;
        byArray[149] = 99;
        byArray[150] = 105;
        byArray[151] = 112;
        byArray[152] = 97;
        byArray[153] = 110;
        byArray[154] = 116;
        byArray[155] = 84;
        byArray[156] = 121;
        byArray[157] = 112;
        byArray[158] = 101;
        byArray[162] = -1;
        byArray[163] = -1;
        byArray[168] = 9;
        byArray[174] = 26;
        byArray[176] = 9;
        byArray[180] = 99;
        byArray[181] = 112;
        byArray[182] = 117;
        byArray[183] = 85;
        byArray[184] = 115;
        byArray[185] = 97;
        byArray[186] = 103;
        byArray[187] = 101;
        byArray[190] = -1;
        byArray[191] = -1;
        byArray[196] = 9;
        byArray[202] = 26;
        byArray[204] = 11;
        byArray[208] = 102;
        byArray[209] = 114;
        byArray[210] = 101;
        byArray[211] = 101;
        byArray[212] = 77;
        byArray[213] = 101;
        byArray[214] = 109;
        byArray[215] = 111;
        byArray[216] = 114;
        byArray[217] = 121;
        byArray[220] = -1;
        byArray[221] = -1;
        byArray[224] = 2;
        byArray[230] = 42;
        byArray[232] = 26;
        byArray[236] = 110;
        byArray[237] = 117;
        byArray[238] = 109;
        byArray[239] = 98;
        byArray[240] = 101;
        byArray[241] = 114;
        byArray[242] = 79;
        byArray[243] = 102;
        byArray[244] = 67;
        byArray[245] = 111;
        byArray[246] = 110;
        byArray[247] = 110;
        byArray[248] = 101;
        byArray[249] = 99;
        byArray[250] = 116;
        byArray[251] = 101;
        byArray[252] = 100;
        byArray[253] = 86;
        byArray[254] = 101;
        byArray[255] = 104;
        byArray[256] = 105;
        byArray[257] = 99;
        byArray[258] = 108;
        byArray[259] = 101;
        byArray[260] = 115;
        byArray[264] = -1;
        byArray[265] = -1;
        byArray[268] = 2;
        byArray[274] = 36;
        byArray[276] = 14;
        byArray[280] = 112;
        byArray[281] = 97;
        byArray[282] = 114;
        byArray[283] = 116;
        byArray[284] = 105;
        byArray[285] = 99;
        byArray[286] = 105;
        byArray[287] = 112;
        byArray[288] = 97;
        byArray[289] = 110;
        byArray[290] = 116;
        byArray[291] = 73;
        byArray[292] = 112;
        byArray[296] = -1;
        byArray[297] = -1;
        byArray[300] = 13;
        byArray[304] = 6;
        byArray[308] = -1;
        byArray[309] = -1;
        byArray[310] = -1;
        byArray[311] = -1;
        byte[] tc_data = byArray;
        if (b != null) {
            b.put(tc_data, 0, tc_data.length);
        }
        return tc_data.length;
    }

    public int get_typecode_enc() {
        return 1;
    }

    public int get_encoding() {
        return 0;
    }

    public int get_decoding() {
        return 0;
    }

    public boolean has_key() {
        return true;
    }

    public LoadReportTopic alloc() {
        return new LoadReportTopic();
    }

    public void clear(LoadReportTopic instance) {
        instance.clear();
    }

    public void destroy(LoadReportTopic instance) {
    }

    public void copy(LoadReportTopic to, LoadReportTopic from) {
        to.copy(from);
    }

    public boolean get_field(String fieldname, CoreDX_FieldDef fdef) {
        return false;
    }
}

