/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.coredx.listener;

import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataReaderListener;
import com.toc.coredx.DDS.LivelinessChangedStatus;
import com.toc.coredx.DDS.RequestedDeadlineMissedStatus;
import com.toc.coredx.DDS.RequestedIncompatibleQosStatus;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SampleInfoSeq;
import com.toc.coredx.DDS.SampleLostStatus;
import com.toc.coredx.DDS.SampleRejectedStatus;
import com.toc.coredx.DDS.SubscriptionMatchedStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.listener.BaseDataReaderListener;
import lac.cnet.sddl.udi.core.listener.TopicSampleRunner;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;

public class CoreDXDataReaderListener<T>
extends BaseDataReaderListener<T>
implements DataReaderListener {
    protected Constructor<?> copyTopicConstructor = null;
    protected Method copyTopicMethod = null;

    public CoreDXDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener) {
        super(applicationDataReaderListener);
    }

    public CoreDXDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener, boolean useWrapper) {
        super(applicationDataReaderListener, useWrapper);
    }

    public CoreDXDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener, boolean useWrapper, int poolSize) {
        super(applicationDataReaderListener, useWrapper, poolSize);
    }

    @Override
    public long get_nil_mask() {
        return 0L;
    }

    protected void initializeComputationalReflectionVariables(DataReader dataReader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String topicClassName = this.getTopicTypeName(dataReader);
        Class<?> topicSeqClass = Class.forName(String.valueOf(topicClassName) + "Seq");
        this.topicSeqClassConstructor = topicSeqClass.getConstructor(new Class[0]);
        Object samples = this.topicSeqClassConstructor.newInstance(new Object[0]);
        this.takeMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeq.class, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
        this.returnLoanMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeq.class};
        this.takeDataReaderMethod = dataReader.getClass().getMethod("take", this.takeMethodParameterTypes);
        this.returnLoanDataReaderMethod = dataReader.getClass().getMethod("return_loan", this.returnLoanMethodParameterTypes);
        Class<?> topicClass = Class.forName(topicClassName);
        this.copyTopicConstructor = topicClass.getConstructor(new Class[0]);
        Object topicInstance = this.copyTopicConstructor.newInstance(new Object[0]);
        Class[] copyTopicMethodParameterTypes = new Class[]{topicInstance.getClass()};
        this.copyTopicMethod = topicInstance.getClass().getMethod("copy", copyTopicMethodParameterTypes);
    }

    protected String getTopicTypeName(DataReader dataReader) {
        String topicClassName = dataReader.getClass().getCanonicalName();
        int replacePosition = dataReader.getClass().getCanonicalName().length() - 10;
        topicClassName = topicClassName.substring(0, replacePosition);
        return topicClassName;
    }

    @Override
    public void on_data_available(DataReader dataReader) {
        Object[] topicSeqSamplesAndInfo = this.getTopicSeqSamplesAndInfo(dataReader);
        if (topicSeqSamplesAndInfo == null) {
            return;
        }
        Object topicSeq = topicSeqSamplesAndInfo[0];
        Object[] sampleArray = (Object[])topicSeqSamplesAndInfo[1];
        if (sampleArray != null) {
            SampleInfoSeq sampleInfo = (SampleInfoSeq)topicSeqSamplesAndInfo[2];
            int i = 0;
            while (i < sampleArray.length) {
                if (sampleInfo.value[i].valid_data) {
                    Object topicSample = this.useWrapper ? Utils.getApplicationObject(sampleArray[i]) : this.copyTopicSample(sampleArray[i]);
                    this.threadPool.execute(new TopicSampleRunner<Object>(topicSample, this.applicationDataReaderListener));
                }
                ++i;
            }
            this.returnLoan(dataReader, topicSeq, sampleInfo);
        }
    }

    protected void returnLoan(DataReader dataReader, Object samples, SampleInfoSeq sampleInfo) {
        try {
            ReturnCode_t ret = (ReturnCode_t)((Object)this.returnLoanDataReaderMethod.invoke((Object)dataReader, samples, sampleInfo));
            if (ret != ReturnCode_t.RETCODE_OK) {
                System.out.println("CoreDXDataReaderListener.returnLoan()");
                System.err.println("return_loan ERROR!");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected Object copyTopicSample(Object topicSample) {
        Object topicInstance = null;
        try {
            topicInstance = this.copyTopicConstructor.newInstance(new Object[0]);
            this.copyTopicMethod.invoke(topicInstance, topicSample);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return topicInstance;
    }

    protected Object[] getTopicSeqSamplesAndInfo(DataReader dataReader) {
        Object topicSeq = null;
        try {
            if (this.topicSeqClassConstructor == null) {
                this.initializeComputationalReflectionVariables(dataReader);
            }
            topicSeq = this.topicSeqClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        SampleInfoSeq sampleInfo = new SampleInfoSeq();
        ReturnCode_t returnCode = null;
        Object returnCodeObject = null;
        try {
            returnCodeObject = this.takeDataReaderMethod.invoke((Object)dataReader, topicSeq, sampleInfo, Integer.MAX_VALUE, 2, 255, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        returnCode = (ReturnCode_t)((Object)returnCodeObject);
        Object[] result = null;
        if (returnCode == ReturnCode_t.RETCODE_OK) {
            result = new Object[3];
            try {
                result[1] = topicSeq.getClass().getField("value").get(topicSeq);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            result[0] = topicSeq;
            result[2] = sampleInfo;
            return result;
        }
        return null;
    }

    @Override
    public void on_liveliness_changed(DataReader arg0, LivelinessChangedStatus arg1) {
    }

    @Override
    public void on_requested_deadline_missed(DataReader arg0, RequestedDeadlineMissedStatus arg1) {
    }

    @Override
    public void on_requested_incompatible_qos(DataReader arg0, RequestedIncompatibleQosStatus arg1) {
    }

    @Override
    public void on_sample_lost(DataReader arg0, SampleLostStatus arg1) {
    }

    @Override
    public void on_sample_rejected(DataReader arg0, SampleRejectedStatus arg1) {
    }

    @Override
    public void on_subscription_matched(DataReader arg0, SubscriptionMatchedStatus arg1) {
    }
}

