/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.rti;

import com.rti.dds.infrastructure.InstanceHandle_t;
import com.rti.dds.publication.DataWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RTIWriterField {
    private DataWriter dataWriter;
    private Method writeMethod;
    private Method registerInstanceMethod;

    public RTIWriterField(DataWriter dataWriter) {
        this.dataWriter = dataWriter;
        this.writeMethod = null;
        this.registerInstanceMethod = null;
    }

    protected void initializeComputationalReflexionFields(Object topic) throws SecurityException, NoSuchMethodException {
        Class[] writeMethodParameterTypes = new Class[]{topic.getClass(), InstanceHandle_t.class};
        this.writeMethod = this.dataWriter.getClass().getMethod("write", writeMethodParameterTypes);
        Class[] registerInstanceMethodParameterTypes = new Class[]{topic.getClass()};
        this.registerInstanceMethod = this.dataWriter.getClass().getMethod("register_instance", registerInstanceMethodParameterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTopic(Object topic) {
        try {
            if (this.writeMethod == null) {
                this.initializeComputationalReflexionFields(topic);
            }
            InstanceHandle_t instanceHandle_t = this.getInstanceHandle_t(topic);
            DataWriter dataWriter = this.dataWriter;
            synchronized (dataWriter) {
                this.writeMethod.invoke((Object)this.dataWriter, topic, instanceHandle_t);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public InstanceHandle_t getInstanceHandle_t(Object topic) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (InstanceHandle_t)this.registerInstanceMethod.invoke((Object)this.dataWriter, topic);
    }

    public DataWriter getDataWriter() {
        return this.dataWriter;
    }

    public void setDataWriter(DataWriter dataWriter) {
        this.dataWriter = dataWriter;
    }

    public Method getWriteMethod(Object topic) throws SecurityException, NoSuchMethodException {
        if (this.writeMethod != null) {
            this.initializeComputationalReflexionFields(topic);
        }
        return this.writeMethod;
    }

    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public Method getRegister_instanceMethod() {
        return this.registerInstanceMethod;
    }

    public void setRegisterInstanceMethod(Method registerInstanceMethod) {
        this.registerInstanceMethod = registerInstanceMethod;
    }
}

