/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.rti.listener;

import com.rti.dds.infrastructure.Copyable;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.subscription.LivelinessChangedStatus;
import com.rti.dds.subscription.RequestedDeadlineMissedStatus;
import com.rti.dds.subscription.RequestedIncompatibleQosStatus;
import com.rti.dds.subscription.SampleInfo;
import com.rti.dds.subscription.SampleInfoSeq;
import com.rti.dds.subscription.SampleLostStatus;
import com.rti.dds.subscription.SampleRejectedStatus;
import com.rti.dds.subscription.SubscriptionMatchedStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.listener.BaseDataReaderListener;
import lac.cnet.sddl.udi.core.listener.TopicSampleRunner;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;

public class RTIDataReaderListener<T>
extends BaseDataReaderListener<T>
implements DataReaderListener {
    protected Constructor<?> copyTopicConstructor;
    protected Method toArraySeqMethod;

    public RTIDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener) {
        super(applicationDataReaderListener);
    }

    public RTIDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener, boolean useWrapper) {
        super(applicationDataReaderListener, useWrapper);
        this.copyTopicConstructor = null;
        this.toArraySeqMethod = null;
    }

    protected void initializeComputationalReflectionVariables(DataReader dataReader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String topicClassName = this.getTopicTypeName(dataReader);
        Class<?> topicSeqClass = Class.forName(String.valueOf(topicClassName) + "Seq");
        this.topicSeqClassConstructor = topicSeqClass.getConstructor(new Class[0]);
        this.toArraySeqMethod = topicSeqClass.getMethod("toArray", new Class[0]);
        Object samples = this.topicSeqClassConstructor.newInstance(new Object[0]);
        this.takeMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeq.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        this.returnLoanMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeq.class};
        this.takeDataReaderMethod = dataReader.getClass().getMethod("take", this.takeMethodParameterTypes);
        this.returnLoanDataReaderMethod = dataReader.getClass().getMethod("return_loan", this.returnLoanMethodParameterTypes);
        Class<?> topicClass = Class.forName(topicClassName);
        this.copyTopicConstructor = topicClass.getConstructor(new Class[0]);
    }

    protected String getTopicTypeName(DataReader dataReader) {
        String topicClassName = dataReader.getClass().getCanonicalName();
        int replacePosition = dataReader.getClass().getCanonicalName().length() - 10;
        topicClassName = topicClassName.substring(0, replacePosition);
        return topicClassName;
    }

    @Override
    public void on_data_available(DataReader dataReader) {
        Object[] topicSeqSamplesAndInfo = this.getTopicSeqSamplesAndInfo(dataReader);
        if (topicSeqSamplesAndInfo == null) {
            return;
        }
        Object topicSeq = topicSeqSamplesAndInfo[0];
        Object[] sampleArray = (Object[])topicSeqSamplesAndInfo[1];
        if (sampleArray != null) {
            SampleInfoSeq sampleInfo = (SampleInfoSeq)topicSeqSamplesAndInfo[2];
            int i = 0;
            while (i < sampleArray.length) {
                if (((SampleInfo)sampleInfo.get((int)i)).valid_data) {
                    Object topicSample = this.useWrapper ? Utils.getApplicationObject(sampleArray[i]) : this.copyTopicSample(sampleArray[i]);
                    this.threadPool.execute(new TopicSampleRunner<Object>(topicSample, this.applicationDataReaderListener));
                }
                ++i;
            }
            this.returnLoan(dataReader, topicSeq, sampleInfo);
        }
    }

    protected void returnLoan(DataReader dataReader, Object samples, SampleInfoSeq sampleInfo) {
        try {
            this.returnLoanDataReaderMethod.invoke((Object)dataReader, samples, sampleInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object copyTopicSample(Object topicSample) {
        Object topicInstance = null;
        try {
            topicInstance = this.copyTopicConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Copyable copyableTopicInstance = topicInstance;
        copyableTopicInstance.copy_from(topicSample);
        return topicInstance;
    }

    protected Object[] getTopicSeqSamplesAndInfo(DataReader dataReader) {
        Object topicSeq = null;
        try {
            if (this.topicSeqClassConstructor == null) {
                this.initializeComputationalReflectionVariables(dataReader);
            }
            topicSeq = this.topicSeqClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        SampleInfoSeq sampleInfo = new SampleInfoSeq();
        try {
            this.takeDataReaderMethod.invoke((Object)dataReader, topicSeq, sampleInfo, -1, 2, 65535, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Object[] result = null;
        result = new Object[3];
        try {
            result[1] = this.toArraySeqMethod.invoke(topicSeq, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        result[0] = topicSeq;
        result[2] = sampleInfo;
        return result;
    }

    @Override
    public void on_liveliness_changed(DataReader arg0, LivelinessChangedStatus arg1) {
    }

    @Override
    public void on_requested_deadline_missed(DataReader arg0, RequestedDeadlineMissedStatus arg1) {
    }

    @Override
    public void on_requested_incompatible_qos(DataReader arg0, RequestedIncompatibleQosStatus arg1) {
    }

    @Override
    public void on_sample_lost(DataReader arg0, SampleLostStatus arg1) {
    }

    @Override
    public void on_sample_rejected(DataReader arg0, SampleRejectedStatus arg1) {
    }

    @Override
    public void on_subscription_matched(DataReader arg0, SubscriptionMatchedStatus arg1) {
    }
}

