/*
 * Decompiled with CFR 0.152.
 */
package lac.contextnet.highlyscalableset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockSet<V>
implements Set<V> {
    private final ReentrantReadWriteLock lock;
    private final Set<V> set;

    public ReadWriteLockSet() {
        this.set = new TreeSet<V>();
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteLockSet(boolean treeSet, boolean fairReadWriteLock) {
        this.set = treeSet ? new TreeSet<V>() : new HashSet<V>();
        this.lock = new ReentrantReadWriteLock(fairReadWriteLock);
    }

    public ReadWriteLockSet(boolean fairReadWriteLock, int initialHashCapacity) {
        this.set = new HashSet<V>(initialHashCapacity);
        this.lock = new ReentrantReadWriteLock(fairReadWriteLock);
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.set.clear();
        this.lock.writeLock().unlock();
    }

    @Override
    public boolean add(V arg0) {
        this.lock.writeLock().lock();
        boolean result = this.set.add(arg0);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends V> arg0) {
        this.lock.writeLock().lock();
        boolean result = this.set.addAll(arg0);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean contains(Object arg0) {
        this.lock.readLock().lock();
        boolean result = this.set.contains(arg0);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.lock.readLock().lock();
        boolean result = this.set.containsAll(arg0);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        boolean result = this.set.isEmpty();
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public Iterator<V> iterator() {
        this.lock.readLock().lock();
        ArrayList<V> objects = new ArrayList<V>(this.set.size());
        for (V obj : this.set) {
            objects.add(obj);
        }
        this.lock.readLock().unlock();
        return objects.iterator();
    }

    @Override
    public boolean remove(Object object) {
        this.lock.writeLock().lock();
        boolean result = this.set.remove(object);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        this.lock.writeLock().lock();
        boolean result = this.set.removeAll(objects);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        this.lock.writeLock().lock();
        boolean result = this.set.retainAll(objects);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = null;
        this.lock.readLock().lock();
        array = this.set.toArray();
        this.lock.readLock().unlock();
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] array = null;
        this.lock.readLock().lock();
        array = this.set.toArray(a);
        this.lock.readLock().unlock();
        return array;
    }
}

