/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.rudp.AsyncScheduler;
import net.rudp.ReliableSocket;
import net.rudp.ReliableSocketProfile;
import net.rudp.ReliableSocketStateListener;
import net.rudp.impl.SYNSegment;
import net.rudp.impl.Segment;
import net.rudp.impl.UIDSegment;

public class ReliableServerSocket
extends ServerSocket {
    public static final Logger LOGGER = Logger.getLogger(ReliableServerSocket.class.getCanonicalName());
    public ReceiverThread receiverThread;
    private DatagramChannel _recvChannel;
    private ReliableSocketProfile _profile;
    private int _timeout;
    private int _backlogSize;
    private boolean _closed;
    private final ArrayList<ReliableSocket> _backlog;
    private final HashMap<SocketAddress, ReliableClientSocket> _clientSockTable;
    private final TreeMap<UUID, SocketAddress> _uuidSockTable;
    private final ReliableSocketStateListener _stateListener;
    private static ExecutorService _recvSegmentPool;
    private static final int DEFAULT_BACKLOG_SIZE = 500;

    public ReliableServerSocket() throws IOException {
        this(0, 0, null, new ReliableSocketProfile());
    }

    public ReliableServerSocket(int port) throws IOException {
        this(port, 0, null, new ReliableSocketProfile());
    }

    public ReliableServerSocket(int port, ReliableSocketProfile profile) throws IOException {
        this(port, 0, null, profile);
    }

    public ReliableServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null, new ReliableSocketProfile());
    }

    public ReliableServerSocket(int port, int backlog, InetAddress bindAddr, ReliableSocketProfile profile) throws IOException {
        InetSocketAddress address = new InetSocketAddress(bindAddr, port);
        this._recvChannel = DatagramChannel.open();
        this._recvChannel.socket().bind(address);
        this._profile = profile;
        this._backlogSize = backlog <= 0 ? 500 : backlog;
        this._backlog = new ArrayList(this._backlogSize);
        this._clientSockTable = new HashMap();
        this._uuidSockTable = new TreeMap();
        this._stateListener = new StateListener();
        this._timeout = 0;
        this._closed = false;
        if (_recvSegmentPool == null) {
            _recvSegmentPool = Executors.newFixedThreadPool(32, new AsyncScheduler.ScheduleFactory("Receive-Segment"));
            ReliableSocket._threadPool.setCorePoolSize(10);
        }
        this.receiverThread = new ReceiverThread();
        this.receiverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        ArrayList<ReliableSocket> arrayList = this._backlog;
        synchronized (arrayList) {
            while (this._backlog.isEmpty()) {
                try {
                    if (this._timeout == 0) {
                        this._backlog.wait();
                    } else {
                        long startTime = System.currentTimeMillis();
                        this._backlog.wait(this._timeout);
                        if (System.currentTimeMillis() - startTime >= (long)this._timeout) {
                            throw new SocketTimeoutException();
                        }
                    }
                }
                catch (InterruptedException xcp) {
                    throw new InterruptedIOException();
                }
                if (!this.isClosed()) continue;
                throw new IOException();
            }
            return this._backlog.remove(0);
        }
    }

    @Override
    public synchronized void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 0);
    }

    @Override
    public synchronized void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this._recvChannel.socket().bind(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.receiverThread.interrupt();
        this._closed = true;
        Cloneable cloneable = this._backlog;
        synchronized (cloneable) {
            this._backlog.clear();
            this._backlog.notify();
        }
        if (this._clientSockTable.isEmpty()) {
            this._recvChannel.socket().close();
        }
        cloneable = this._uuidSockTable;
        synchronized (cloneable) {
            this._uuidSockTable.clear();
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this._recvChannel.socket().getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this._recvChannel.socket().getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this._recvChannel.socket().getLocalSocketAddress();
    }

    @Override
    public boolean isBound() {
        return this._recvChannel.socket().isBound();
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void setSoTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this._timeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this._timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReliableClientSocket addClientSocket(SocketAddress endpoint) {
        HashMap<SocketAddress, ReliableClientSocket> hashMap = this._clientSockTable;
        synchronized (hashMap) {
            ReliableClientSocket sock = this._clientSockTable.get(endpoint);
            if (sock == null) {
                try {
                    sock = new ReliableClientSocket(this._recvChannel, endpoint, this._profile);
                    sock.addStateListener(this._stateListener);
                    this._clientSockTable.put(endpoint, sock);
                }
                catch (IOException xcp) {
                    xcp.printStackTrace();
                }
            }
            return sock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress addUuidEndpoint(UUID uuid, SocketAddress endpoint) {
        TreeMap<UUID, SocketAddress> treeMap = this._uuidSockTable;
        synchronized (treeMap) {
            this._uuidSockTable.put(uuid, endpoint);
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReliableClientSocket removeClientSocket(SocketAddress endpoint) {
        AbstractMap abstractMap = this._uuidSockTable;
        synchronized (abstractMap) {
            this._uuidSockTable.values().remove(endpoint);
        }
        abstractMap = this._clientSockTable;
        synchronized (abstractMap) {
            ReliableClientSocket sock = this._clientSockTable.remove(endpoint);
            if (this._clientSockTable.isEmpty() && this.isClosed()) {
                this._recvChannel.socket().close();
            }
            return sock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasClientSocket(SocketAddress endpoint) {
        HashMap<SocketAddress, ReliableClientSocket> hashMap = this._clientSockTable;
        synchronized (hashMap) {
            return this._clientSockTable.containsKey(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUuidClient(UUID uuid) {
        TreeMap<UUID, SocketAddress> treeMap = this._uuidSockTable;
        synchronized (treeMap) {
            return this._uuidSockTable.containsKey(uuid);
        }
    }

    private class ProcessSegmentTask
    implements Runnable {
        private Segment segment;
        private SocketAddress clientEndpoint;

        public ProcessSegmentTask(Segment segment, SocketAddress clientEndpoint) {
            this.segment = segment;
            this.clientEndpoint = clientEndpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractMap abstractMap;
            UUID uuid = null;
            ReliableClientSocket sock = null;
            SocketAddress oldEndpoint = null;
            if (this.segment instanceof UIDSegment) {
                uuid = ((UIDSegment)this.segment).getUUID();
                abstractMap = ReliableServerSocket.this._uuidSockTable;
                synchronized (abstractMap) {
                    if (ReliableServerSocket.this._uuidSockTable.containsKey(uuid)) {
                        oldEndpoint = (SocketAddress)ReliableServerSocket.this._uuidSockTable.get(uuid);
                        if (!oldEndpoint.equals(this.clientEndpoint)) {
                            LOGGER.fine("processing UIDSegment from different endpoint, updating");
                            ReliableServerSocket.this._uuidSockTable.remove(uuid);
                            ReliableServerSocket.this._uuidSockTable.put(uuid, this.clientEndpoint);
                            HashMap hashMap = ReliableServerSocket.this._clientSockTable;
                            synchronized (hashMap) {
                                ReliableClientSocket oldSock = (ReliableClientSocket)ReliableServerSocket.this._clientSockTable.get(oldEndpoint);
                                if (oldSock != null) {
                                    ReliableServerSocket.this._clientSockTable.remove(oldEndpoint);
                                    oldSock.setEndpoint(this.clientEndpoint);
                                    ReliableServerSocket.this._clientSockTable.put(this.clientEndpoint, oldSock);
                                }
                            }
                        } else {
                            LOGGER.fine("ignored UIDSegment from same endpoint");
                        }
                    } else {
                        ReliableServerSocket.this._uuidSockTable.put(uuid, this.clientEndpoint);
                    }
                }
            }
            abstractMap = ReliableServerSocket.this._clientSockTable;
            synchronized (abstractMap) {
                if (this.segment instanceof SYNSegment && !ReliableServerSocket.this._clientSockTable.containsKey(this.clientEndpoint)) {
                    sock = ReliableServerSocket.this.addClientSocket(this.clientEndpoint);
                }
                sock = (ReliableClientSocket)ReliableServerSocket.this._clientSockTable.get(this.clientEndpoint);
            }
            if (sock != null) {
                sock.segmentReceived(this.segment);
            } else {
                LOGGER.warning("drop " + this.segment);
            }
        }
    }

    private class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            super("ReliableServerSocket");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(65535);
            Segment segment = null;
            Object uuid = null;
            SocketAddress clientEndpoint = null;
            Object processSegmentTask = null;
            while (!ReliableServerSocket.this._closed) {
                block6: {
                    clientEndpoint = ReliableServerSocket.this._recvChannel.receive(buffer);
                    if (clientEndpoint != null) break block6;
                    buffer.clear();
                    continue;
                }
                try {
                    try {
                        buffer.flip();
                        segment = Segment.parse(buffer.array(), 0, buffer.limit());
                        _recvSegmentPool.submit(new ProcessSegmentTask(segment, clientEndpoint));
                    }
                    catch (Exception ex) {
                        LOGGER.warning("Error on receiving and parsing PKG");
                        buffer.clear();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    buffer.clear();
                    throw throwable;
                }
                buffer.clear();
            }
        }
    }

    private class ReliableClientSocket
    extends ReliableSocket {
        public ReliableClientSocket(DatagramChannel channel, SocketAddress endpoint, ReliableSocketProfile profile) throws IOException {
            super(channel, profile);
            this._endpoint = endpoint;
        }

        public void setEndpoint(SocketAddress endpoint) {
            this._endpoint = endpoint;
        }

        protected void segmentReceived(Segment segment) {
            this.scheduleReceive(segment);
        }

        @Override
        protected void log(String msg) {
            LOGGER.fine(String.valueOf(this.getPort()) + ": " + msg);
        }

        @Override
        protected void closeSocket() {
        }
    }

    private class StateListener
    implements ReliableSocketStateListener {
        private StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void connectionOpened(ReliableSocket sock) {
            if (!(sock instanceof ReliableClientSocket)) return;
            ArrayList arrayList = ReliableServerSocket.this._backlog;
            synchronized (arrayList) {
                while (true) {
                    if (ReliableServerSocket.this._backlog.size() <= 500) {
                        ReliableServerSocket.this._backlog.add(sock);
                        ReliableServerSocket.this._backlog.notify();
                        return;
                    }
                    try {
                        ReliableServerSocket.this._backlog.wait();
                    }
                    catch (InterruptedException xcp) {
                        xcp.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void connectionRefused(ReliableSocket sock) {
        }

        @Override
        public void connectionClosed(ReliableSocket sock) {
            if (sock instanceof ReliableClientSocket) {
                ReliableServerSocket.this.removeClientSocket(sock._endpoint);
            }
        }

        @Override
        public void connectionFailure(ReliableSocket sock) {
            if (sock instanceof ReliableClientSocket) {
                ReliableServerSocket.this.removeClientSocket(sock._endpoint);
            }
        }

        @Override
        public void connectionReset(ReliableSocket sock) {
        }
    }
}

