/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.ptql.ProcessQueryFactory;

public abstract class SigarTestCase
extends TestCase {
    private static Sigar sigar = null;
    private Properties props = new Properties();
    private static boolean verbose = "true".equals(System.getProperty("sigar.testVerbose"));
    protected static final boolean JDK_14_COMPAT = System.getProperty("java.specification.version").compareTo("1.4") >= 0;
    private static PrintStream out = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SigarTestCase(String name) {
        super(name);
        File f = new File(System.getProperty("user.home"), ".sigar.properties");
        if (f.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                this.props.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public Sigar getSigar() {
        if (sigar == null) {
            sigar = new Sigar();
            if (SigarTestCase.getVerbose()) {
                sigar.enableLogging(true);
            }
        }
        return sigar;
    }

    public static void closeSigar() {
        if (sigar != null) {
            sigar.close();
            sigar = null;
        }
        ProcessQueryFactory.getInstance().clear();
        Humidor.getInstance().close();
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key, String val) {
        return this.getProperties().getProperty(key, val);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public static void setVerbose(boolean value) {
        verbose = value;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setWriter(PrintStream value) {
        out = value;
    }

    public static PrintStream getWriter() {
        return out;
    }

    public long getInvalidPid() {
        return 666666L;
    }

    public void traceln(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().println(msg);
        }
    }

    public void trace(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().print(msg);
        }
    }

    public void assertTrueTrace(String msg, String value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue(msg, value != null);
    }

    public void assertLengthTrace(String msg, String value) {
        this.assertTrueTrace(msg, value);
        SigarTestCase.assertTrue(msg, value.length() > 0);
    }

    public void assertIndexOfTrace(String msg, String value, String substr) {
        this.assertTrueTrace(msg, value);
        SigarTestCase.assertTrue(msg, value.indexOf(substr) != -1);
    }

    public void assertGtZeroTrace(String msg, long value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue(msg, value > 0L);
    }

    public void assertGtEqZeroTrace(String msg, long value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue(msg, value >= 0L);
    }

    public void assertValidFieldTrace(String msg, long value) {
        if (value != -1L) {
            this.assertGtEqZeroTrace(msg, value);
        }
    }

    public void assertEqualsTrace(String msg, long expected, long actual) {
        this.traceln(msg + "=" + actual + "/" + expected);
        SigarTestCase.assertEquals(msg, expected, actual);
    }

    public void traceMethods(Object obj) throws Exception {
        Class<?> cls = obj.getClass();
        Method[] methods = cls.getDeclaredMethods();
        this.traceln("");
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            Object val = methods[i].invoke(obj, new Object[0]);
            if (val instanceof Long && (Long)val == -1L) {
                val = "NOTIMPL";
            }
            this.traceln(name + "=" + val);
        }
    }
}

