/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.Domain;
import DDS.DomainParticipant;
import DDS.DomainParticipantFactoryInterface;
import DDS.DomainParticipantFactoryQos;
import DDS.DomainParticipantFactoryQosHolder;
import DDS.DomainParticipantListener;
import DDS.DomainParticipantQos;
import DDS.DomainParticipantQosHolder;
import DDS.ParticipantBuiltinTopicDataTypeSupport;
import DDS.PublicationBuiltinTopicDataTypeSupport;
import DDS.SubscriptionBuiltinTopicDataTypeSupport;
import DDS.TopicBuiltinTopicDataTypeSupport;
import org.opensplice.dds.dcps.DomainParticipantFactoryBase;
import org.opensplice.dds.dcps.DomainParticipantImpl;
import org.opensplice.dds.dcps.OSPLShutdown;

public class DomainParticipantFactoryImpl
extends DomainParticipantFactoryBase
implements DomainParticipantFactoryInterface {
    public static DomainParticipantFactoryImpl get_instance() {
        DomainParticipantFactoryImpl domainParticipantFactoryImpl = null;
        try {
            System.loadLibrary("dcpssaj");
            domainParticipantFactoryImpl = DomainParticipantFactoryImpl.jniGetInstance();
            OSPLShutdown oSPLShutdown = new OSPLShutdown();
            Runtime.getRuntime().addShutdownHook(oSPLShutdown);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("org.opensplice.dds.dcps.DomainParticipantFactoryImpl.get_instance() failed: " + unsatisfiedLinkError.getMessage());
        }
        return domainParticipantFactoryImpl;
    }

    @Override
    public DomainParticipant create_participant(int n, DomainParticipantQos domainParticipantQos, DomainParticipantListener domainParticipantListener, int n2) {
        DomainParticipantImpl domainParticipantImpl = this.jniCreateParticipant(n, domainParticipantQos, domainParticipantListener, n2);
        if (domainParticipantImpl != null) {
            boolean bl = false;
            ParticipantBuiltinTopicDataTypeSupport participantBuiltinTopicDataTypeSupport = new ParticipantBuiltinTopicDataTypeSupport();
            int n3 = participantBuiltinTopicDataTypeSupport.register_type(domainParticipantImpl, "DDS::ParticipantBuiltinTopicData");
            domainParticipantImpl.setParticipantDataCopyCache(participantBuiltinTopicDataTypeSupport.get_copyCache());
            if (n3 == 0) {
                SubscriptionBuiltinTopicDataTypeSupport subscriptionBuiltinTopicDataTypeSupport;
                PublicationBuiltinTopicDataTypeSupport publicationBuiltinTopicDataTypeSupport;
                TopicBuiltinTopicDataTypeSupport topicBuiltinTopicDataTypeSupport = new TopicBuiltinTopicDataTypeSupport();
                n3 = topicBuiltinTopicDataTypeSupport.register_type(domainParticipantImpl, "DDS::TopicBuiltinTopicData");
                domainParticipantImpl.setTopicBuiltinTopicDataCopyCache(topicBuiltinTopicDataTypeSupport.get_copyCache());
                if (n3 == 0 && (n3 = (publicationBuiltinTopicDataTypeSupport = new PublicationBuiltinTopicDataTypeSupport()).register_type(domainParticipantImpl, "DDS::PublicationBuiltinTopicData")) == 0 && (n3 = (subscriptionBuiltinTopicDataTypeSupport = new SubscriptionBuiltinTopicDataTypeSupport()).register_type(domainParticipantImpl, "DDS::SubscriptionBuiltinTopicData")) == 0) {
                    bl = true;
                }
            }
            if (!bl) {
                this.delete_participant(domainParticipantImpl);
                domainParticipantImpl = null;
            }
        }
        return domainParticipantImpl;
    }

    @Override
    public int delete_participant(DomainParticipant domainParticipant) {
        return this.jniDeleteParticipant(domainParticipant);
    }

    @Override
    public DomainParticipant lookup_participant(int n) {
        return this.jniLookupParticipant(n);
    }

    @Override
    public int set_default_participant_qos(DomainParticipantQos domainParticipantQos) {
        return this.jniSetDefaultParticipantQos(domainParticipantQos);
    }

    @Override
    public int get_default_participant_qos(DomainParticipantQosHolder domainParticipantQosHolder) {
        return this.jniGetDefaultParticipantQos(domainParticipantQosHolder);
    }

    @Override
    public int set_qos(DomainParticipantFactoryQos domainParticipantFactoryQos) {
        return this.jniSetQos(domainParticipantFactoryQos);
    }

    @Override
    public int get_qos(DomainParticipantFactoryQosHolder domainParticipantFactoryQosHolder) {
        return this.jniGetQos(domainParticipantFactoryQosHolder);
    }

    @Override
    public Domain lookup_domain(int n) {
        return this.jniLookupDomain(n);
    }

    @Override
    public int delete_domain(Domain domain) {
        return this.jniDeleteDomain(domain);
    }

    @Override
    public int delete_contained_entities() {
        return this.jniDeleteContainedEntities();
    }

    private static native DomainParticipantFactoryImpl jniGetInstance();

    private native DomainParticipantImpl jniCreateParticipant(int var1, DomainParticipantQos var2, DomainParticipantListener var3, int var4);

    private native int jniDeleteParticipant(DomainParticipant var1);

    private native DomainParticipant jniLookupParticipant(int var1);

    private native int jniSetDefaultParticipantQos(DomainParticipantQos var1);

    private native int jniGetDefaultParticipantQos(DomainParticipantQosHolder var1);

    private native int jniSetQos(DomainParticipantFactoryQos var1);

    private native int jniGetQos(DomainParticipantFactoryQosHolder var1);

    private native Domain jniLookupDomain(int var1);

    private native int jniDeleteDomain(Domain var1);

    private native int jniDeleteContainedEntities();
}

