/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.groups;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.extension.ExtendedMessageListener;
import lac.cnclib.net.groups.Group;
import lac.cnclib.net.groups.GroupMembershipListener;
import lac.cnclib.net.groups.message.GroupMembershipOperation;
import lac.cnclib.net.groups.message.GroupMembershipStatusData;
import lac.cnclib.net.groups.message.GroupMessage;
import lac.cnclib.net.groups.message.GroupcastMessage;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;

public class GroupCommunicationManager {
    protected NodeConnection nodeConnection;
    protected GroupMessageListener advancedListener;
    protected List<GroupMembershipListener> groupMembershipListeners;
    protected List<Group> implicitGroups;
    protected List<Group> explicitGroups;

    public GroupCommunicationManager(NodeConnection nodeConnection) {
        this.nodeConnection = nodeConnection;
        this.groupMembershipListeners = new ArrayList<GroupMembershipListener>();
        this.implicitGroups = new ArrayList<Group>();
        this.explicitGroups = new ArrayList<Group>();
        this.advancedListener = new GroupMessageListener();
        nodeConnection.addExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.GROUPCAST);
        nodeConnection.addExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
        nodeConnection.addNodeConnectionListener(this.advancedListener);
    }

    public void finalize() {
        this.groupMembershipListeners.clear();
        this.nodeConnection.removeExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.GROUPCAST);
        this.nodeConnection.removeExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
    }

    public void sendGroupcastMessage(ApplicationMessage message, Group group) throws IOException {
        this.sendGroupcastMessage(message, Arrays.asList(group));
    }

    public void sendGroupcastMessage(ApplicationMessage message, Group group, ClientLibProtocol.MSGType type) throws IOException {
        GroupcastMessage groupcastMessage = new GroupcastMessage((Serializable)message, group);
        this.sendGroupMessage(groupcastMessage, type);
    }

    public void sendGroupcastMessage(ApplicationMessage message, List<Group> groups) throws IOException {
        GroupcastMessage groupcastMessage = new GroupcastMessage((Serializable)message, groups);
        this.sendGroupMessage(groupcastMessage, ClientLibProtocol.MSGType.GROUPCAST);
    }

    public List<Group> getJoinedGroups() {
        Group[] groups = new Group[this.explicitGroups.size()];
        this.explicitGroups.toArray(groups);
        return Arrays.asList(groups);
    }

    public List<Group> getAllGroups() {
        Group[] iGroups = new Group[this.implicitGroups.size()];
        this.implicitGroups.toArray(iGroups);
        Group[] eGroups = new Group[this.explicitGroups.size()];
        this.explicitGroups.toArray(eGroups);
        Group[] allGroups = new Group[iGroups.length + eGroups.length];
        System.arraycopy(iGroups, 0, allGroups, 0, iGroups.length);
        System.arraycopy(eGroups, 0, allGroups, iGroups.length, eGroups.length);
        return Arrays.asList(allGroups);
    }

    public void joinGroup(Group group) throws IOException {
        this.joinGroup(Arrays.asList(group));
    }

    public void joinGroup(List<Group> groups) throws IOException {
        this.explicitGroups.addAll(groups);
        GroupMembershipOperation groupOperation = new GroupMembershipOperation(groups, null);
        this.sendGroupMessage(groupOperation, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
    }

    private void sendExplicitGroupsSubscription() throws IOException {
        GroupMembershipOperation groupOperation = new GroupMembershipOperation(this.explicitGroups, null);
        this.sendGroupMessage(groupOperation, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
    }

    public void leaveGroup(Group group) throws IOException {
        this.leaveGroup(Arrays.asList(group));
    }

    public void leaveGroup(List<Group> groups) throws IOException {
        this.explicitGroups.removeAll(groups);
        GroupMembershipOperation groupOperation = new GroupMembershipOperation(null, groups);
        this.sendGroupMessage(groupOperation, ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
    }

    private void sendGroupMessage(Serializable messageContent, ClientLibProtocol.MSGType type) throws IOException {
        GroupMessage groupMessage = new GroupMessage();
        groupMessage.setType(type);
        groupMessage.setContentObject(messageContent);
        groupMessage.setSenderID(this.nodeConnection.getUuid());
        groupMessage.setTagList(new ArrayList<String>());
        groupMessage.addTag("_groupAPI");
        this.nodeConnection.sendMessage(groupMessage);
    }

    public void addMembershipListener(GroupMembershipListener groupMembershipListener) {
        this.groupMembershipListeners.add(groupMembershipListener);
    }

    public void removeMembershipListener(GroupMembershipListener groupMembershipListener) {
        this.groupMembershipListeners.remove(groupMembershipListener);
    }

    protected class GroupMessageListener
    implements ExtendedMessageListener,
    NodeConnectionListener {
        protected GroupMessageListener() {
        }

        @Override
        public void newProtocolMessageReceived(NodeConnection remoteCon, Message message) {
            switch (message.getType()) {
                case GROUPMEMBERSHIP: {
                    GroupMembershipStatusData groupStatusData = (GroupMembershipStatusData)message.getContentObject();
                    for (GroupMembershipListener listener : GroupCommunicationManager.this.groupMembershipListeners) {
                        if (groupStatusData.getLeftGroup().size() > 0) {
                            GroupCommunicationManager.this.implicitGroups.removeAll(groupStatusData.getLeftGroup());
                            listener.leavingGroups(groupStatusData.getLeftGroup());
                        }
                        if (groupStatusData.getJoinedGroup().size() <= 0) continue;
                        GroupCommunicationManager.this.implicitGroups.addAll(groupStatusData.getJoinedGroup());
                        listener.enteringGroups(groupStatusData.getJoinedGroup());
                    }
                    break;
                }
            }
        }

        @Override
        public void connected(NodeConnection remoteCon) {
            GroupCommunicationManager.this.implicitGroups.clear();
        }

        @Override
        public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
            GroupCommunicationManager.this.implicitGroups.clear();
            if (wasHandover) {
                try {
                    GroupCommunicationManager.this.sendExplicitGroupsSubscription();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void disconnected(NodeConnection remoteCon) {
            GroupCommunicationManager.this.implicitGroups.clear();
        }

        @Override
        public void newMessageReceived(NodeConnection remoteCon, Message message) {
        }

        @Override
        public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        }

        @Override
        public void internalException(NodeConnection remoteCon, Exception e) {
        }
    }
}

