/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.mrudp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionReliableSocketProfile;
import net.rudp.ReliableServerSocket;
import net.rudp.ReliableSocket;
import net.rudp.ReliableSocketProfile;

public class MrUdpNodeConnectionServer {
    private ReliableServerSocket serverSocket;
    private ServerThread serverThread;
    private List<NodeConnectionServerListener> listener;
    private ReliableSocketProfile profile;

    public MrUdpNodeConnectionServer(int port) throws IOException {
        this(port, new MrUdpNodeConnectionReliableSocketProfile());
    }

    public MrUdpNodeConnectionServer(int port, ReliableSocketProfile profile) throws IOException {
        this.serverSocket = new ReliableServerSocket(port, profile);
        this.serverThread = null;
        this.listener = new ArrayList<NodeConnectionServerListener>();
        this.profile = profile;
    }

    private MrUdpNodeConnection getNextNodeConnection() throws IOException {
        if (this.profile == null) {
            this.profile = new MrUdpNodeConnectionReliableSocketProfile();
        }
        return new MrUdpNodeConnection((ReliableSocket)this.serverSocket.accept(), this.profile);
    }

    public void start() {
        if (this.serverThread != null) {
            throw new IllegalStateException("Already started.");
        }
        this.serverThread = new ServerThread();
        this.serverThread.start();
    }

    public void close() {
        this.serverThread.interrupt();
        this.serverThread = null;
    }

    public void restart() {
        this.start();
    }

    public void addListener(NodeConnectionServerListener lis) {
        this.listener.add(lis);
    }

    public void removeListener(NodeConnectionServerListener lis) {
        this.listener.remove(lis);
    }

    private class ServerThread
    extends Thread {
        private ServerThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        MrUdpNodeConnection remCon = MrUdpNodeConnectionServer.this.getNextNodeConnection();
                        Iterator iterator = MrUdpNodeConnectionServer.this.listener.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            NodeConnectionServerListener lis = (NodeConnectionServerListener)iterator.next();
                            lis.newNodeConnection(remCon);
                        }
                        break;
                    }
                }
                catch (InterruptedIOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

