/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.pubsub;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lac.cnclib.net.pubsub.Information;

public class InformationData
extends Information
implements Serializable {
    private UUID originUuid;
    private Map<String, String> information;
    private Map<String, String> properties;

    public InformationData(UUID originUuid, String informationClass) {
        super(informationClass);
        this.originUuid = originUuid;
        this.information = new HashMap<String, String>();
        this.properties = new HashMap<String, String>();
        this.addProperty("creationTime", String.valueOf(System.currentTimeMillis()));
    }

    public InformationData(UUID originUuid, String informationClass, String mainValue) {
        this(originUuid, informationClass);
        this.addInformation("main", mainValue);
    }

    public InformationData(String informationClass) {
        this((UUID)null, informationClass);
    }

    public InformationData(String informationClass, String mainValue) {
        this(null, informationClass, mainValue);
    }

    public void setOriginUuid(UUID originUuid) {
        this.originUuid = originUuid;
    }

    public UUID getOriginUuid() {
        return this.originUuid;
    }

    public void addInformation(String information, String value) {
        this.information.put(information, value);
    }

    public String getInformation(String information) {
        return this.information.get(information);
    }

    public String getMainInformation() {
        return this.information.get("main");
    }

    public boolean containsInformation(String information) {
        return this.information.containsKey(information);
    }

    public String[] getInformationsProvided() {
        String[] informations = new String[this.information.size()];
        this.information.keySet().toArray(informations);
        return informations;
    }

    public void addProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public boolean containsProperty(String property) {
        return this.properties.containsKey(property);
    }

    public String[] getPropertiesProvided() {
        String[] properties = new String[this.properties.size()];
        this.properties.keySet().toArray(properties);
        return properties;
    }

    @Override
    public boolean equals(Object otherObj) {
        InformationData other = (InformationData)otherObj;
        return super.equals(otherObj) && this.originUuid.equals(other.originUuid) && this.getProperty("creationTime").equals(other.getProperty("creationTime"));
    }
}

