/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.net.pubsub;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.extension.ExtendedMessageListener;
import lac.cnclib.net.groups.Group;
import lac.cnclib.net.groups.GroupCommunicationManager;
import lac.cnclib.net.pubsub.Information;
import lac.cnclib.net.pubsub.InformationData;
import lac.cnclib.net.pubsub.PublishSubscribeListener;
import lac.cnclib.net.pubsub.Subscription;
import lac.cnclib.net.pubsub.SubscriptionIdentification;
import lac.cnclib.net.pubsub.SubscriptionListener;
import lac.cnclib.net.pubsub.message.InformationDataMessage;
import lac.cnclib.net.pubsub.message.PublishSubscribeMessage;
import lac.cnclib.net.pubsub.message.SubscriptionMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;

public class PublishSubscribeCommunicationManager {
    protected static final int PUBSUB_CONTROL_GROUP = 100;
    protected static final int PUBSUB_DATA_GROUP = 101;
    private final NodeConnection nodeConnection;
    private final GroupCommunicationManager groupCommunicationManager;
    protected PublishSubscribeMessageListener advancedListener;
    protected List<PublishSubscribeListener> publishSubscribeListener;
    protected List<SubscriptionIdentification> subscriptionIds;

    public PublishSubscribeCommunicationManager(NodeConnection nodeConnection, GroupCommunicationManager groupCommunicationManager) {
        this.nodeConnection = nodeConnection;
        this.groupCommunicationManager = groupCommunicationManager;
        this.advancedListener = new PublishSubscribeMessageListener();
        nodeConnection.addExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.SUBSCRIPTION);
        nodeConnection.addExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.PUBSUBEVENT);
        this.subscriptionIds = new ArrayList<SubscriptionIdentification>();
        this.publishSubscribeListener = new ArrayList<PublishSubscribeListener>();
    }

    public void finalize() {
        this.subscriptionIds.clear();
        this.nodeConnection.removeExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.SUBSCRIPTION);
        this.nodeConnection.removeExtendedMessageListener(this.advancedListener, ClientLibProtocol.MSGType.PUBSUBEVENT);
    }

    public void registerPublisher(Information informationClass) throws IOException {
        this.groupCommunicationManager.joinGroup(new Group(100, informationClass.getInformationGroup()));
    }

    public void unregisterPublisher(Information informationClass) throws IOException {
        this.groupCommunicationManager.leaveGroup(new Group(100, informationClass.getInformationGroup()));
    }

    public void publish(InformationData informationData) throws IOException {
        informationData.addProperty("senderUuid", this.nodeConnection.getUuid().toString());
        informationData.addProperty("publicationTime", String.valueOf(System.currentTimeMillis()));
        InformationDataMessage informationMessage = new InformationDataMessage(informationData);
        Group informationGroup = new Group(101, informationData.getInformationGroup());
        this.sendPublishSubscribeMessage(informationMessage, informationGroup, ClientLibProtocol.MSGType.PUBSUBEVENT);
    }

    public SubscriptionIdentification subscribe(Subscription subscription, SubscriptionListener listener) throws IOException {
        SubscriptionIdentification subscriptionId = new SubscriptionIdentification(subscription, listener);
        this.processSubscription(subscriptionId);
        this.subscriptionIds.add(subscriptionId);
        return subscriptionId;
    }

    public boolean unsubscribe(SubscriptionIdentification subscriptionId) {
        return this.subscriptionIds.remove(subscriptionId);
    }

    private void processSubscription(SubscriptionIdentification subscription) throws IOException {
        this.groupCommunicationManager.joinGroup(subscription.getDataGroup());
        SubscriptionMessage message = new SubscriptionMessage(subscription.getSubscription());
        this.sendPublishSubscribeMessage(message, subscription.getControlGroup(), ClientLibProtocol.MSGType.SUBSCRIPTION);
    }

    private void sendPublishSubscribeMessage(Serializable messageContent, Group group, ClientLibProtocol.MSGType type) throws IOException {
        PublishSubscribeMessage pubsubMessage = new PublishSubscribeMessage();
        pubsubMessage.setContentObject(messageContent);
        pubsubMessage.setSenderID(this.nodeConnection.getUuid());
        pubsubMessage.setTagList(new ArrayList<String>());
        pubsubMessage.setType(type);
        pubsubMessage.addTag("_pubsubAPI");
        this.groupCommunicationManager.sendGroupcastMessage(pubsubMessage, group, type);
    }

    public void addPublishSubscribeListener(PublishSubscribeListener pubsubListener) {
        this.publishSubscribeListener.add(pubsubListener);
    }

    public void removePublishSubscribeListener(PublishSubscribeListener pubsubListener) {
        this.publishSubscribeListener.remove(pubsubListener);
    }

    protected class PublishSubscribeMessageListener
    implements ExtendedMessageListener {
        protected PublishSubscribeMessageListener() {
        }

        @Override
        public void newProtocolMessageReceived(NodeConnection remoteCon, Message message) {
            switch (message.getType()) {
                case SUBSCRIPTION: {
                    SubscriptionMessage subscriptionMessage = (SubscriptionMessage)message.getContentObject();
                    for (PublishSubscribeListener listener : PublishSubscribeCommunicationManager.this.publishSubscribeListener) {
                        listener.newSubscriptionReceived(subscriptionMessage.getSubscription());
                    }
                    break;
                }
                case PUBSUBEVENT: {
                    InformationDataMessage infoMessage = (InformationDataMessage)message.getContentObject();
                    for (PublishSubscribeListener listener : PublishSubscribeCommunicationManager.this.publishSubscribeListener) {
                        listener.newInformationReceived(infoMessage.getInformationData());
                    }
                    for (SubscriptionIdentification subscription : PublishSubscribeCommunicationManager.this.subscriptionIds) {
                        if (!subscription.getSubscription().getInformation().equals(infoMessage.getInformationData()) || !subscription.getSubscription().evaluation(infoMessage.getInformationData())) continue;
                        subscription.getListener().newInformationReceived(subscription.getSubscription(), infoMessage.getInformationData());
                    }
                    break;
                }
            }
        }
    }
}

