/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.sddl.message;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.serialization.Serialization;

public class ApplicationMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private byte[] content;
    private List<String> tagList;
    private UUID senderID;
    private UUID senderGatewayID;
    private UUID recipientID;
    private UUID recipientGatewayID;
    private String contentClassName;
    private long gatewayLogicalTime;
    protected ClientLibProtocol.MSGType msgType = ClientLibProtocol.MSGType.APPLICATION;
    private Serializable contentObject;
    private ClientLibProtocol.PayloadSerialization payloadType = ClientLibProtocol.PayloadSerialization.JAVA;

    public boolean hasContentObject() {
        return this.contentObject != null;
    }

    @Override
    public Serializable getContentObject() {
        if (this.contentObject == null) {
            switch (this.payloadType) {
                case JAVA: {
                    this.contentObject = Serialization.fromJavaByteStream(this.content);
                    break;
                }
                case JSON: {
                    this.contentObject = new String(this.content);
                    break;
                }
                default: {
                    this.contentObject = Serialization.fromJavaByteStream(this.content);
                }
            }
        }
        return this.contentObject;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContentObject(Serializable content) {
        if (content != null) {
            this.contentClassName = content.getClass().getCanonicalName();
            this.contentObject = content;
        }
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public List<String> getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    @Override
    public void addTag(String tag) {
        if (!this.getTagList().contains(tag)) {
            this.tagList.add(tag);
        }
    }

    @Override
    public void removeTag(String tag) {
        this.tagList.remove(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.getTagList().contains(tag);
    }

    @Override
    public UUID getSenderID() {
        return this.senderID;
    }

    @Override
    public void setSenderID(UUID senderID) {
        this.senderID = senderID;
    }

    @Override
    public UUID getSenderGatewayID() {
        return this.senderGatewayID;
    }

    @Override
    public void setSenderGatewayID(UUID senderGatewayID) {
        this.senderGatewayID = senderGatewayID;
    }

    @Override
    public UUID getRecipientID() {
        return this.recipientID;
    }

    @Override
    public void setRecipientID(UUID recipientID) {
        this.recipientID = recipientID;
    }

    @Override
    public UUID getRecipientGatewayID() {
        return this.recipientGatewayID;
    }

    @Override
    public void setRecipientGatewayID(UUID recipientGatewayID) {
        this.recipientGatewayID = recipientGatewayID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.gatewayLogicalTime);
        sb.append(System.getProperty("line.separator"));
        Serializable object = this.getContentObject();
        if (object != null) {
            sb.append(object.toString());
        } else {
            System.err.println("ApplicationMessage.toString()");
            sb.append("Impossible to unmarshall the Object Application!");
        }
        return sb.toString();
    }

    public void setTagList(LinkedList<String> tagList) {
        this.tagList = tagList;
    }

    @Override
    public long getGatewayLogicalTime() {
        return this.gatewayLogicalTime;
    }

    @Override
    public void setGatewayLogicalTime(long gatewayLogicalTime) {
        this.gatewayLogicalTime = gatewayLogicalTime;
    }

    @Override
    public ClientLibProtocol.MSGType getType() {
        return this.msgType;
    }

    public void setMsgType(ClientLibProtocol.MSGType msgType) {
        this.msgType = msgType;
    }

    @Override
    public void setType(ClientLibProtocol.MSGType type) {
        this.setMsgType(type);
    }

    @Override
    public ClientLibProtocol.PayloadSerialization getPayloadSerialization() {
        return this.payloadType;
    }

    @Override
    public void setPayloadType(ClientLibProtocol.PayloadSerialization payloadType) {
        this.payloadType = payloadType;
    }
}

